/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.tools.validator;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.xbean.finder.AnnotationFinder;
import org.talend.sdk.component.api.component.Icon;
import org.talend.sdk.component.api.component.Version;
import org.talend.sdk.component.runtime.manager.reflect.IconFinder;
import org.talend.sdk.component.tools.validator.Validator;
import org.talend.sdk.component.tools.validator.Validators;

public class MetadataValidator
implements Validator {
    private final Validators.ValidatorHelper helper;

    public MetadataValidator(Validators.ValidatorHelper helper) {
        this.helper = helper;
    }

    @Override
    public Stream<String> validate(AnnotationFinder finder, List<Class<?>> components) {
        return components.stream().flatMap(component -> {
            Stream<String> iconErrors = this.findIconsError((Class<?>)component);
            Stream<String> versionErrors = this.findVersionsError((Class<?>)component);
            return Stream.concat(iconErrors, versionErrors);
        }).filter(Objects::nonNull).sorted();
    }

    private Stream<String> findIconsError(Class<?> component) {
        IconFinder iconFinder = new IconFinder();
        if (iconFinder.findDirectIcon(component).isPresent()) {
            Icon icon = component.getAnnotation(Icon.class);
            ArrayList<String> messages = new ArrayList<String>();
            messages.add(this.helper.validateIcon(icon, messages));
            return messages.stream();
        }
        if (!iconFinder.findIndirectIcon(component).isPresent()) {
            return Stream.of("No @Icon on " + component);
        }
        return Stream.empty();
    }

    private Stream<String> findVersionsError(Class<?> component) {
        if (!component.isAnnotationPresent(Version.class)) {
            return Stream.of("Component " + component + " should use @Icon and @Version");
        }
        return Stream.empty();
    }
}

