/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.tools;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.talend.sdk.component.dependencies.maven.MvnCoordinateToFileConverter;
import org.talend.sdk.component.tools.Log;
import org.talend.sdk.component.tools.ReflectiveLog;
import org.talend.sdk.component.tools.exec.CarMain;

public class CarBundler
implements Runnable {
    private final Configuration configuration;
    private final Log log;

    public CarBundler(Configuration configuration, Object log) {
        this.configuration = configuration;
        try {
            this.log = Log.class.isInstance(log) ? (Log)Log.class.cast(log) : new ReflectiveLog(log);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void run() {
        String date = DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(LocalDateTime.now(ZoneId.of("UTC")));
        Properties metadata = new Properties();
        metadata.put("date", date);
        metadata.put("version", Optional.ofNullable(this.configuration.version).orElse("NC"));
        metadata.put("CarBundlerVersion", "1.64.7");
        metadata.put("component_coordinates", Optional.ofNullable(this.configuration.mainGav).orElseThrow(() -> new IllegalArgumentException("No component coordinates specified")));
        metadata.put("type", Optional.ofNullable(this.configuration.type).orElse("connector"));
        if (this.configuration.getCustomMetadata() != null) {
            this.configuration.getCustomMetadata().forEach(metadata::setProperty);
        }
        this.configuration.getOutput().getParentFile().mkdirs();
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().putValue("Main-Class", CarMain.class.getName());
        manifest.getMainAttributes().putValue("Created-By", "Talend Component Kit Tooling");
        manifest.getMainAttributes().putValue("Manifest-Version", "1.0");
        manifest.getMainAttributes().putValue("Build-Date", date);
        try (JarOutputStream zos = new JarOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(this.configuration.getOutput())), manifest);){
            HashSet<String> created = new HashSet<String>();
            Stream.of("TALEND-INF/", "META-INF/", "MAVEN-INF/", "MAVEN-INF/repository/").forEach(folder -> {
                try {
                    zos.putNextEntry(new JarEntry((String)folder));
                    zos.closeEntry();
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
                created.add(folder.substring(0, folder.length() - 1));
            });
            MvnCoordinateToFileConverter converter = new MvnCoordinateToFileConverter();
            this.configuration.getArtifacts().forEach((gav, file) -> {
                String path = "MAVEN-INF/repository/" + converter.toArtifact(gav).toPath();
                try {
                    this.createFolders(zos, created, path.split("/"));
                    zos.putNextEntry(new JarEntry(path));
                    Files.copy(file.toPath(), zos);
                    zos.closeEntry();
                }
                catch (IOException ioe) {
                    throw new IllegalStateException(ioe);
                }
            });
            zos.putNextEntry(new JarEntry("TALEND-INF/metadata.properties"));
            metadata.store(zos, "Generated metadata by Talend Component Kit Car Bundle");
            zos.closeEntry();
            String main = CarMain.class.getName().replace('.', '/') + ".class";
            this.createFolders(zos, created, main.split("/"));
            zos.putNextEntry(new JarEntry(main));
            try (InputStream stream = CarBundler.class.getClassLoader().getResourceAsStream(main);){
                int read;
                byte[] buffer = new byte[1024];
                while ((read = stream.read(buffer)) >= 0) {
                    zos.write(buffer, 0, read);
                }
            }
            zos.closeEntry();
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        this.log.info("Created " + this.configuration.getOutput());
    }

    private void createFolders(JarOutputStream zos, Collection<String> created, String[] parts) {
        IntStream.range(0, parts.length - 1).mapToObj(i -> Stream.of(parts).limit(i + 1).collect(Collectors.joining("/"))).filter(p -> !created.contains(p)).peek(folder -> {
            try {
                zos.putNextEntry(new JarEntry(folder + '/'));
                zos.closeEntry();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }).forEach(created::add);
    }

    public static class Configuration {
        private String mainGav;
        private String version;
        private Map<String, File> artifacts;
        private Map<String, String> customMetadata;
        private File output;
        private String type;

        public String getMainGav() {
            return this.mainGav;
        }

        public String getVersion() {
            return this.version;
        }

        public Map<String, File> getArtifacts() {
            return this.artifacts;
        }

        public Map<String, String> getCustomMetadata() {
            return this.customMetadata;
        }

        public File getOutput() {
            return this.output;
        }

        public String getType() {
            return this.type;
        }

        public void setMainGav(String mainGav) {
            this.mainGav = mainGav;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public void setArtifacts(Map<String, File> artifacts) {
            this.artifacts = artifacts;
        }

        public void setCustomMetadata(Map<String, String> customMetadata) {
            this.customMetadata = customMetadata;
        }

        public void setOutput(File output) {
            this.output = output;
        }

        public void setType(String type) {
            this.type = type;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Configuration)) {
                return false;
            }
            Configuration other = (Configuration)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$mainGav = this.getMainGav();
            String other$mainGav = other.getMainGav();
            if (this$mainGav == null ? other$mainGav != null : !this$mainGav.equals(other$mainGav)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            Map<String, File> this$artifacts = this.getArtifacts();
            Map<String, File> other$artifacts = other.getArtifacts();
            if (this$artifacts == null ? other$artifacts != null : !((Object)this$artifacts).equals(other$artifacts)) {
                return false;
            }
            Map<String, String> this$customMetadata = this.getCustomMetadata();
            Map<String, String> other$customMetadata = other.getCustomMetadata();
            if (this$customMetadata == null ? other$customMetadata != null : !((Object)this$customMetadata).equals(other$customMetadata)) {
                return false;
            }
            File this$output = this.getOutput();
            File other$output = other.getOutput();
            if (this$output == null ? other$output != null : !((Object)this$output).equals(other$output)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Configuration;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $mainGav = this.getMainGav();
            result = result * 59 + ($mainGav == null ? 43 : $mainGav.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            Map<String, File> $artifacts = this.getArtifacts();
            result = result * 59 + ($artifacts == null ? 43 : ((Object)$artifacts).hashCode());
            Map<String, String> $customMetadata = this.getCustomMetadata();
            result = result * 59 + ($customMetadata == null ? 43 : ((Object)$customMetadata).hashCode());
            File $output = this.getOutput();
            result = result * 59 + ($output == null ? 43 : ((Object)$output).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public String toString() {
            return "CarBundler.Configuration(mainGav=" + this.getMainGav() + ", version=" + this.getVersion() + ", artifacts=" + this.getArtifacts() + ", customMetadata=" + this.getCustomMetadata() + ", output=" + this.getOutput() + ", type=" + this.getType() + ")";
        }
    }
}

