/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.tools.validator;

import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.xbean.finder.AnnotationFinder;
import org.talend.sdk.component.api.configuration.Option;
import org.talend.sdk.component.api.meta.Documentation;
import org.talend.sdk.component.tools.validator.Validator;

public class DocumentationWordingValidator
implements Validator {
    private final Pattern correctWordingPattern = Pattern.compile("^[A-Z0-9]+.*\\.$");

    @Override
    public Stream<String> validate(AnnotationFinder finder, List<Class<?>> components) {
        String error = "@Documentation on '%s' is empty or is not capitalized or ends not by a dot.";
        Stream<String> componentWording = components.stream().filter(c -> c.isAnnotationPresent(Documentation.class)).filter(c -> this.isIncorrect(c.getAnnotation(Documentation.class))).map(c -> String.format("@Documentation on '%s' is empty or is not capitalized or ends not by a dot.", c.getName())).sorted();
        Stream<String> fieldWording = finder.findAnnotatedFields(Option.class).stream().filter(field -> field.isAnnotationPresent(Documentation.class)).filter(field -> this.isIncorrect(field.getAnnotation(Documentation.class))).map(c -> String.format("@Documentation on '%s' is empty or is not capitalized or ends not by a dot.", c.getName())).sorted();
        return Stream.concat(componentWording, fieldWording);
    }

    private boolean isIncorrect(Documentation annotation) {
        String value = annotation.value();
        return !this.correctWordingPattern.matcher(value).matches();
    }
}

