/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.tools.validator;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.apache.xbean.finder.AnnotationFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.api.exception.ComponentException;
import org.talend.sdk.component.tools.ComponentValidator;
import org.talend.sdk.component.tools.validator.Validator;
import org.talend.sdk.component.tools.validator.Validators;

public class ExceptionValidator
implements Validator {
    private static final Logger log = LoggerFactory.getLogger(ExceptionValidator.class);
    private final Validators.ValidatorHelper helper;
    private final ComponentValidator.Configuration configuration;

    public ExceptionValidator(Validators.ValidatorHelper helper, ComponentValidator.Configuration configuration) {
        this.helper = helper;
        this.configuration = configuration;
    }

    @Override
    public Stream<String> validate(AnnotationFinder finder, List<Class<?>> components) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Stream<String> errorsException = this.helper.componentClassFiles().flatMap(f -> this.streamClassesInDirectory(classLoader, null, (File)f)).filter(ComponentException.class::isAssignableFrom).map(e -> e.getName() + " inherits from ComponentException, this will lead to ClassNotFound errors in some environments. Use instead ComponentException directly!");
        if (this.configuration.isFailOnValidateExceptions()) {
            return errorsException;
        }
        errorsException.forEach(e -> log.error(e));
        return Stream.empty();
    }

    private Stream<Class> streamClassesInDirectory(ClassLoader loader, String pckg, File classFile) {
        if (classFile.isDirectory()) {
            return Arrays.stream(classFile.listFiles()).flatMap(f -> this.streamClassesInDirectory(loader, this.nextPackage(pckg, classFile.getName()), (File)f));
        }
        if (classFile.getName().endsWith(".class")) {
            String className = classFile.getName().substring(0, classFile.getName().lastIndexOf("."));
            String completeName = pckg + className;
            try {
                return Stream.of(loader.loadClass(completeName));
            }
            catch (Exception e) {
                log.error("Could not load class : " + completeName + "=>" + e.getMessage());
            }
        }
        return Stream.empty();
    }

    private String nextPackage(String current, String next) {
        return current == null ? "" : current + next + ".";
    }
}

