/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.xbean.finder.AnnotationFinder;
import org.apache.xbean.finder.archive.Archive;
import org.apache.xbean.finder.archive.ClasspathArchive;
import org.apache.xbean.finder.archive.CompositeArchive;
import org.apache.xbean.finder.filter.ExcludeIncludeFilter;
import org.apache.xbean.finder.filter.Filter;
import org.apache.xbean.finder.filter.Filters;
import org.apache.xbean.finder.filter.IncludeExcludeFilter;
import org.talend.sdk.component.api.input.Emitter;
import org.talend.sdk.component.api.input.PartitionMapper;
import org.talend.sdk.component.api.internationalization.Internationalized;
import org.talend.sdk.component.api.processor.Processor;
import org.talend.sdk.component.api.service.Service;
import org.talend.sdk.component.api.service.http.Request;
import org.talend.sdk.component.api.standalone.DriverRunner;

public class ScanTask
implements Runnable {
    private final Collection<File> scannedFiles;
    private final List<String> excludes;
    private final List<String> includes;
    private final String filterStrategy;
    private final File output;

    @Override
    public void run() {
        this.output.getParentFile().mkdirs();
        try (FileOutputStream stream = new FileOutputStream(this.output);){
            Properties properties = new Properties();
            properties.setProperty("classes.list", this.scanList().collect(Collectors.joining(",")));
            properties.store(stream, "generated by " + this.getClass() + " at " + new Date());
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    private Stream<String> scanList() {
        AnnotationFinder finder = this.newFinder();
        Filter filter = this.newFilter();
        return Stream.concat(Stream.of(PartitionMapper.class, Processor.class, Emitter.class, DriverRunner.class, Service.class, Internationalized.class).flatMap(it -> finder.findAnnotatedClasses(it).stream()), Stream.of(Request.class).flatMap(it -> finder.findAnnotatedMethods(it).stream()).map(Method::getDeclaringClass)).distinct().map(Class::getName).sorted().filter(arg_0 -> ((Filter)filter).accept(arg_0));
    }

    private Filter newFilter() {
        Filter accept = Optional.ofNullable(this.includes).filter(it -> it.size() > 0).map(i -> i.toArray(new String[0])).map(Filters::patterns).orElseGet(() -> name -> true);
        Filter reject = Optional.ofNullable(this.excludes).filter(it -> it.size() > 0).map(i -> i.toArray(new String[0])).map(Filters::patterns).orElseGet(() -> name -> false);
        if ("include-exclude".equals(this.filterStrategy)) {
            return new IncludeExcludeFilter(accept, reject);
        }
        return new ExcludeIncludeFilter(accept, reject);
    }

    private AnnotationFinder newFinder() {
        return new AnnotationFinder((Archive)new CompositeArchive((Archive[])this.scannedFiles.stream().map(c -> {
            try {
                return ClasspathArchive.archive((ClassLoader)Thread.currentThread().getContextClassLoader(), (URL)c.toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e);
            }
        }).toArray(Archive[]::new)));
    }

    @Generated
    public ScanTask(Collection<File> scannedFiles, List<String> excludes, List<String> includes, String filterStrategy, File output) {
        this.scannedFiles = scannedFiles;
        this.excludes = excludes;
        this.includes = includes;
        this.filterStrategy = filterStrategy;
        this.output = output;
    }
}

