/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.tools.validator;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.xbean.finder.AnnotationFinder;
import org.talend.sdk.component.api.input.Emitter;
import org.talend.sdk.component.api.input.PartitionMapper;
import org.talend.sdk.component.api.input.checkpoint.Checkpoint;
import org.talend.sdk.component.api.input.checkpoint.CheckpointAvailable;
import org.talend.sdk.component.api.input.checkpoint.CheckpointData;
import org.talend.sdk.component.runtime.manager.ParameterMeta;
import org.talend.sdk.component.tools.validator.Validator;
import org.talend.sdk.component.tools.validator.Validators;

public class CheckpointValidator
implements Validator {
    private final Validators.ValidatorHelper helper;

    public CheckpointValidator(Validators.ValidatorHelper helper) {
        this.helper = helper;
    }

    @Override
    public Stream<String> validate(AnnotationFinder finder, List<Class<?>> components) {
        Map checkpointingInputs = components.stream().filter(this::isSource).filter(this::hasAnyMethod).collect(Collectors.toMap(Function.identity(), this.helper::buildOrGetParameters));
        Stream<String> missingMethods = checkpointingInputs.keySet().stream().filter(c -> !this.hasNeededMethods((Class<?>)c)).map(c -> "Missing checkpoint method (@CheckpointData or @CheckpointAvailable) for " + c.getName() + ".");
        Stream<String> inputsWithoutCheckpoint = checkpointingInputs.entrySet().stream().filter(it -> CheckpointValidator.flatten((Collection)it.getValue()).noneMatch(prop -> "checkpoint".equals(prop.getMetadata().get("tcomp::configurationtype::type")))).map(it -> "The component " + ((Class)it.getKey()).getName() + " is missing a checkpoint in its configuration (see @Checkpoint).").sorted();
        Stream<String> invalidReturnClass = checkpointingInputs.keySet().stream().filter(c -> !this.hasCheckpointDataMethods((Class<?>)c)).map(c -> "should return a class marked as @Checkpoint for method @CheckpointData for " + c.getName() + ".");
        return Stream.of(missingMethods, inputsWithoutCheckpoint, invalidReturnClass).reduce(Stream::concat).orElseGet(Stream::empty);
    }

    private boolean isSource(Class<?> component) {
        return component.isAnnotationPresent(PartitionMapper.class) || component.isAnnotationPresent(Emitter.class);
    }

    private boolean hasAnyMethod(Class<?> component) {
        return Arrays.stream(component.getMethods()).anyMatch(m -> m.isAnnotationPresent(CheckpointData.class) || m.isAnnotationPresent(CheckpointAvailable.class));
    }

    private boolean hasNeededMethods(Class<?> component) {
        return Arrays.stream(component.getMethods()).anyMatch(m -> m.isAnnotationPresent(CheckpointData.class)) && Arrays.stream(component.getMethods()).anyMatch(m -> m.isAnnotationPresent(CheckpointAvailable.class));
    }

    private boolean hasCheckpointDataMethods(Class<?> component) {
        return Arrays.stream(component.getMethods()).filter(m -> m.isAnnotationPresent(CheckpointData.class)).filter(m -> m.getReturnType().isAnnotationPresent(Checkpoint.class)).findFirst().isPresent();
    }

    protected static Stream<ParameterMeta> flatten(Collection<ParameterMeta> options) {
        return options.stream().flatMap(it -> Stream.concat(Stream.of(it), it.getNestedParameters().isEmpty() ? Stream.empty() : CheckpointValidator.flatten(it.getNestedParameters())));
    }
}

