/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.tools;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.talend.sdk.component.runtime.base.lang.exception.InvocationExceptionWrapper;
import org.talend.sdk.component.tools.Log;

class ReflectiveLog
implements Log {
    private final Object delegate;
    private final Method error;
    private final Method debug;
    private final Method info;

    ReflectiveLog(Object delegate) throws NoSuchMethodException {
        this.delegate = delegate;
        this.error = this.findMethod("error");
        this.debug = this.findMethod("debug");
        this.info = this.findMethod("info");
    }

    private Method findMethod(String name) throws NoSuchMethodException {
        Class<?> delegateClass = this.delegate.getClass();
        try {
            return delegateClass.getMethod(name, String.class);
        }
        catch (NoSuchMethodException nsme) {
            return delegateClass.getMethod(name, CharSequence.class);
        }
    }

    @Override
    public void debug(String msg) {
        try {
            this.debug.invoke(this.delegate, msg);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw InvocationExceptionWrapper.toRuntimeException((InvocationTargetException)e);
        }
    }

    @Override
    public void error(String msg) {
        try {
            this.error.invoke(this.delegate, msg);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw InvocationExceptionWrapper.toRuntimeException((InvocationTargetException)e);
        }
    }

    @Override
    public void info(String msg) {
        try {
            this.info.invoke(this.delegate, msg);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw InvocationExceptionWrapper.toRuntimeException((InvocationTargetException)e);
        }
    }
}

