/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.tools;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.apache.batik.anim.dom.SVGOMSVGElement;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.svg.SVGAnimatedRect;
import org.w3c.dom.svg.SVGRect;

public class SvgValidator {
    private final SAXSVGDocumentFactory factory = new SAXSVGDocumentFactory(XMLResourceDescriptor.getXMLParserClassName());
    private final Boolean legacy;

    public SvgValidator(Boolean legacy) {
        this.legacy = legacy;
    }

    public Stream<String> validate(Path path) {
        SVGOMSVGElement icon;
        String prefix = "[" + path.getFileName() + "] ";
        try {
            icon = this.loadSvg(path);
        }
        catch (IllegalStateException e) {
            return Stream.of(prefix + "Invalid SVG: " + e.getMessage());
        }
        return Stream.of(this::noEmbedStyle, this::pathsAreClosed, this::noDisplayNone, this::viewportSize).map(fn -> (String)fn.apply(icon)).filter(Objects::nonNull).map(error -> prefix + error);
    }

    private SVGOMSVGElement loadSvg(Path path) {
        try {
            Document document = this.factory.createDocument(path.toUri().toASCIIString());
            return (SVGOMSVGElement)SVGOMSVGElement.class.cast(document.getDocumentElement());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private String viewportSize(SVGOMSVGElement icon) {
        SVGAnimatedRect viewBox = icon.getViewBox();
        int vb16 = 16;
        int vb40 = 40;
        if (viewBox == null) {
            return String.format("No viewBox, need one with '0 0 %d %d' (family) or '0 0 %d %d' (connector).", 16, 16, 40, 40);
        }
        SVGRect baseVal = viewBox.getBaseVal();
        if (baseVal.getX() != 0.0f || baseVal.getY() != 0.0f || baseVal.getHeight() != 16.0f && baseVal.getHeight() != 40.0f || baseVal.getWidth() != 16.0f && baseVal.getWidth() != 40.0f) {
            return String.format("viewBox must be '0 0 %d %d' (family) or '0 0 %d %d' (connector) found '%d %d %d %d'", 16, 16, 40, 40, (int)baseVal.getX(), (int)baseVal.getY(), (int)baseVal.getWidth(), (int)baseVal.getHeight());
        }
        return null;
    }

    private String pathsAreClosed(SVGOMSVGElement icon) {
        return this.browseDom((Node)icon, node -> {
            if ("path".equals(node.getNodeName())) {
                Node d;
                Node node2 = d = node.getAttributes() == null ? null : node.getAttributes().getNamedItem("d");
                if (d == null || d.getNodeValue() == null) {
                    return "Missing 'd' in a path";
                }
                if (!d.getNodeValue().toLowerCase(Locale.ROOT).endsWith("z")) {
                    return "All path must be closed so end with 'z', found value: '" + d.getNodeValue() + "'";
                }
            }
            return null;
        });
    }

    private String noEmbedStyle(SVGOMSVGElement icon) {
        return this.browseDom((Node)icon, node -> node.getNodeName().equals("style") ? "Forbidden <style> in icon" : null);
    }

    private String noDisplayNone(SVGOMSVGElement icon) {
        return this.browseDom((Node)icon, node -> {
            Node display;
            Node node2 = display = node.getAttributes() == null ? null : node.getAttributes().getNamedItem("display");
            if (display != null && display.getNodeValue() != null) {
                return display.getNodeValue().replaceAll(" +", "").equalsIgnoreCase("none") ? "'display:none' is forbidden in SVG icons" : null;
            }
            return null;
        });
    }

    private String browseDom(Node element, Function<Node, String> errorFactory) {
        String error = errorFactory.apply(element);
        if (error != null) {
            return error;
        }
        NodeList childNodes = element.getChildNodes();
        if (childNodes.getLength() > 0) {
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node node = childNodes.item(i);
                String error2 = errorFactory.apply(node);
                if (error2 != null) {
                    return error2;
                }
                error2 = this.browseDom(node, errorFactory);
                if (error2 == null) continue;
                return error2;
            }
        }
        return null;
    }
}

