/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.slf4j;

import java.io.PrintStream;
import java.util.Locale;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.helpers.MessageFormatter;

public class StdLogger
extends MarkerIgnoringBase {
    private final String name;
    private final boolean trace;
    private final boolean debug;
    private final boolean info;
    private final boolean warn;
    private final boolean error;

    StdLogger(String name) {
        this.name = name;
        String level = System.getProperty(((Object)((Object)this)).getClass().getName() + ".level", "info");
        switch (level.toLowerCase(Locale.ROOT)) {
            case "trace": {
                this.error = true;
                this.warn = true;
                this.info = true;
                this.debug = true;
                this.trace = true;
                break;
            }
            case "debug": {
                this.trace = false;
                this.error = true;
                this.warn = true;
                this.info = true;
                this.debug = true;
                break;
            }
            case "info": {
                this.debug = false;
                this.trace = false;
                this.error = true;
                this.warn = true;
                this.info = true;
                break;
            }
            case "warn": {
                this.info = false;
                this.debug = false;
                this.trace = false;
                this.error = true;
                this.warn = true;
                break;
            }
            case "error": {
                this.warn = false;
                this.info = false;
                this.debug = false;
                this.trace = false;
                this.error = true;
                break;
            }
            default: {
                this.debug = false;
                this.trace = false;
                this.error = true;
                this.warn = true;
                this.info = true;
            }
        }
    }

    public boolean isTraceEnabled() {
        return this.trace;
    }

    public void trace(String msg) {
        if (!this.trace) {
            return;
        }
        this.log("TRACE", msg, null, System.out);
    }

    public void trace(String format, Object arg) {
        if (!this.trace) {
            return;
        }
        this.log("TRACE", MessageFormatter.format((String)format, (Object)arg).getMessage(), null, System.out);
    }

    public void trace(String format, Object arg1, Object arg2) {
        if (!this.trace) {
            return;
        }
        this.log("TRACE", MessageFormatter.format((String)format, (Object)arg1, (Object)arg1).getMessage(), null, System.out);
    }

    public void trace(String format, Object ... arguments) {
        if (!this.trace) {
            return;
        }
        this.log("TRACE", MessageFormatter.arrayFormat((String)format, (Object[])arguments).getMessage(), null, System.out);
    }

    public void trace(String msg, Throwable throwable) {
        if (!this.trace) {
            return;
        }
        this.log("TRACE", msg, throwable, System.out);
    }

    public boolean isDebugEnabled() {
        return this.debug;
    }

    public void debug(String msg) {
        if (!this.debug) {
            return;
        }
        this.log("DEBUG", msg, null, System.out);
    }

    public void debug(String format, Object arg) {
        if (!this.debug) {
            return;
        }
        this.log("DEBUG", MessageFormatter.format((String)format, (Object)arg).getMessage(), null, System.out);
    }

    public void debug(String format, Object arg1, Object arg2) {
        if (!this.debug) {
            return;
        }
        this.log("DEBUG", MessageFormatter.format((String)format, (Object)arg1, (Object)arg1).getMessage(), null, System.out);
    }

    public void debug(String format, Object ... arguments) {
        if (!this.debug) {
            return;
        }
        this.log("DEBUG", MessageFormatter.arrayFormat((String)format, (Object[])arguments).getMessage(), null, System.out);
    }

    public void debug(String msg, Throwable throwable) {
        if (!this.debug) {
            return;
        }
        this.log("DEBUG", msg, throwable, System.out);
    }

    public boolean isInfoEnabled() {
        return this.info;
    }

    public void info(String msg) {
        if (!this.info) {
            return;
        }
        this.log("INFO", msg, null, System.out);
    }

    public void info(String format, Object arg) {
        if (!this.info) {
            return;
        }
        this.log("INFO", MessageFormatter.format((String)format, (Object)arg).getMessage(), null, System.out);
    }

    public void info(String format, Object arg1, Object arg2) {
        if (!this.info) {
            return;
        }
        this.log("INFO", MessageFormatter.format((String)format, (Object)arg1, (Object)arg1).getMessage(), null, System.out);
    }

    public void info(String format, Object ... arguments) {
        if (!this.info) {
            return;
        }
        this.log("INFO", MessageFormatter.arrayFormat((String)format, (Object[])arguments).getMessage(), null, System.out);
    }

    public void info(String msg, Throwable throwable) {
        if (!this.info) {
            return;
        }
        this.log("INFO", msg, throwable, System.out);
    }

    public boolean isWarnEnabled() {
        return this.warn;
    }

    public void warn(String msg) {
        if (!this.warn) {
            return;
        }
        this.log("WARN", msg, null, System.out);
    }

    public void warn(String format, Object arg) {
        if (!this.warn) {
            return;
        }
        this.log("WARN", MessageFormatter.format((String)format, (Object)arg).getMessage(), null, System.out);
    }

    public void warn(String format, Object arg1, Object arg2) {
        if (!this.warn) {
            return;
        }
        this.log("WARN", MessageFormatter.format((String)format, (Object)arg1, (Object)arg1).getMessage(), null, System.out);
    }

    public void warn(String format, Object ... arguments) {
        if (!this.warn) {
            return;
        }
        this.log("WARN", MessageFormatter.arrayFormat((String)format, (Object[])arguments).getMessage(), null, System.out);
    }

    public void warn(String msg, Throwable throwable) {
        if (!this.warn) {
            return;
        }
        this.log("WARN", msg, throwable, System.out);
    }

    public boolean isErrorEnabled() {
        return this.error;
    }

    public void error(String msg) {
        if (!this.error) {
            return;
        }
        this.log("ERROR", msg, null, System.err);
    }

    public void error(String format, Object arg) {
        if (!this.error) {
            return;
        }
        this.log("ERROR", MessageFormatter.format((String)format, (Object)arg).getMessage(), null, System.err);
    }

    public void error(String format, Object arg1, Object arg2) {
        if (!this.error) {
            return;
        }
        this.log("ERROR", MessageFormatter.format((String)format, (Object)arg1, (Object)arg1).getMessage(), null, System.err);
    }

    public void error(String format, Object ... arguments) {
        if (!this.error) {
            return;
        }
        this.log("ERROR", MessageFormatter.arrayFormat((String)format, (Object[])arguments).getMessage(), null, System.err);
    }

    public void error(String msg, Throwable throwable) {
        if (!this.error) {
            return;
        }
        this.log("ERROR", msg, throwable, System.err);
    }

    private void log(String level, String message, Throwable throwable, PrintStream out) {
        StringBuilder builder = new StringBuilder(message.length() + level.length() + 3).append('[').append(level).append("] ").append(message);
        out.println(builder);
        if (throwable != null) {
            throwable.printStackTrace(out);
        }
        out.flush();
    }

    public String getName() {
        return this.name;
    }
}

