/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.maven;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="dependencies", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, threadSafe=true)
public class DependencyMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="compile,runtime", readonly=true)
    private List<String> scopes;
    @Parameter(defaultValue="${project.build.outputDirectory}/TALEND-INF/dependencies.txt", property="talend.dependency.output")
    private File output;

    public void execute() throws MojoExecutionException {
        String content = this.project.getArtifacts().stream().filter(a -> this.scopes == null || this.scopes.contains(a.getScope())).map(a -> String.format("%s:%s:%s%s:%s:%s", a.getGroupId(), a.getArtifactId(), a.getType(), a.getClassifier() == null || a.getClassifier().isEmpty() ? "" : ":" + a.getClassifier(), a.getBaseVersion(), a.getScope())).collect(Collectors.joining("\n"));
        this.output.getParentFile().mkdirs();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.output));){
            writer.write(content);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }
}

