/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.maven;

import java.util.Collection;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.talend.sdk.component.tools.WebServer;

@Mojo(name="web", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class WebMojo
extends AbstractMojo {
    @Parameter
    private Collection<String> serverArguments;
    @Parameter(property="talend.web.port", defaultValue="8080")
    private Integer port;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${settings}", readonly=true)
    private Settings settings;

    public void execute() {
        String originalRepoSystProp = System.getProperty("talend.component.server.maven.repository");
        System.setProperty("talend.component.server.maven.repository", this.settings.getLocalRepository());
        try {
            new WebServer(this.serverArguments, this.port, (Object)this.getLog(), String.format("%s:%s:%s", this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion())).run();
        }
        finally {
            if (originalRepoSystProp == null) {
                System.clearProperty("talend.component.server.maven.repository");
            } else {
                System.setProperty("talend.component.server.maven.repository", originalRepoSystProp);
            }
        }
    }
}

