/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.maven;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.MustacheFactory;
import com.github.mustachejava.ObjectHandler;
import com.github.mustachejava.reflect.ReflectionObjectHandler;
import com.github.mustachejava.util.DecoratedCollection;
import com.github.mustachejava.util.Wrapper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.AccessibleObject;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.OptionsBuilder;
import org.asciidoctor.SafeMode;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.talend.sdk.component.maven.ComponentDependenciesBase;
import org.talend.sdk.component.maven.api.Audience;

@Audience(value=Audience.Type.TALEND_INTERNAL)
@Mojo(name="website", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class WebsiteBuilderMojo
extends ComponentDependenciesBase {
    @Parameter(defaultValue="src/main/talend/website", property="talend.website-builder.directory")
    protected String websiteDir;
    @Parameter(defaultValue="${project.build.directory}/talend/website", property="talend.website-builder.output")
    protected String output;
    @Parameter(defaultValue="${reactorProjects}", readonly=true)
    private List<MavenProject> reactorProjects;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="true", property="talend-website-builder.cleanBeforeGeneration")
    private boolean cleanBeforeGeneration;
    @Parameter(defaultValue="false", property="talend-website-builder.publishOnGithubPages")
    private boolean publishOnGithubPages;
    @Parameter(defaultValue="talend-component-website", property="talend-website-builder.githubPagesServerId")
    private String githubPagesServerId;
    @Parameter(defaultValue="${project.scm.url}", property="talend-website-builder.githubPagesUrl")
    private String githubPagesUrl;
    @Parameter(defaultValue="refs/heads/gh-pages", property="talend-website-builder.githubPagesBranch")
    private String githubPagesBranch;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Component
    private SettingsDecrypter settingsDecrypter;
    private Asciidoctor asciidoctor;

    @Override
    protected void doExecute() throws MojoFailureException {
        List<Project> components = this.findProjectsWithCar();
        if (components.isEmpty()) {
            throw new MojoFailureException("No component found in: " + this.reactorProjects);
        }
        DefaultMustacheFactory mustacheFactory = new DefaultMustacheFactory(){
            {
                this.setObjectHandler((ObjectHandler)new ReflectionObjectHandler(){

                    public Wrapper find(String name, List<Object> scopes) {
                        Wrapper wrapper = super.find(name, scopes);
                        return s -> {
                            Object call = wrapper.call(s);
                            if (Collection.class.isInstance(call) && !DecoratedCollection.class.isInstance(call)) {
                                return new DecoratedCollection((Collection)Collection.class.cast(call));
                            }
                            return call;
                        };
                    }

                    protected AccessibleObject findMember(Class sClass, String name) {
                        if (sClass == String.class && "value".equals(name)) {
                            return null;
                        }
                        return super.findMember(sClass, name);
                    }
                });
            }

            public void encode(String value, Writer writer) {
                try {
                    writer.write(value);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        };
        Path root = this.mkdirs(Paths.get(this.output, new String[0]));
        if (this.cleanBeforeGeneration) {
            try {
                this.deleteFolder(root);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        components.forEach(it -> this.generateComponent((Project)it, root, (MustacheFactory)mustacheFactory));
        Map<String, List<Project>> globalContext = Collections.singletonMap("components", components);
        this.generateDefault(globalContext, () -> {
            try {
                return Files.newBufferedWriter(root.resolve("index.html"), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }, (MustacheFactory)mustacheFactory, "main-index");
        this.generateFolder(globalContext, root, this.project.getBasedir().toPath().resolve(this.websiteDir), (MustacheFactory)mustacheFactory);
        if (this.publishOnGithubPages) {
            this.pulishGhPages(root);
        }
    }

    private void pulishGhPages(final Path root) {
        Server server = this.session.getSettings().getServer(this.githubPagesServerId);
        Server decryptedServer = Optional.ofNullable(server).map(s -> this.settingsDecrypter.decrypt((SettingsDecryptionRequest)new DefaultSettingsDecryptionRequest(s))).map(SettingsDecryptionResult::getServer).orElse(server);
        final Path gitCloneBase = this.mkdirs(Paths.get(this.project.getBuild().getDirectory(), new String[0]).resolve(UUID.randomUUID().toString()));
        UsernamePasswordCredentialsProvider credentialsProvider = new UsernamePasswordCredentialsProvider(decryptedServer.getUsername(), decryptedServer.getPassword());
        try (Git git = ((CloneCommand)Git.cloneRepository().setCredentialsProvider((CredentialsProvider)credentialsProvider)).setURI(this.githubPagesUrl).setDirectory(gitCloneBase.toFile()).setBranchesToClone(Collections.singleton(this.githubPagesBranch)).setBranch(this.githubPagesBranch).call();){
            this.deleteFolder(gitCloneBase);
            Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    String relative = root.relativize(file).toString();
                    Path target = gitCloneBase.resolve(relative);
                    WebsiteBuilderMojo.this.mkdirs(target.getParent());
                    Files.copy(file, target, new CopyOption[0]);
                    return super.visitFile(file, attrs);
                }
            });
            String message = "Updating the website with version " + this.project.getVersion() + " // " + new Date().toString();
            git.add().addFilepattern(".").call();
            git.commit().setAll(true).setMessage(message).call();
            git.status().call();
            ((PushCommand)git.push().setCredentialsProvider((CredentialsProvider)credentialsProvider)).add(this.githubPagesBranch).call();
            this.getLog().info((CharSequence)("Updated the website on " + ZonedDateTime.now()));
        }
        catch (IOException | GitAPIException e) {
            throw new IllegalStateException(e);
        }
    }

    private void deleteFolder(Path base) throws IOException {
        Files.walkFileTree(base, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                return dir.getFileName().toString().startsWith(".git") ? FileVisitResult.SKIP_SUBTREE : FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return super.visitFile(file, attrs);
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                if (Files.list(dir).count() == 0L) {
                    Files.delete(dir);
                }
                return super.postVisitDirectory(dir, exc);
            }
        });
    }

    private void generateComponent(Project project, Path root, MustacheFactory mustacheFactory) {
        Path dir = this.mkdirs(root.resolve(project.project.getArtifactId()));
        this.generateFolder(project, dir, this.project.getBasedir().toPath().resolve(this.websiteDir), mustacheFactory);
        Path templatesDir = project.project.getBasedir().toPath().resolve(this.websiteDir);
        this.generateFolder(project, dir, templatesDir, mustacheFactory);
        if (!Files.exists(templatesDir.resolve("index.mustache"), new LinkOption[0])) {
            this.generateDefault(project, () -> {
                try {
                    return Files.newBufferedWriter(dir.resolve("index.html"), new OpenOption[0]);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }, mustacheFactory, "default-index");
        }
        if (!Files.exists(dir.resolve("documentation.html"), new LinkOption[0])) {
            Path doc = Paths.get(project.project.getBuild().getOutputDirectory(), new String[0]).resolve("TALEND-INF/documentation.adoc");
            if (Files.exists(doc, new LinkOption[0])) {
                this.asciidoc2Html(doc, dir.resolve("documentation.html"), mustacheFactory);
            } else {
                this.getLog().warn((CharSequence)"No documentation found, ensure to generate it before generating the site");
            }
        }
        try {
            Files.copy(project.car, dir.resolve(project.car.getFileName().toString()), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private void asciidoc2Html(Path doc, Path target, MustacheFactory mustacheFactory) {
        try {
            String html = (this.asciidoctor == null ? (this.asciidoctor = Asciidoctor.Factory.create()) : this.asciidoctor).convert(new String(Files.readAllBytes(doc), StandardCharsets.UTF_8), OptionsBuilder.options().baseDir(doc.getParent().toFile()).backend("html5").safe(SafeMode.SECURE).docType("article").mkDirs(true));
            this.generateDefault(Collections.singletonMap("html", html), () -> {
                try {
                    return Files.newBufferedWriter(target, new OpenOption[0]);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }, mustacheFactory, "default-layout");
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private void generateDefault(Object context, Supplier<Writer> writerSupplier, MustacheFactory mustacheFactory, String name) {
        try (InputStreamReader tpl = new InputStreamReader(Objects.requireNonNull(this.findTemplate(name)), StandardCharsets.UTF_8);
             Writer writer = writerSupplier.get();){
            mustacheFactory.compile((Reader)tpl, name).execute(writer, context);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private InputStream findTemplate(String name) {
        Path override = this.project.getBasedir().toPath().resolve("templates").resolve(this.websiteDir).resolve(name + ".mustache");
        if (Files.exists(override, new LinkOption[0])) {
            try {
                return Files.newInputStream(override, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(((Object)((Object)this)).getClass().getSimpleName() + '/' + name + ".mustache");
    }

    private void generateFolder(Object context, Path dir, Path templatesDir, MustacheFactory mustacheFactory) {
        if (!Files.exists(templatesDir, new LinkOption[0])) {
            return;
        }
        try {
            Files.list(templatesDir).filter(it -> it.endsWith(".mustache")).forEach(template -> {
                String name = template.getFileName().toString();
                try (BufferedReader tpl = Files.newBufferedReader(template);
                     BufferedWriter writer = Files.newBufferedWriter(dir.resolve(name.substring(0, name.length() - "mustache".length()) + "html"), new OpenOption[0]);){
                    mustacheFactory.compile((Reader)tpl, dir.getFileName().toString() + '_' + name).execute((Writer)writer, context);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            });
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.synchronizeAssets(templatesDir, dir);
    }

    private void synchronizeAssets(final Path templatesDir, final Path dir) {
        Stream.of("css", "js", "images").map(templatesDir::resolve).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).forEach(src -> {
            try {
                Files.walkFileTree(src, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        String relative = templatesDir.relativize(file).toString();
                        Path target = dir.resolve(relative);
                        WebsiteBuilderMojo.this.mkdirs(target.getParent());
                        Files.copy(file, target, StandardCopyOption.REPLACE_EXISTING);
                        return super.visitFile(file, attrs);
                    }
                });
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        });
    }

    private List<Project> findProjectsWithCar() {
        return this.reactorProjects.stream().filter(it -> "jar".equals(it.getPackaging())).map(project -> new Project((MavenProject)project, WebsiteBuilderMojo.toCarPath(project))).filter(p -> Files.exists(((Project)p).car, new LinkOption[0])).collect(Collectors.toList());
    }

    private Path mkdirs(Path root) {
        if (!Files.exists(root, new LinkOption[0])) {
            try {
                Files.createDirectories(root, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
        return root;
    }

    private static Path toCarPath(MavenProject project) {
        return Paths.get(project.getBuild().getDirectory(), new String[0]).resolve(project.getBuild().getFinalName() + ".car");
    }

    private static class Project {
        private final MavenProject project;
        private final Path car;

        public String getCarName() {
            return this.car.getFileName().toString();
        }

        public MavenProject getProject() {
            return this.project;
        }

        public Path getCar() {
            return this.car;
        }

        public Project(MavenProject project, Path car) {
            this.project = project;
            this.car = car;
        }
    }
}

