/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.maven;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.aether.artifact.Artifact;
import org.talend.sdk.component.maven.ComponentDependenciesBase;
import org.talend.sdk.component.maven.api.Audience;

@Audience(value=Audience.Type.TALEND_INTERNAL)
public abstract class CarConsumer
extends ComponentDependenciesBase {
    @Parameter(defaultValue="component", property="talend.repository.classifier")
    protected String classifier;

    protected Set<Artifact> getComponentsCar(Set<Artifact> artifacts) {
        return artifacts.stream().map(art -> this.resolve((Artifact)art, this.classifier, "car")).collect(Collectors.toSet());
    }

    protected Set<Artifact> getComponentArtifacts() {
        return this.getArtifacts(it -> {
            try (JarFile file = new JarFile(it.getFile());){
                Artifact artifact = Optional.ofNullable(file.getEntry("TALEND-INF/dependencies.txt")).map(ok -> it).orElse(null);
                return artifact;
            }
            catch (IOException e) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }
}

