/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.maven;

import java.io.File;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class DependencyAwareMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;

    protected Map<String, File> artifacts() {
        Map<String, File> artifacts = this.project.getArtifacts().stream().filter(a -> !"org.talend.sdk.component".equals(a.getGroupId()) && ("compile".equals(a.getScope()) || "runtime".equals(a.getScope()))).collect(Collectors.toMap(a -> String.format("%s:%s:%s%s:%s:%s", a.getGroupId(), a.getArtifactId(), Optional.ofNullable(a.getType()).orElse("jar"), a.getClassifier() == null || a.getClassifier().isEmpty() ? "" : ":" + a.getClassifier(), this.getVersion((Artifact)a), Optional.ofNullable(a.getScope()).orElse("compile")), Artifact::getFile));
        String mainGav = this.mainGav();
        artifacts.putIfAbsent(mainGav, new File(this.project.getBuild().getDirectory(), this.project.getBuild().getFinalName() + "." + ("bundle".equals(this.project.getPackaging()) ? "jar" : this.project.getPackaging())));
        return artifacts;
    }

    private String getVersion(Artifact a) {
        return Optional.ofNullable(a.getBaseVersion()).orElseGet(() -> ((Artifact)a).getVersion());
    }

    protected String mainGav() {
        return String.format("%s:%s:%s", this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion());
    }
}

