/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.maven;

import com.google.cloud.tools.jib.api.AbsoluteUnixPath;
import com.google.cloud.tools.jib.api.FilePermissions;
import com.google.cloud.tools.jib.api.JibContainerBuilder;
import com.google.cloud.tools.jib.api.LayerConfiguration;
import com.google.cloud.tools.jib.api.Port;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Instant;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.eclipse.aether.artifact.Artifact;
import org.talend.sdk.component.maven.BuildComponentM2RepositoryMojo;
import org.talend.sdk.component.maven.api.Audience;
import org.talend.sdk.component.maven.docker.JibHelper;

@Audience(value=Audience.Type.TALEND_INTERNAL)
@Mojo(name="image", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true, requiresDependencyResolution=ResolutionScope.TEST)
public class ImageM2Mojo
extends BuildComponentM2RepositoryMojo {
    @Parameter(property="talend-image.fromImage", defaultValue="openjdk:8-jre-alpine")
    private String fromImage;
    @Parameter(property="talend-image.creationTime")
    private String creationTime;
    @Parameter(property="talend-image.workingDirectory", defaultValue="/opt/talend")
    private String workingDirectory;
    @Parameter(property="talend-image.toImage")
    private String toImage;
    @Parameter(property="talend-image.repository")
    private String repository;
    @Parameter(property="talend-image.versionProperty")
    private String versionProperty;
    @Parameter(property="talend-image.mainDependenciesScope", defaultValue="compile")
    private String mainDependenciesScope;
    @Parameter(property="talend-image.additionalFiles", defaultValue="/opt/talend/addons")
    private String additionalFiles;
    @Parameter(property="talend-image.additionalFile")
    private List<File> additionalFile;
    @Parameter
    private Map<String, String> labels;
    @Parameter
    private Map<String, String> environment;
    @Parameter
    private List<String> entryPoint;
    @Parameter(property="talend-image.layersCacheDirectory", defaultValue="${project.build.directory}/maven/build/cache")
    private File layersCacheDirectory;
    @Parameter(property="talend-image.dockerExecutable")
    private File dockerExecutable;
    @Parameter(property="talend-image.laggyPushWorkaroundRetries", defaultValue="0")
    private int laggyPushWorkaround;
    @Parameter
    private Map<String, String> dockerEnvironment;
    @Parameter
    private List<Integer> ports;
    @Parameter(property="talend-image.mainLibFolder", defaultValue="main-libs")
    private String mainLibFolder;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Component
    private SettingsDecrypter settingsDecrypter;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void doExecute() throws MojoExecutionException {
        try {
            try (JibHelper jibHelper = new JibHelper(this.getLog(), this.project.getBuild().getDirectory(), this.layersCacheDirectory, this.repository, this.dockerEnvironment, this.dockerExecutable, this.laggyPushWorkaround);){
                jibHelper.prepare(this.project.getArtifactId(), this.project.getVersion(), this.project.getProperties(), this.fromImage, this.toImage, this.creationTime, this.workingDirectory, this::createWorkingDirectory, this.environment, this.labels);
                this.addLayers(jibHelper.getBuilder());
                if (this.ports != null) {
                    this.ports.stream().map(Port::tcp).forEach(arg_0 -> ((JibContainerBuilder)jibHelper.getBuilder()).addExposedPort(arg_0));
                }
                this.getLog().info((CharSequence)"Creating the image (can be long)");
                jibHelper.build("Talend Image Maven Plugin", () -> Optional.ofNullable(this.session.getSettings().getServer(this.repository)).map(it -> this.settingsDecrypter.decrypt((SettingsDecryptionRequest)new DefaultSettingsDecryptionRequest(it))).map(SettingsDecryptionResult::getServer).orElse(null));
                if (this.versionProperty != null) {
                    jibHelper.setProperties(this.project, this.versionProperty);
                }
            }
            if (!this.m2Root.exists()) return;
        }
        catch (Exception e) {
            try {
                throw new MojoExecutionException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                if (!this.m2Root.exists()) throw throwable;
                try {
                    Files.walkFileTree(this.m2Root.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            file.toFile().delete();
                            return super.visitFile(file, attrs);
                        }

                        @Override
                        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                            dir.toFile().delete();
                            return super.postVisitDirectory(dir, exc);
                        }
                    });
                    throw throwable;
                }
                catch (IOException e2) {
                    this.getLog().warn((CharSequence)e2.getMessage(), (Throwable)e2);
                }
                throw throwable;
            }
        }
        try {
            Files.walkFileTree(this.m2Root.toPath(), (FileVisitor<? super Path>)new /* invalid duplicate definition of identical inner class */);
            return;
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)e.getMessage(), (Throwable)e);
            return;
        }
    }

    private String createWorkingDirectory() {
        String wd = "/opt/talend/" + this.project.getArtifactId().replace("-docker", "");
        this.getLog().info((CharSequence)("Automatic working directory set to '" + wd + "', set <workingDirectory> to force its value"));
        return wd;
    }

    private void addLayers(JibContainerBuilder builder) {
        Set<Artifact> components = this.getComponentArtifacts();
        Set<Artifact> cars = this.getComponentsCar(components);
        List<String> coordinates = cars.stream().map(car -> {
            LayerConfiguration.Builder layerBuilder = LayerConfiguration.builder();
            layerBuilder.setName(car.getArtifactId() + " component stack");
            AtomicLong size = new AtomicLong();
            String gav = this.copyComponentDependencies((Artifact)car, (entry, read) -> {
                String depPath = entry.getName().substring("MAVEN-INF/repository/".length());
                File src = this.copyFile((ZipEntry)entry, (InputStream)read, depPath);
                size.addAndGet(src.length());
                AbsoluteUnixPath target = AbsoluteUnixPath.get((String)this.workingDirectory).resolve(depPath);
                Path srcPath = src.toPath().toAbsolutePath();
                layerBuilder.addEntry(srcPath, target, (FilePermissions)LayerConfiguration.DEFAULT_FILE_PERMISSIONS_PROVIDER.apply(srcPath, target), this.lastModified(src.toPath()));
            });
            return gav == null ? null : new Layer(layerBuilder.build(), size.get(), gav);
        }).filter(Objects::nonNull).distinct().sorted(Comparator.comparing(Layer::getSize).reversed()).peek(it -> builder.addLayer(((Layer)it).layerConfiguration)).peek(it -> this.getLog().info((CharSequence)("Prepared layer for '" + ((Layer)it).gav + "' dependencies (" + this.toSize(((Layer)it).size) + ")"))).map(it -> ((Layer)it).gav).collect(Collectors.toList());
        LayerConfiguration.Builder componentsLayerBuilder = LayerConfiguration.builder().setName("Components " + components.stream().sorted(Comparator.comparing(Object::toString)).collect(Collectors.toList()));
        AtomicLong componentSize = new AtomicLong();
        components.forEach(it -> {
            Path from = it.getFile().toPath().toAbsolutePath();
            componentSize.addAndGet(it.getFile().length());
            AbsoluteUnixPath target = AbsoluteUnixPath.get((String)this.workingDirectory).resolve(this.repositorySystemSession.getLocalRepository().getBasedir().toPath().toAbsolutePath().relativize(from));
            componentsLayerBuilder.addEntry(from, target, (FilePermissions)LayerConfiguration.DEFAULT_FILE_PERMISSIONS_PROVIDER.apply(from, target), this.lastModified(from));
        });
        this.writeRegistry(this.getNewComponentRegistry(coordinates));
        this.writeDigest(this.getDigests());
        Path registryLocation = this.getRegistry().toPath().toAbsolutePath();
        Path digestRegistryLocation = this.getDigestRegistry().toPath().toAbsolutePath();
        AbsoluteUnixPath registryTarget = AbsoluteUnixPath.get((String)this.workingDirectory).resolve(registryLocation.getFileName().toString());
        AbsoluteUnixPath digestRegistryTarget = AbsoluteUnixPath.get((String)this.workingDirectory).resolve(digestRegistryLocation.getFileName().toString());
        Stream.of(new AbstractMap.SimpleEntry<Path, AbsoluteUnixPath>(registryLocation, registryTarget), new AbstractMap.SimpleEntry<Path, AbsoluteUnixPath>(digestRegistryLocation, digestRegistryTarget)).forEach(it -> componentsLayerBuilder.addEntry((Path)it.getKey(), (AbsoluteUnixPath)it.getValue(), (FilePermissions)LayerConfiguration.DEFAULT_FILE_PERMISSIONS_PROVIDER.apply(it.getKey(), it.getValue()), this.lastModified((Path)it.getKey())));
        builder.addLayer(componentsLayerBuilder.build());
        this.getLog().info((CharSequence)("Prepared layer for components " + cars.toString().replace(":car", "") + " (" + this.toSize(componentSize.get()) + ")"));
        if (this.project.getArtifact() != null && this.project.getArtifact().getFile() != null && !"pom".equals(this.project.getArtifact().getType())) {
            LayerConfiguration.Builder dependenciesLayer = LayerConfiguration.builder().setName("Main Dependencies");
            Path path = this.project.getArtifact().getFile().toPath().toAbsolutePath();
            AbsoluteUnixPath mainLibs = this.mainLibFolder != null && !this.mainLibFolder.trim().isEmpty() && this.mainLibFolder.startsWith("/") ? AbsoluteUnixPath.get((String)this.mainLibFolder) : AbsoluteUnixPath.get((String)this.workingDirectory).resolve(this.mainLibFolder);
            AtomicLong mainDepSize = new AtomicLong();
            List classpath = this.project.getArtifacts().stream().filter(it -> this.mainDependenciesScope == null || this.mainDependenciesScope.equalsIgnoreCase(it.getScope())).map(it -> {
                Path dep = it.getFile().toPath().toAbsolutePath();
                String relativized = this.repositorySystemSession.getLocalRepository().getBasedir().toPath().toAbsolutePath().relativize(dep).toString();
                mainDepSize.addAndGet(it.getFile().length());
                AbsoluteUnixPath targetPath = mainLibs.resolve(relativized.replace(File.separatorChar, '/'));
                dependenciesLayer.addEntry(dep, targetPath, (FilePermissions)LayerConfiguration.DEFAULT_FILE_PERMISSIONS_PROVIDER.apply(dep, targetPath), this.lastModified(dep));
                return targetPath.toString();
            }).collect(Collectors.toList());
            builder.addLayer(dependenciesLayer.build());
            this.getLog().info((CharSequence)("Prepared layer for main dependencies (" + this.toSize(mainDepSize.get()) + ")"));
            if (this.additionalFile != null && !this.additionalFile.isEmpty()) {
                AtomicLong additionalFilesSize = new AtomicLong();
                try {
                    builder.addLayer(this.additionalFile.stream().filter(File::exists).map(f -> {
                        additionalFilesSize.addAndGet(f.length());
                        return f.toPath();
                    }).collect(Collectors.toList()), AbsoluteUnixPath.get((String)this.additionalFiles.replace("${workingDirectory}", this.workingDirectory)));
                    this.getLog().info((CharSequence)("Prepared layer for additional files (" + this.toSize(mainDepSize.get()) + ")"));
                }
                catch (IOException e) {
                    this.getLog().error((CharSequence)"Unable to add the additional files layer.", (Throwable)e);
                    throw new IllegalStateException(e);
                }
            } else {
                this.getLog().debug((CharSequence)"No additional file");
            }
            AbsoluteUnixPath mainPath = mainLibs.resolve(path.getFileName());
            classpath.add(mainPath.toString());
            builder.addLayer(LayerConfiguration.builder().setName(this.project.getArtifactId() + " @" + this.project.getVersion()).addEntry(path, mainPath, (FilePermissions)LayerConfiguration.DEFAULT_FILE_PERMISSIONS_PROVIDER.apply(path, mainPath), this.lastModified(path)).build());
            this.getLog().info((CharSequence)("Prepared layer for main artifact (" + this.toSize(path.toFile().length()) + ")"));
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("> classpath=" + classpath));
            }
            if (this.entryPoint != null) {
                String cp = String.join((CharSequence)":", classpath);
                List newEntrypoint = this.entryPoint.stream().map(it -> this.replaceEntrypointPlaceholders((String)it, cp)).collect(Collectors.toList());
                builder.setEntrypoint(newEntrypoint);
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Entrypoint set to " + newEntrypoint));
                }
            }
        } else {
            this.getLog().info((CharSequence)"No artifact attached to this project");
        }
    }

    private Instant lastModified(Path path) {
        return Instant.ofEpochMilli(Math.max(this.getInternalLastModified(path), new Date(1000L).getTime()));
    }

    private long getInternalLastModified(Path path) {
        try {
            return Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
        }
        catch (IOException ioe) {
            return path.toFile().lastModified();
        }
    }

    private String toSize(long size) {
        Size b = new Size(size, Size.SizeUnit.BYTES);
        Size mb = b.to(Size.SizeUnit.MEGABYTES);
        Size kb = b.to(Size.SizeUnit.KILOBYTES);
        if (mb.size > 0L) {
            return mb.toString();
        }
        if (kb.size > 0L) {
            return kb.toString();
        }
        return b.toString();
    }

    private String replaceEntrypointPlaceholders(String it, String cp) {
        return it.replace("@classpath@", cp);
    }

    private static class Layer {
        private final LayerConfiguration layerConfiguration;
        private final long size;
        private final String gav;

        public Layer(LayerConfiguration layerConfiguration, long size, String gav) {
            this.layerConfiguration = layerConfiguration;
            this.size = size;
            this.gav = gav;
        }

        public LayerConfiguration getLayerConfiguration() {
            return this.layerConfiguration;
        }

        public long getSize() {
            return this.size;
        }

        public String getGav() {
            return this.gav;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Layer)) {
                return false;
            }
            Layer other = (Layer)o;
            if (!other.canEqual(this)) {
                return false;
            }
            LayerConfiguration this$layerConfiguration = this.getLayerConfiguration();
            LayerConfiguration other$layerConfiguration = other.getLayerConfiguration();
            if (this$layerConfiguration == null ? other$layerConfiguration != null : !this$layerConfiguration.equals(other$layerConfiguration)) {
                return false;
            }
            if (this.getSize() != other.getSize()) {
                return false;
            }
            String this$gav = this.getGav();
            String other$gav = other.getGav();
            return !(this$gav == null ? other$gav != null : !this$gav.equals(other$gav));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Layer;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            LayerConfiguration $layerConfiguration = this.getLayerConfiguration();
            result = result * 59 + ($layerConfiguration == null ? 43 : $layerConfiguration.hashCode());
            long $size = this.getSize();
            result = result * 59 + (int)($size >>> 32 ^ $size);
            String $gav = this.getGav();
            result = result * 59 + ($gav == null ? 43 : $gav.hashCode());
            return result;
        }

        public String toString() {
            return "ImageM2Mojo.Layer(layerConfiguration=" + this.getLayerConfiguration() + ", size=" + this.getSize() + ", gav=" + this.getGav() + ")";
        }
    }

    public static class Size {
        private final long size;
        private final SizeUnit unit;

        public Size(long size, SizeUnit unit) {
            this.size = size;
            this.unit = unit;
        }

        public Size to(SizeUnit unit) {
            return new Size(unit.convert(this.size, this.unit), unit);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.size);
            if (this.unit != null) {
                sb.append(" ");
                sb.append(this.unit.name().toLowerCase(Locale.ENGLISH));
            }
            return sb.toString();
        }

        public static enum SizeUnit {
            BYTES{

                @Override
                public long toBytes(long s) {
                    return s;
                }

                @Override
                public long toKilobytes(long s) {
                    return s / 1024L;
                }

                @Override
                public long toMegabytes(long s) {
                    return s / 0x100000L;
                }

                @Override
                public long convert(long s, SizeUnit u) {
                    return u.toBytes(s);
                }

                public String toString() {
                    return "b";
                }
            }
            ,
            KILOBYTES{

                @Override
                public long toBytes(long s) {
                    return SizeUnit.x(s, 1024L, 0x1FFFFFFFFFFFFFL);
                }

                @Override
                public long toKilobytes(long s) {
                    return s;
                }

                @Override
                public long toMegabytes(long s) {
                    return s / 1024L;
                }

                @Override
                public long convert(long s, SizeUnit u) {
                    return u.toKilobytes(s);
                }

                public String toString() {
                    return "kb";
                }
            }
            ,
            MEGABYTES{

                @Override
                public long toBytes(long s) {
                    return SizeUnit.x(s, 0x100000L, 0x7FFFFFFFFFFL);
                }

                @Override
                public long toKilobytes(long s) {
                    return SizeUnit.x(s, 1024L, 0x1FFFFFFFFFFFFFL);
                }

                @Override
                public long toMegabytes(long s) {
                    return s;
                }

                @Override
                public long convert(long s, SizeUnit u) {
                    return u.toMegabytes(s);
                }

                public String toString() {
                    return "mb";
                }
            };

            private static final long B0 = 1L;
            private static final long B1 = 1024L;
            private static final long B2 = 0x100000L;

            private static long x(long d, long m, long over) {
                if (d > over) {
                    return Long.MAX_VALUE;
                }
                if (d < -over) {
                    return Long.MIN_VALUE;
                }
                return d * m;
            }

            public abstract long toBytes(long var1);

            public abstract long toKilobytes(long var1);

            public abstract long toMegabytes(long var1);

            public abstract long convert(long var1, SizeUnit var3);
        }
    }
}

