/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.maven;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.talend.sdk.component.dependencies.maven.Artifact;
import org.talend.sdk.component.dependencies.maven.MvnDependencyListLocalRepositoryResolver;
import org.talend.sdk.component.maven.Bootstrap;
import org.talend.sdk.component.maven.ComponentDependenciesBase;
import org.talend.sdk.component.maven.api.Audience;

@Audience(value=Audience.Type.TALEND_INTERNAL)
@Mojo(name="repository-report", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true, requiresDependencyResolution=ResolutionScope.TEST)
public class DependencyConflictsReporterMojo
extends ComponentDependenciesBase {
    @Parameter(property="talend-dependencies-conflicts.output", defaultValue="${maven.multiModuleProjectDirectory}/target/talend-component-kit/repository-dependency-report.html")
    private File output;
    @Parameter(defaultValue="Dependency Report", property="talend-dependencies-conflicts.title")
    private String title;
    @Parameter(property="talend-dependencies-conflicts.css")
    private String css;
    @Parameter(property="talend-dependencies-conflicts.js")
    private String js;

    @Override
    public void doExecute() throws MojoExecutionException {
        MvnDependencyListLocalRepositoryResolver resolver = new MvnDependencyListLocalRepositoryResolver("TALEND-INF/dependencies.txt", it -> null);
        Collection modules = this.getArtifacts(artifact -> {
            try (JarFile file = new JarFile(artifact.getFile());){
                Item item = Optional.ofNullable(file.getEntry("TALEND-INF/dependencies.txt")).map(entry -> {
                    Throwable throwable;
                    InputStream stream;
                    Predicate<Artifact> ignoredDependencies = it -> false;
                    JarEntry blacklistEntry = file.getJarEntry("TALEND-INF/dependencies-blacklist.txt");
                    List<Artifact> blacklist = Collections.emptyList();
                    if (blacklistEntry != null) {
                        try {
                            stream = file.getInputStream(blacklistEntry);
                            throwable = null;
                            try {
                                blacklist = resolver.resolveFromDescriptor(stream).sorted(Comparator.comparing(Artifact::toCoordinate)).collect(Collectors.toList());
                                ignoredDependencies = blacklist::contains;
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (stream != null) {
                                    if (throwable != null) {
                                        try {
                                            stream.close();
                                        }
                                        catch (Throwable throwable3) {
                                            throwable.addSuppressed(throwable3);
                                        }
                                    } else {
                                        stream.close();
                                    }
                                }
                            }
                        }
                        catch (IOException e) {
                            throw new IllegalStateException(e);
                        }
                    }
                    try {
                        stream = file.getInputStream((ZipEntry)entry);
                        throwable = null;
                        try {
                            Item item = new Item(new Artifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getExtension(), artifact.getClassifier(), this.getVersion((org.eclipse.aether.artifact.Artifact)artifact), "compile"), blacklist, resolver.resolveFromDescriptor(stream).filter(ignoredDependencies.negate()).sorted(Comparator.comparing(Artifact::toCoordinate)).collect(Collectors.toList()));
                            return item;
                        }
                        catch (Throwable throwable4) {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (stream != null) {
                                if (throwable != null) {
                                    try {
                                        stream.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable.addSuppressed(throwable5);
                                    }
                                } else {
                                    stream.close();
                                }
                            }
                        }
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(e);
                    }
                }).orElse(null);
                return item;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }).filter(Objects::nonNull).sorted(Comparator.comparing(a -> ((Item)a).componentModule.toCoordinate())).collect(Collectors.toList());
        this.output.getParentFile().mkdirs();
        Map<Artifact, ConflictingDependency> conflicts = this.detectConflicts(modules);
        Bootstrap bootstrap = new Bootstrap();
        try (PrintStream stream = new PrintStream(new FileOutputStream(this.output));){
            stream.println("<!DOCTYPE html>");
            stream.println("<html lang=\"en\">");
            stream.println(" <head>");
            stream.println("    <meta charset=\"utf-8\">");
            stream.println("    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1, shrink-to-fit=no\">");
            stream.println("    <title>" + this.title + "</title>");
            if (this.css != null && !this.css.isEmpty()) {
                stream.println(this.css);
            } else {
                bootstrap.css(stream);
            }
            stream.println(" </head>");
            stream.println(" <body>");
            stream.println("   <div class=\"container\">");
            stream.println("     <h1>Dependencies Report</h1>");
            if (!conflicts.isEmpty()) {
                stream.println("     <div class=\"alert alert-danger\" role=\"alert\">");
                stream.println("       <strong>Danger!</strong> some dependencies conflict detected!");
                stream.println("     </div>");
            }
            if (modules.stream().flatMap(it -> it.getDependencies().stream()).anyMatch(this::isSnapshot)) {
                stream.println("     <div class=\"alert alert-warning\" role=\"alert\">");
                stream.println("       <strong>Warning!</strong> some dependencies are in snapshot!");
                stream.println("     </div>");
            }
            stream.println("     <ul class=\"nav nav-tabs\" id=\"tabs\" role=\"tablist\">");
            stream.println("       <li class=\"nav-item\">");
            stream.print("         <a class=\"nav-link active\" data-toggle=\"tab\" role=\"tab\" aria-selected=\"true\"");
            stream.println("id=\"conflicts-tab\" href=\"#conflicts\" aria-controls=\"conflicts\">Conflicts</a>");
            stream.println("       </li>");
            stream.println("       <li class=\"nav-item\">");
            stream.print("         <a class=\"nav-link\" data-toggle=\"tab\" role=\"tab\" aria-selected=\"true\"");
            stream.println("id=\"global-tab\" href=\"#global\" aria-controls=\"global\">Global</a>");
            stream.println("       </li>");
            stream.println("       <li class=\"nav-item\">");
            stream.print("         <a class=\"nav-link\" data-toggle=\"tab\" role=\"tab\" aria-selected=\"true\"");
            stream.println("id=\"blacklist-tab\" href=\"#blacklist\" aria-controls=\"blacklist\">Blacklist</a>");
            stream.println("       </li>");
            stream.println("     </ul>");
            stream.println("     <div class=\"tab-content\">");
            stream.println("       <div class=\"tab-pane active\" id=\"conflicts\" role=\"tabpanel\" aria-labelledby=\"conflicts-tab\">");
            stream.println("         <h2>Conflicting Dependencies Report</h2>");
            this.writeTable(stream, () -> conflicts.forEach((conflictingDep, meta) -> {
                meta.getModules().stream().limit(1L).forEach(module -> {
                    stream.println("             <tr>");
                    stream.println("               <td>" + StringEscapeUtils.escapeHtml4((String)(conflictingDep.getGroup() + ':' + conflictingDep.getArtifact() + ":[" + ((ConflictingDependency)meta).versions.stream().map(Artifact::getVersion).collect(Collectors.joining("|")))) + "</td>");
                    stream.println("               <td>" + StringEscapeUtils.escapeHtml4((String)module.toCoordinate()) + "</td>");
                    stream.println("             </tr>");
                });
                meta.getModules().stream().skip(1L).forEach(module -> {
                    stream.println("             <tr>");
                    stream.println("               <td></td>");
                    stream.println("               <td>" + StringEscapeUtils.escapeHtml4((String)module.toCoordinate()) + "</td>");
                    stream.println("             </tr>");
                });
            }), () -> {
                stream.println("                 <td scope=\"col\">Dependency</td>");
                stream.println("                 <td scope=\"col\">Module</td>");
            });
            stream.println("       </div>");
            stream.println("       <div class=\"tab-pane\" id=\"global\" role=\"tabpanel\" aria-labelledby=\"global-tab\">");
            stream.println("         <h2>Global Dependencies Report</h2>");
            this.writeDependencyList(stream, modules, conflicts.keySet(), Item::getDependencies);
            stream.println("       </div>");
            stream.println("       <div class=\"tab-pane\" id=\"blacklist\" role=\"tabpanel\" aria-labelledby=\"blacklist-tab\">");
            stream.println("         <h2>Repository Dependencies Blacklist</h2>");
            this.writeDependencyList(stream, modules, Collections.emptyList(), Item::getBlacklist);
            stream.println("       </div>");
            stream.println("     </div>");
            stream.println(" </div>");
            if (this.js != null && !this.js.isEmpty()) {
                stream.println(this.js);
            } else {
                bootstrap.js(stream);
            }
            stream.println(" </body>");
            stream.println("</html>");
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private String getVersion(org.eclipse.aether.artifact.Artifact artifact) {
        return Optional.ofNullable(artifact.getBaseVersion()).orElseGet(() -> ((org.eclipse.aether.artifact.Artifact)artifact).getVersion());
    }

    private boolean isSnapshot(Artifact it) {
        return !it.getGroup().startsWith("org.talend.components") && it.getVersion().contains("-SNAPSHOT");
    }

    private void writeDependencyList(PrintStream stream, Collection<Item> modules, Collection<Artifact> conflicts, Function<Item, Collection<Artifact>> extractor) {
        this.writeTable(stream, () -> modules.forEach(it -> {
            Collection deps = (Collection)extractor.apply((Item)it);
            deps.stream().limit(1L).forEach(dep -> {
                stream.println("             <tr" + (conflicts.contains(dep) ? " class=\"table-danger\"" : (this.isSnapshot((Artifact)dep) ? " class=\"table-warning\"" : "")) + ">");
                stream.println("               <td>" + StringEscapeUtils.escapeHtml4((String)((Item)it).componentModule.toCoordinate()) + "</td>");
                stream.println("               <td>" + StringEscapeUtils.escapeHtml4((String)dep.toCoordinate()) + "</td>");
                stream.println("             </tr>");
            });
            deps.stream().skip(1L).forEach(dep -> {
                stream.println("             <tr" + (conflicts.contains(dep) ? " class=\"table-danger\"" : "") + ">");
                stream.println("               <td></td>");
                stream.println("               <td>" + StringEscapeUtils.escapeHtml4((String)dep.toCoordinate()) + "</td>");
                stream.println("             </tr>");
            });
        }), () -> {
            stream.println("                 <td scope=\"col\">Module</td>");
            stream.println("                 <td scope=\"col\">Dependency</td>");
        });
    }

    private void writeTable(PrintStream stream, Runnable content, Runnable columns) {
        stream.println("         <div class=\"col-sm-12\">");
        stream.println("           <table class=\"table table-bordered table-striped\">");
        stream.println("             <thead class=\"thead-dark\">");
        stream.println("               <tr>");
        columns.run();
        stream.println("               </tr>");
        stream.println("             </thead>");
        stream.println("             <tbody>");
        content.run();
        stream.println("             </tbody>");
        stream.println("           </table>");
        stream.println("         </div>");
    }

    private Map<Artifact, ConflictingDependency> detectConflicts(Collection<Item> modules) {
        return modules.stream().flatMap(it -> it.getDependencies().stream().map(dep -> new AbstractMap.SimpleEntry<Artifact, List<Artifact>>((Artifact)dep, Collections.singletonList(it.getComponentModule())))).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue, (l1, l2) -> Stream.concat(l1.stream(), l2.stream()).collect(Collectors.toList()))).entrySet().stream().filter(it -> ((List)it.getValue()).size() > 1).collect(Collectors.toMap(Map.Entry::getKey, it -> new ConflictingDependency(Collections.singleton(it.getKey()), (Collection)it.getValue()))).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (d1, d2) -> new ConflictingDependency(Stream.concat(((ConflictingDependency)d1).versions.stream(), ((ConflictingDependency)d2).versions.stream()).distinct().collect(Collectors.toList()), Stream.concat(((ConflictingDependency)d1).modules.stream(), ((ConflictingDependency)d2).modules.stream()).distinct().collect(Collectors.toList())))).entrySet().stream().filter(it -> ((ConflictingDependency)it.getValue()).getVersions().size() > 1).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static class ConflictingDependency {
        private final Collection<Artifact> versions;
        private final Collection<Artifact> modules;

        public ConflictingDependency(Collection<Artifact> versions, Collection<Artifact> modules) {
            this.versions = versions;
            this.modules = modules;
        }

        public Collection<Artifact> getVersions() {
            return this.versions;
        }

        public Collection<Artifact> getModules() {
            return this.modules;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConflictingDependency)) {
                return false;
            }
            ConflictingDependency other = (ConflictingDependency)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Collection<Artifact> this$versions = this.getVersions();
            Collection<Artifact> other$versions = other.getVersions();
            if (this$versions == null ? other$versions != null : !((Object)this$versions).equals(other$versions)) {
                return false;
            }
            Collection<Artifact> this$modules = this.getModules();
            Collection<Artifact> other$modules = other.getModules();
            return !(this$modules == null ? other$modules != null : !((Object)this$modules).equals(other$modules));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ConflictingDependency;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Collection<Artifact> $versions = this.getVersions();
            result = result * 59 + ($versions == null ? 43 : ((Object)$versions).hashCode());
            Collection<Artifact> $modules = this.getModules();
            result = result * 59 + ($modules == null ? 43 : ((Object)$modules).hashCode());
            return result;
        }

        public String toString() {
            return "DependencyConflictsReporterMojo.ConflictingDependency(versions=" + this.getVersions() + ", modules=" + this.getModules() + ")";
        }
    }

    private static class Item {
        private final Artifact componentModule;
        private final Collection<Artifact> blacklist;
        private final List<Artifact> dependencies;

        public Item(Artifact componentModule, Collection<Artifact> blacklist, List<Artifact> dependencies) {
            this.componentModule = componentModule;
            this.blacklist = blacklist;
            this.dependencies = dependencies;
        }

        public Artifact getComponentModule() {
            return this.componentModule;
        }

        public Collection<Artifact> getBlacklist() {
            return this.blacklist;
        }

        public List<Artifact> getDependencies() {
            return this.dependencies;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Item)) {
                return false;
            }
            Item other = (Item)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Artifact this$componentModule = this.getComponentModule();
            Artifact other$componentModule = other.getComponentModule();
            if (this$componentModule == null ? other$componentModule != null : !this$componentModule.equals(other$componentModule)) {
                return false;
            }
            Collection<Artifact> this$blacklist = this.getBlacklist();
            Collection<Artifact> other$blacklist = other.getBlacklist();
            if (this$blacklist == null ? other$blacklist != null : !((Object)this$blacklist).equals(other$blacklist)) {
                return false;
            }
            List<Artifact> this$dependencies = this.getDependencies();
            List<Artifact> other$dependencies = other.getDependencies();
            return !(this$dependencies == null ? other$dependencies != null : !((Object)this$dependencies).equals(other$dependencies));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Item;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Artifact $componentModule = this.getComponentModule();
            result = result * 59 + ($componentModule == null ? 43 : $componentModule.hashCode());
            Collection<Artifact> $blacklist = this.getBlacklist();
            result = result * 59 + ($blacklist == null ? 43 : ((Object)$blacklist).hashCode());
            List<Artifact> $dependencies = this.getDependencies();
            result = result * 59 + ($dependencies == null ? 43 : ((Object)$dependencies).hashCode());
            return result;
        }

        public String toString() {
            return "DependencyConflictsReporterMojo.Item(componentModule=" + this.getComponentModule() + ", blacklist=" + this.getBlacklist() + ", dependencies=" + this.getDependencies() + ")";
        }
    }
}

