/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.maven;

import com.google.cloud.tools.jib.api.Containerizer;
import com.google.cloud.tools.jib.api.DockerDaemonImage;
import com.google.cloud.tools.jib.api.Jib;
import com.google.cloud.tools.jib.api.JibContainerBuilder;
import com.google.cloud.tools.jib.api.RegistryImage;
import com.google.cloud.tools.jib.configuration.CacheDirectoryCreationException;
import com.google.cloud.tools.jib.configuration.LayerConfiguration;
import com.google.cloud.tools.jib.configuration.Port;
import com.google.cloud.tools.jib.event.EventHandlers;
import com.google.cloud.tools.jib.filesystem.AbsoluteUnixPath;
import com.google.cloud.tools.jib.image.ImageReference;
import com.google.cloud.tools.jib.image.InvalidImageReferenceException;
import com.google.cloud.tools.jib.registry.RegistryException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.eclipse.aether.artifact.Artifact;
import org.talend.sdk.component.maven.BuildComponentM2RepositoryMojo;
import org.talend.sdk.component.maven.api.Audience;

@Audience(value=Audience.Type.TALEND_INTERNAL)
@Mojo(name="image", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true, requiresDependencyResolution=ResolutionScope.TEST)
public class ImageM2Mojo
extends BuildComponentM2RepositoryMojo {
    @Parameter(property="talend-image.fromImage", defaultValue="openjdk:8-jre-alpine")
    private String fromImage;
    @Parameter(property="talend-image.creationTime")
    private String creationTime;
    @Parameter(property="talend-image.workingDirectory", defaultValue="/opt/talend")
    private String workingDirectory;
    @Parameter(property="talend-image.toImage")
    private String toImage;
    @Parameter(property="talend-image.repository")
    private String repository;
    @Parameter(property="talend-image.versionProperty")
    private String versionProperty;
    @Parameter(property="talend-image.mainDependenciesScope", defaultValue="compile")
    private String mainDependenciesScope;
    @Parameter
    private Map<String, String> labels;
    @Parameter
    private Map<String, String> environment;
    @Parameter
    private List<String> entryPoint;
    @Parameter(property="talend-image.layersCacheDirectory", defaultValue="${project.build.directory}/maven/build/cache")
    private File layersCacheDirectory;
    @Parameter(property="talend-image.dockerExecutable")
    private File dockerExecutable;
    @Parameter(property="talend-image.laggyPushWorkaroundRetries", defaultValue="0")
    private int laggyPushWorkaround;
    @Parameter
    private Map<String, String> dockerEnvironment;
    @Parameter
    private List<Integer> ports;
    @Parameter(property="talend-image.mainLibFolder", defaultValue="main-libs")
    private String mainLibFolder;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Component
    private SettingsDecrypter settingsDecrypter;

    @Override
    public void doExecute() throws MojoExecutionException {
        ExecutorService executor = Executors.newCachedThreadPool(new ThreadFactory(){
            private final AtomicInteger id = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable runnable) {
                return new Thread(runnable, String.format("%s %d", this.getClass().getName() + "-", this.id.getAndIncrement()));
            }
        });
        try {
            String projectVersion;
            JibContainerBuilder builder = Jib.from((ImageReference)ImageReference.parse((String)this.fromImage));
            builder.setCreationTime(this.creationTime == null || this.creationTime.trim().isEmpty() ? Instant.now() : Instant.parse(this.creationTime));
            builder.setWorkingDirectory(AbsoluteUnixPath.get((String)(this.workingDirectory == null ? this.createWorkingDirectory() : this.workingDirectory)));
            if (this.environment != null) {
                builder.setEnvironment(this.environment);
            }
            String tag = (projectVersion = this.project.getVersion()).endsWith("-SNAPSHOT") ? projectVersion.replace("-SNAPSHOT", "") + "_" + Optional.ofNullable(this.project.getProperties().getProperty("git.branch")).map(it -> it.replace('/', '_') + '_').orElse("") + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) : projectVersion;
            String image = this.toImage == null ? this.project.getArtifactId() : this.toImage;
            String imageName = (this.repository == null || this.repository.trim().isEmpty() ? "" : this.repository + '/') + image + ':' + tag;
            if (this.labels != null) {
                builder.setLabels(this.labels.entrySet().stream().peek(it -> it.setValue(((String)it.getValue()).replace("@imageName@", imageName))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
            }
            this.addLayers(builder);
            if (this.ports != null) {
                this.ports.stream().map(Port::tcp).forEach(arg_0 -> ((JibContainerBuilder)builder).addExposedPort(arg_0));
            }
            this.getLog().info((CharSequence)"Creating the image (can be long)");
            if (this.repository != null) {
                if (this.laggyPushWorkaround > 0) {
                    this.toLocalDocker(executor, builder, tag, imageName);
                    this.hackyPush(tag, imageName);
                } else {
                    RegistryImage registryImage = RegistryImage.named((String)imageName);
                    Server credentials = this.session.getSettings().getServer(this.repository);
                    if (credentials != null) {
                        credentials = Optional.ofNullable(this.settingsDecrypter.decrypt((SettingsDecryptionRequest)new DefaultSettingsDecryptionRequest(credentials))).map(SettingsDecryptionResult::getServer).orElse(credentials);
                        registryImage.addCredential(credentials.getUsername(), credentials.getPassword());
                    }
                    builder.containerize(this.configureContainer(Containerizer.to((RegistryImage)registryImage), executor));
                    this.getLog().info((CharSequence)("Pushed image='" + imageName + "', tag='" + tag + "'"));
                }
            } else {
                this.toLocalDocker(executor, builder, tag, imageName);
            }
            if (this.versionProperty != null) {
                String repo = this.repository == null ? "" : this.repository;
                this.project.getProperties().put(this.versionProperty, imageName);
                this.project.getProperties().put(this.versionProperty + ".repository", repo);
                this.project.getProperties().put(this.versionProperty + ".repositoryPrefixed", repo.isEmpty() ? "" : repo + '/');
                this.project.getProperties().put(this.versionProperty + ".image", image);
                this.project.getProperties().put(this.versionProperty + ".version", tag);
            }
            executor.shutdownNow();
        }
        catch (Exception e) {
            try {
                throw new MojoExecutionException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                executor.shutdownNow();
                if (this.m2Root.exists()) {
                    try {
                        Files.walkFileTree(this.m2Root.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                            @Override
                            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                                file.toFile().delete();
                                return super.visitFile(file, attrs);
                            }

                            @Override
                            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                                dir.toFile().delete();
                                return super.postVisitDirectory(dir, exc);
                            }
                        });
                    }
                    catch (IOException e2) {
                        this.getLog().warn((CharSequence)e2.getMessage(), (Throwable)e2);
                    }
                }
                throw throwable;
            }
        }
        if (this.m2Root.exists()) {
            try {
                Files.walkFileTree(this.m2Root.toPath(), (FileVisitor<? super Path>)new /* invalid duplicate definition of identical inner class */);
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hackyPush(String tag, String imageName) throws IOException, InterruptedException, MojoExecutionException {
        this.getLog().warn((CharSequence)"Using push workaround for nasty registries (using exec directly on 'docker'), it is highly recommended to not use laggyPushWorkaround configuration if you can");
        Server credentials = this.session.getSettings().getServer(this.repository);
        credentials = Optional.ofNullable(credentials).map(it -> this.settingsDecrypter.decrypt((SettingsDecryptionRequest)new DefaultSettingsDecryptionRequest(it))).map(SettingsDecryptionResult::getServer).orElse(credentials);
        if (credentials != null) {
            File credFile = new File(this.project.getBuild().getDirectory(), "talend-component-docker-credentials.temp");
            credFile.getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(credFile);){
                writer.write(credentials.getPassword());
            }
            try {
                ProcessBuilder processBuilder = new ProcessBuilder("docker", "login", this.repository, "--username", credentials.getUsername(), "--password-stdin");
                processBuilder.redirectError(ProcessBuilder.Redirect.INHERIT);
                processBuilder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
                processBuilder.redirectInput(ProcessBuilder.Redirect.from(credFile));
                int exitCode = processBuilder.start().waitFor();
                if (exitCode != 0) {
                    this.getLog().warn((CharSequence)("Can't login, got status: " + exitCode));
                }
            }
            finally {
                if (!credFile.delete()) {
                    credFile.deleteOnExit();
                }
            }
        }
        boolean ok = false;
        for (int i = 0; i < this.laggyPushWorkaround; ++i) {
            int exit = new ProcessBuilder("docker", "push", imageName).inheritIO().start().waitFor();
            if (exit == 0) {
                ok = true;
                this.getLog().info((CharSequence)("Pushed image='" + imageName + "', tag='" + tag + "'"));
                break;
            }
            this.getLog().warn((CharSequence)("Push #" + (i + 1) + " got " + exit + " exit status"));
        }
        if (!ok) {
            throw new MojoExecutionException("Push didn't succeed");
        }
    }

    private void toLocalDocker(ExecutorService executor, JibContainerBuilder builder, String tag, String imageName) throws InvalidImageReferenceException, InterruptedException, ExecutionException, IOException, CacheDirectoryCreationException, RegistryException {
        DockerDaemonImage docker = DockerDaemonImage.named((String)imageName);
        if (this.dockerEnvironment != null) {
            docker.setDockerEnvironment(this.dockerEnvironment);
        }
        if (this.dockerExecutable != null) {
            docker.setDockerExecutable(this.dockerExecutable.toPath());
        }
        builder.containerize(this.configureContainer(Containerizer.to((DockerDaemonImage)docker), executor));
        this.getLog().info((CharSequence)("Built local image='" + imageName + "', tag='" + tag + "'"));
    }

    private Containerizer configureContainer(Containerizer to, ExecutorService executor) {
        return to.setExecutorService(executor).setApplicationLayersCache(this.layersCacheDirectory.toPath()).setBaseImageLayersCache(this.layersCacheDirectory.toPath()).setToolName("Talend Image Maven Plugin").setEventHandlers(new EventHandlers());
    }

    private String createWorkingDirectory() {
        String wd = "/opt/talend/" + this.project.getArtifactId().replace("-docker", "");
        this.getLog().info((CharSequence)("Automatic working directory set to '" + wd + "', set <workingDirectory> to force its value"));
        return wd;
    }

    private void addLayers(JibContainerBuilder builder) {
        Set<Artifact> components = this.getComponentArtifacts();
        Set<Artifact> cars = this.getComponentsCar(components);
        List<String> coordinates = cars.stream().map(car -> {
            LayerConfiguration.Builder layerBuilder = LayerConfiguration.builder();
            layerBuilder.setName(car.getArtifactId() + " component stack");
            AtomicLong size = new AtomicLong();
            String gav = this.copyComponentDependencies((Artifact)car, (entry, read) -> {
                String depPath = entry.getName().substring("MAVEN-INF/repository/".length());
                File src = this.copyFile((ZipEntry)entry, (InputStream)read, depPath);
                size.addAndGet(src.length());
                layerBuilder.addEntry(src.toPath().toAbsolutePath(), AbsoluteUnixPath.get((String)this.workingDirectory).resolve(depPath), null, this.lastModified(src.toPath()));
            });
            return gav == null ? null : new Layer(layerBuilder.build(), size.get(), gav);
        }).filter(Objects::nonNull).distinct().sorted(Comparator.comparing(Layer::getSize).reversed()).peek(it -> builder.addLayer(((Layer)it).layerConfiguration)).peek(it -> this.getLog().info((CharSequence)("Prepared layer for '" + ((Layer)it).gav + "' dependencies (" + this.toSize(((Layer)it).size) + ")"))).map(it -> ((Layer)it).gav).collect(Collectors.toList());
        LayerConfiguration.Builder componentsLayerBuilder = LayerConfiguration.builder().setName("Components " + components.stream().sorted(Comparator.comparing(Object::toString)).collect(Collectors.toList()));
        AtomicLong componentSize = new AtomicLong();
        components.forEach(it -> {
            Path from = it.getFile().toPath().toAbsolutePath();
            componentSize.addAndGet(it.getFile().length());
            componentsLayerBuilder.addEntry(from, AbsoluteUnixPath.get((String)this.workingDirectory).resolve(this.repositorySystemSession.getLocalRepository().getBasedir().toPath().toAbsolutePath().relativize(from)), null, this.lastModified(from));
        });
        this.writeRegistry(this.getNewComponentRegistry(coordinates));
        File registryLocation = this.getRegistry();
        componentsLayerBuilder.addEntry(registryLocation.toPath().toAbsolutePath(), AbsoluteUnixPath.get((String)this.workingDirectory).resolve(registryLocation.getName()), null, this.lastModified(registryLocation.toPath()));
        builder.addLayer(componentsLayerBuilder.build());
        this.getLog().info((CharSequence)("Prepared layer for components " + cars.toString().replace(":car", "") + " (" + this.toSize(componentSize.get()) + ")"));
        if (this.project.getArtifact() != null && this.project.getArtifact().getFile() != null && !"pom".equals(this.project.getArtifact().getType())) {
            LayerConfiguration.Builder dependenciesLayer = LayerConfiguration.builder().setName("Main Dependencies");
            Path path = this.project.getArtifact().getFile().toPath().toAbsolutePath();
            AbsoluteUnixPath mainLibs = this.mainLibFolder != null && !this.mainLibFolder.trim().isEmpty() && this.mainLibFolder.startsWith("/") ? AbsoluteUnixPath.get((String)this.mainLibFolder) : AbsoluteUnixPath.get((String)this.workingDirectory).resolve(this.mainLibFolder);
            AtomicLong mainDepSize = new AtomicLong();
            List classpath = this.project.getArtifacts().stream().filter(it -> this.mainDependenciesScope == null || this.mainDependenciesScope.equalsIgnoreCase(it.getScope())).map(it -> {
                Path dep = it.getFile().toPath().toAbsolutePath();
                String relativized = this.repositorySystemSession.getLocalRepository().getBasedir().toPath().toAbsolutePath().relativize(dep).toString();
                mainDepSize.addAndGet(it.getFile().length());
                AbsoluteUnixPath target = mainLibs.resolve(relativized.replace(File.separatorChar, '/'));
                dependenciesLayer.addEntry(dep, target, null, this.lastModified(dep));
                return target.toString();
            }).collect(Collectors.toList());
            builder.addLayer(dependenciesLayer.build());
            this.getLog().info((CharSequence)("Prepared layer for main dependencies (" + this.toSize(mainDepSize.get()) + ")"));
            AbsoluteUnixPath mainPath = mainLibs.resolve(path.getFileName());
            classpath.add(mainPath.toString());
            builder.addLayer(LayerConfiguration.builder().setName(this.project.getArtifactId() + " @" + this.project.getVersion()).addEntry(path, mainPath, null, this.lastModified(path)).build());
            this.getLog().info((CharSequence)("Prepared layer for main artifact (" + this.toSize(path.toFile().length()) + ")"));
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("> classpath=" + classpath));
            }
            if (this.entryPoint != null) {
                String cp = String.join((CharSequence)":", classpath);
                List newEntrypoint = this.entryPoint.stream().map(it -> this.replaceEntrypointPlaceholders((String)it, cp)).collect(Collectors.toList());
                builder.setEntrypoint(newEntrypoint);
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Entrypoint set to " + newEntrypoint));
                }
            }
        } else {
            this.getLog().info((CharSequence)"No artifact attached to this project");
        }
    }

    private long lastModified(Path path) {
        return Math.max(this.getInternalLastModified(path), new Date(1000L).getTime());
    }

    private long getInternalLastModified(Path path) {
        try {
            return Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
        }
        catch (IOException ioe) {
            return path.toFile().lastModified();
        }
    }

    private String toSize(long size) {
        Size b = new Size(size, Size.SizeUnit.BYTES);
        Size mb = b.to(Size.SizeUnit.MEGABYTES);
        Size kb = b.to(Size.SizeUnit.KILOBYTES);
        if (mb.size > 0L) {
            return mb.toString();
        }
        if (kb.size > 0L) {
            return kb.toString();
        }
        return b.toString();
    }

    private String replaceEntrypointPlaceholders(String it, String cp) {
        return it.replace("@classpath@", cp);
    }

    private static class Layer {
        private final LayerConfiguration layerConfiguration;
        private final long size;
        private final String gav;

        public Layer(LayerConfiguration layerConfiguration, long size, String gav) {
            this.layerConfiguration = layerConfiguration;
            this.size = size;
            this.gav = gav;
        }

        public LayerConfiguration getLayerConfiguration() {
            return this.layerConfiguration;
        }

        public long getSize() {
            return this.size;
        }

        public String getGav() {
            return this.gav;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Layer)) {
                return false;
            }
            Layer other = (Layer)o;
            if (!other.canEqual(this)) {
                return false;
            }
            LayerConfiguration this$layerConfiguration = this.getLayerConfiguration();
            LayerConfiguration other$layerConfiguration = other.getLayerConfiguration();
            if (this$layerConfiguration == null ? other$layerConfiguration != null : !this$layerConfiguration.equals(other$layerConfiguration)) {
                return false;
            }
            if (this.getSize() != other.getSize()) {
                return false;
            }
            String this$gav = this.getGav();
            String other$gav = other.getGav();
            return !(this$gav == null ? other$gav != null : !this$gav.equals(other$gav));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Layer;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            LayerConfiguration $layerConfiguration = this.getLayerConfiguration();
            result = result * 59 + ($layerConfiguration == null ? 43 : $layerConfiguration.hashCode());
            long $size = this.getSize();
            result = result * 59 + (int)($size >>> 32 ^ $size);
            String $gav = this.getGav();
            result = result * 59 + ($gav == null ? 43 : $gav.hashCode());
            return result;
        }

        public String toString() {
            return "ImageM2Mojo.Layer(layerConfiguration=" + this.getLayerConfiguration() + ", size=" + this.getSize() + ", gav=" + this.getGav() + ")";
        }
    }

    public static class Size {
        private final long size;
        private final SizeUnit unit;

        public Size(long size, SizeUnit unit) {
            this.size = size;
            this.unit = unit;
        }

        public Size to(SizeUnit unit) {
            return new Size(unit.convert(this.size, this.unit), unit);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.size);
            if (this.unit != null) {
                sb.append(" ");
                sb.append(this.unit.name().toLowerCase(Locale.ENGLISH));
            }
            return sb.toString();
        }

        public static enum SizeUnit {
            BYTES{

                @Override
                public long toBytes(long s) {
                    return s;
                }

                @Override
                public long toKilobytes(long s) {
                    return s / 1024L;
                }

                @Override
                public long toMegabytes(long s) {
                    return s / 0x100000L;
                }

                @Override
                public long convert(long s, SizeUnit u) {
                    return u.toBytes(s);
                }

                public String toString() {
                    return "b";
                }
            }
            ,
            KILOBYTES{

                @Override
                public long toBytes(long s) {
                    return SizeUnit.x(s, 1024L, 0x1FFFFFFFFFFFFFL);
                }

                @Override
                public long toKilobytes(long s) {
                    return s;
                }

                @Override
                public long toMegabytes(long s) {
                    return s / 1024L;
                }

                @Override
                public long convert(long s, SizeUnit u) {
                    return u.toKilobytes(s);
                }

                public String toString() {
                    return "kb";
                }
            }
            ,
            MEGABYTES{

                @Override
                public long toBytes(long s) {
                    return SizeUnit.x(s, 0x100000L, 0x7FFFFFFFFFFL);
                }

                @Override
                public long toKilobytes(long s) {
                    return SizeUnit.x(s, 1024L, 0x1FFFFFFFFFFFFFL);
                }

                @Override
                public long toMegabytes(long s) {
                    return s;
                }

                @Override
                public long convert(long s, SizeUnit u) {
                    return u.toMegabytes(s);
                }

                public String toString() {
                    return "mb";
                }
            };

            private static final long B0 = 1L;
            private static final long B1 = 1024L;
            private static final long B2 = 0x100000L;

            private static long x(long d, long m, long over) {
                if (d > over) {
                    return Long.MAX_VALUE;
                }
                if (d < -over) {
                    return Long.MIN_VALUE;
                }
                return d * m;
            }

            public abstract long toBytes(long var1);

            public abstract long toKilobytes(long var1);

            public abstract long toMegabytes(long var1);

            public abstract long convert(long var1, SizeUnit var3);
        }
    }
}

