/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.maven;

import com.google.cloud.tools.jib.api.JibContainerBuilder;
import com.google.cloud.tools.jib.api.LayerConfiguration;
import com.google.cloud.tools.jib.api.buildplan.AbsoluteUnixPath;
import com.google.cloud.tools.jib.api.buildplan.FilePermissions;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.talend.sdk.component.maven.AudienceAwareMojo;
import org.talend.sdk.component.maven.api.Audience;
import org.talend.sdk.component.maven.docker.JibHelper;
import org.talend.sdk.component.path.PathFactory;

@Audience(value=Audience.Type.TALEND_INTERNAL)
@Mojo(name="singer", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class SingerMojo
extends AudienceAwareMojo {
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}.car", property="talend.singer.car", alias="talend.car.output")
    private File car;
    @Parameter(property="talend.singer.fromImage", defaultValue="openjdk:8-jre-alpine")
    private String fromImage;
    @Parameter(property="talend.singer.creationTime")
    private String creationTime;
    @Parameter(property="talend.singer.workingDirectory", defaultValue="/opt/talend")
    private String workingDirectory;
    @Parameter(property="talend.singer.toImage")
    private String toImage;
    @Parameter(property="talend.singer.repository")
    private String repository;
    @Parameter
    private Map<String, String> environment;
    @Parameter
    private Map<String, String> labels;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(property="talend.singer.versionProperty")
    private String versionProperty;
    @Parameter(property="talend.singer.dockerExecutable", alias="talend-image.dockerExecutable")
    private File dockerExecutable;
    @Parameter(property="talend.singer.layersCacheDirectory", alias="talend-image.layersCacheDirectory", defaultValue="${project.build.directory}/maven/build/cache")
    private File layersCacheDirectory;
    @Parameter(property="talend.singer.laggyPushWorkaroundRetries", alias="talend-image.layersCacheDirectory", defaultValue="0")
    private int laggyPushWorkaround;
    @Parameter
    private Map<String, String> dockerEnvironment;
    @Component
    private SettingsDecrypter settingsDecrypter;
    @Parameter(defaultValue="${repositorySystemSession}")
    private RepositorySystemSession repositorySystemSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}")
    private List<RemoteRepository> remoteRepositories;
    @Component
    private RepositorySystem repositorySystem;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        this.doExecute();
    }

    private void doExecute() throws MojoExecutionException {
        try (JibHelper jibHelper = new JibHelper(this.getLog(), this.project.getBuild().getDirectory(), this.layersCacheDirectory, this.repository, this.dockerEnvironment, this.dockerExecutable, this.laggyPushWorkaround);){
            jibHelper.prepare(this.project.getArtifactId(), this.project.getVersion(), this.project.getProperties(), this.fromImage, this.toImage, this.creationTime, this.workingDirectory, () -> "/opt/talend/singer/component/" + this.project.getArtifactId(), this.environment, this.labels);
            this.configure(jibHelper);
            this.getLog().info((CharSequence)"Creating the image (can be long)");
            jibHelper.build("Talend Singer Maven Plugin", () -> Optional.ofNullable(this.session.getSettings().getServer(this.repository)).map(it -> this.settingsDecrypter.decrypt((SettingsDecryptionRequest)new DefaultSettingsDecryptionRequest(it))).map(SettingsDecryptionResult::getServer).orElse(null));
            if (this.versionProperty != null) {
                jibHelper.setProperties(this.project, this.versionProperty);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private void configure(JibHelper helper) {
        JibContainerBuilder builder = helper.getBuilder();
        AbsoluteUnixPath workingDirectory = helper.getWorkingDirectory();
        Path main = this.findMain();
        Path fakeWorkDir = PathFactory.get((String)this.project.getBuild().getDirectory()).resolve("component_mojo_singer_work");
        if (!Files.exists(fakeWorkDir, new LinkOption[0])) {
            try {
                Files.createDirectories(fakeWorkDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        AbsoluteUnixPath targetWorkDir = workingDirectory.resolve("work/");
        AbsoluteUnixPath targetMain = workingDirectory.resolve("lib/" + main.getFileName().toString());
        builder.addLayer(LayerConfiguration.builder().addEntry(main, targetMain, FilePermissions.DEFAULT_FILE_PERMISSIONS, helper.getCreationTime()).addEntry(fakeWorkDir, targetWorkDir, FilePermissions.DEFAULT_FOLDER_PERMISSIONS, helper.getCreationTime()).build());
        builder.addEnvironmentVariable("TALEND_SINGER_WORK_DIR", targetWorkDir.toString());
        AbsoluteUnixPath targetCarPath = workingDirectory.resolve("lib/" + this.car.getName());
        builder.addLayer(LayerConfiguration.builder().addEntry(this.car.toPath(), targetCarPath, FilePermissions.DEFAULT_FILE_PERMISSIONS, helper.getCreationTime()).build());
        builder.addEnvironmentVariable("TALEND_SINGER_COMPONENT_ARCHIVE", targetCarPath.toString());
        builder.setEntrypoint(new String[]{"java", "-jar", targetMain.toString()});
    }

    private Path findMain() {
        LocalRepositoryManager lrm = this.repositorySystemSession.getLocalRepositoryManager();
        DefaultArtifact artifact = new DefaultArtifact("org.talend.sdk.component", "component-kitap", "fatjar", "jar", "1.28.0");
        File location = new File(lrm.getRepository().getBasedir(), lrm.getPathForLocalArtifact((Artifact)artifact));
        if (!location.exists()) {
            ArtifactRequest artifactRequest = new ArtifactRequest().setArtifact((Artifact)artifact).setRepositories(this.remoteRepositories);
            try {
                ArtifactResult result = this.repositorySystem.resolveArtifact(this.repositorySystemSession, artifactRequest);
                if (result.isMissing()) {
                    throw new IllegalStateException("Can't find " + artifact);
                }
                return result.getArtifact().getFile().toPath();
            }
            catch (ArtifactResolutionException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
        return location.toPath();
    }
}

