/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.maven;

import java.io.File;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.talend.sdk.component.api.processor.Input;
import org.talend.sdk.component.api.processor.Output;
import org.talend.sdk.component.container.Container;
import org.talend.sdk.component.design.extension.DesignModel;
import org.talend.sdk.component.maven.ClasspathMojoBase;
import org.talend.sdk.component.runtime.manager.ComponentFamilyMeta;
import org.talend.sdk.component.runtime.manager.ComponentManager;
import org.talend.sdk.component.runtime.manager.ContainerComponentRegistry;

public abstract class ComponentManagerBasedMojo
extends ClasspathMojoBase {
    @Parameter(defaultValue="${settings.localRepository}", property="talend.manager.mavenrepository")
    protected File repository;
    @Parameter(defaultValue="${project.artifactId}", readonly=true)
    protected String artifactId;

    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        if (!this.classes.exists()) {
            throw new MojoExecutionException("No " + this.classes);
        }
        try (ComponentManager manager = new ComponentManager(this.repository, "TALEND-INF/dependencies.txt", "org.talend.sdk.component:type=component,value=%s"){
            {
                this.addPlugin(ComponentManagerBasedMojo.this.artifactId, ComponentManagerBasedMojo.this.classes.getAbsolutePath());
            }
        };){
            Container container = (Container)manager.findPlugin(this.artifactId).get();
            ContainerComponentRegistry registry = (ContainerComponentRegistry)container.get(ContainerComponentRegistry.class);
            registry.getComponents().values().forEach(c -> {
                c.getPartitionMappers().forEach((k, p) -> this.getLog().info((CharSequence)("Found component " + c.getName() + "#" + p.getName())));
                c.getProcessors().forEach((k, p) -> this.getLog().info((CharSequence)("Found component " + c.getName() + "#" + p.getName())));
                c.getDriverRunners().forEach((k, p) -> this.getLog().info((CharSequence)("Found component " + c.getName() + "#" + p.getName())));
            });
            this.doWork(manager, container, registry);
        }
    }

    protected abstract void doWork(ComponentManager var1, Container var2, ContainerComponentRegistry var3) throws MojoExecutionException, MojoFailureException;

    protected Stream<java.lang.reflect.Parameter> findInputs(Method listener) {
        return Stream.of(listener.getParameters()).filter(p -> p.isAnnotationPresent(Input.class) || !p.isAnnotationPresent(Output.class));
    }

    protected static DesignModel getDesignModel(ComponentFamilyMeta.ProcessorMeta processor) {
        return (DesignModel)Optional.ofNullable(processor.get(DesignModel.class)).orElseThrow(() -> new IllegalArgumentException("Processor doesn't contain DesignModel"));
    }
}

