/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.maven;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.apache.maven.plugins.annotations.Parameter;
import org.eclipse.aether.artifact.Artifact;
import org.talend.sdk.component.maven.ComponentDependenciesBase;
import org.talend.sdk.component.maven.api.Audience;

@Audience(value=Audience.Type.TALEND_INTERNAL)
public abstract class CarConsumer
extends ComponentDependenciesBase {
    @Parameter(defaultValue="component", property="talend.repository.classifier")
    protected String classifier;

    protected Set<Artifact> getComponentsCar(Set<Artifact> artifacts) {
        return artifacts.stream().map(art -> this.resolve((Artifact)art, this.classifier, "car")).collect(Collectors.toSet());
    }

    protected Set<Artifact> getComponentArtifacts() {
        return this.getArtifacts(it -> {
            Artifact artifact;
            JarFile file = new JarFile(it.getFile());
            try {
                artifact = Optional.ofNullable(file.getEntry("TALEND-INF/dependencies.txt")).map(ok -> it).orElse(null);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        file.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return null;
                }
            }
            file.close();
            return artifact;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }
}

