/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.maven;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.xbean.finder.AnnotationFinder;
import org.apache.xbean.finder.archive.Archive;
import org.apache.xbean.finder.archive.CompositeArchive;
import org.apache.xbean.finder.archive.FileArchive;
import org.apache.xbean.finder.archive.JarArchive;
import org.apache.ziplock.IO;
import org.apache.ziplock.JarLocation;
import org.talend.sdk.component.api.component.Icon;
import org.talend.sdk.component.maven.Bootstrap;
import org.talend.sdk.component.maven.ClasspathMojoBase;
import org.talend.sdk.component.maven.api.Audience;
import org.talend.sdk.component.runtime.manager.reflect.IconFinder;
import org.talend.sdk.component.server.service.IconResolver;

@Audience(value=Audience.Type.TALEND_INTERNAL)
@Mojo(name="icon-report", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, threadSafe=true)
public class IconReporterMojo
extends ClasspathMojoBase {
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Parameter(defaultValue="${reactorProjects}", readonly=true)
    private List<MavenProject> reactorProjects;
    @Parameter(defaultValue="false", property="talend-component.icon.skip")
    private boolean skip;
    @Parameter(defaultValue="${maven.multiModuleProjectDirectory}/target/talend-component-kit/icon-report.html", property="talend-component.icon.output")
    private File output;
    @Parameter(defaultValue="Icons", property="talend-component.icon.title")
    private String title;
    @Parameter(property="talend-component.icon.css")
    private String css;
    @Parameter(property="talend-component.icon.js")
    private String js;
    private volatile String missingIcon;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        AtomicInteger counter;
        if (!this.skip) {
            if (this.missingIcon == null) {
                IconReporterMojo iconReporterMojo = this;
                synchronized (iconReporterMojo) {
                    if (this.missingIcon == null) {
                        ClassLoader fallbackLoader = IconReporterMojo.class.getClassLoader();
                        try (InputStream stream = fallbackLoader.getResourceAsStream("icon/missing.png");){
                            this.missingIcon = this.toDataUri(new IconResolver.Icon("image/png", IO.readBytes((InputStream)stream)));
                        }
                        catch (IOException e) {
                            throw new IllegalStateException(e);
                        }
                    }
                }
            }
            this.executeInLoader();
        }
        if ((counter = (AtomicInteger)AtomicInteger.class.cast(this.session.getRequest().getData().computeIfAbsent(((Object)((Object)this)).getClass().getName() + ".counter", k -> new AtomicInteger()))).incrementAndGet() != this.reactorProjects.size()) {
            this.getLog().debug((CharSequence)"Not yet at the end of the build, skipping rendering");
            return;
        }
        if (!this.skip) {
            this.getLog().debug((CharSequence)"This is an experimental Mojo");
            this.getReporter().doReport(this.output, this.title, this.css, this.js, this.missingIcon);
            this.getLog().info((CharSequence)("Wrote " + this.output.getAbsolutePath()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doExecute() {
        ClasspathMojoBase.ExecutionClassLoader loader = (ClasspathMojoBase.ExecutionClassLoader)ClasspathMojoBase.ExecutionClassLoader.class.cast(Thread.currentThread().getContextClassLoader());
        AnnotationFinder finder = new AnnotationFinder((Archive)new CompositeArchive((Archive[])Stream.of(this.classes).map(c -> new FileArchive((ClassLoader)loader, c)).toArray(Archive[]::new)));
        List icons = finder.findAnnotatedClasses(Icon.class);
        List packages = finder.findAnnotatedPackages(Icon.class);
        loader.getFiles().stream().filter(it -> it.getName().startsWith("talend-icon-") && it.getName().endsWith(".jar")).findFirst().flatMap(icon -> {
            try {
                return new AnnotationFinder((Archive)new JarArchive((ClassLoader)loader, icon.toURI().toURL())).findAnnotatedClasses(Icon.class).stream().findFirst();
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException(e);
            }
        }).filter(Class::isAnnotation).map(it -> it).ifPresent(uiIcon -> {
            icons.addAll(finder.findAnnotatedClasses(uiIcon));
            packages.addAll(finder.findAnnotatedPackages(uiIcon));
        });
        if (!icons.isEmpty() && !packages.isEmpty()) {
            GlobalReporter reporter;
            IconFinder iconFinder = new IconFinder();
            List foundIcons = Stream.concat(icons.stream(), packages.stream()).map(elt -> {
                boolean isCustom = iconFinder.isCustom(iconFinder.extractIcon(elt));
                String name = iconFinder.findIcon(elt);
                return new IconModel(this.project.getArtifactId(), name, this.findIcon(name), isCustom);
            }).collect(Collectors.toList());
            GlobalReporter globalReporter = reporter = this.getReporter();
            synchronized (globalReporter) {
                reporter.icons.addAll(foundIcons);
            }
        }
    }

    private String findIcon(String custom) {
        String string;
        URLClassLoader loader = new URLClassLoader(new URL[]{this.classes.toURI().toURL(), JarLocation.jarLocation(IconResolver.class).toURI().toURL()}, new ClassLoader(){

            @Override
            public InputStream getResourceAsStream(String name) {
                return null;
            }
        });
        try {
            string = new IconResolver(){
                private final List<String> iconPattern = Arrays.asList("icons/%s.svg", "icons/%s_icon32.png");

                protected boolean isSupportsSvg() {
                    return true;
                }

                protected Collection<String> getExtensionPreferences() {
                    return this.iconPattern;
                }
            }.doLoad((ClassLoader)loader, custom).map(this::toDataUri).orElse(this.missingIcon);
        }
        catch (Throwable throwable) {
            try {
                try {
                    loader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        loader.close();
        return string;
    }

    private String toDataUri(IconResolver.Icon icon) {
        return "data:" + icon.getType() + ";base64," + Base64.getEncoder().encodeToString(icon.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GlobalReporter getReporter() {
        MavenSession mavenSession = this.session;
        synchronized (mavenSession) {
            return (GlobalReporter)GlobalReporter.class.cast(this.session.getRequest().getData().computeIfAbsent(((Object)((Object)this)).getClass().getName() + ".reporter", k -> new GlobalReporter()));
        }
    }

    private static class GlobalReporter {
        private final Collection<IconModel> icons = new TreeSet<IconModel>(Comparator.comparing(icon -> ((IconModel)icon).module + '#' + ((IconModel)icon).name));

        private GlobalReporter() {
        }

        void doReport(File output, String title, String css, String js, String missing) {
            long missingIconsCount = this.icons.stream().filter(it -> ((IconModel)it).base64.equals(missing)).count();
            long customIconsCount = this.icons.stream().filter(it -> ((IconModel)it).custom).count();
            long validIcons = (long)this.icons.size() - missingIconsCount - customIconsCount;
            Bootstrap bootstrap = new Bootstrap();
            output.getParentFile().mkdirs();
            try (PrintStream stream = new PrintStream(new FileOutputStream(output));){
                stream.println("<!DOCTYPE html>");
                stream.println("<html lang=\"en\">");
                stream.println(" <head>");
                stream.println("    <meta charset=\"utf-8\">");
                stream.println("    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1, shrink-to-fit=no\">");
                stream.println("    <title>" + Optional.ofNullable(title).orElse("Icons") + "</title>");
                if (css != null && !css.isEmpty()) {
                    stream.println(css);
                } else {
                    bootstrap.css(stream);
                    stream.println("      <style>");
                    stream.println("        img { max-width: 250px; }");
                    stream.println("        image-container { width: 250px; }");
                    stream.println("      </style>");
                }
                stream.println(" </head>");
                stream.println(" <body>");
                stream.println("   <div class=\"container\">");
                stream.println("     <h1>Components Icons</h1>");
                if (this.icons.isEmpty()) {
                    stream.println("     <div class=\"alert alert-warning\" role=\"alert\">");
                    stream.println("       <strong>Error!</strong> no icon found!");
                    stream.println("     </div>");
                } else {
                    if (missingIconsCount > 0L) {
                        stream.println("     <div class=\"alert alert-danger\" role=\"alert\">");
                        stream.println("       <strong>Danger!</strong> missing icons in use!");
                        stream.println("     </div>");
                    }
                    if (customIconsCount > 0L) {
                        stream.println("     <div class=\"alert alert-warning\" role=\"alert\">");
                        stream.println("       <strong>Warning!</strong> custom icons in use!");
                        stream.println("       Check out <a href=\"http://talend.surge.sh/icons/\">surge</a>.");
                        stream.println("     </div>");
                    }
                    stream.println("     <div class=\"col-sm-12\">");
                    stream.println("      <canvas class=\"pieChartReport\"></canvas>");
                    stream.println("     </div>");
                    stream.println("     <div class=\"col-sm-12\">");
                    stream.println("       <table class=\"table table-bordered table-striped\">");
                    stream.println("         <thead class=\"thead-dark\">");
                    stream.println("           <tr>");
                    stream.println("             <td scope=\"col\">Module</td>");
                    stream.println("             <td scope=\"col\">Name</td>");
                    stream.println("             <td scope=\"col\" class=\"image-container\">Preview</td>");
                    stream.println("             <td scope=\"col\">Custom</td>");
                    stream.println("           </tr>");
                    stream.println("         </thead>");
                    stream.println("         <tbody>");
                    stream.println("       </div>");
                    this.icons.forEach(icon -> {
                        stream.println("         <tr" + (((IconModel)icon).base64.equals(missing) ? " class=\"table-danger\"" : (((IconModel)icon).custom ? " class=\"table-warning\"" : "")) + ">");
                        stream.println("           <td>" + StringEscapeUtils.escapeHtml4((String)((IconModel)icon).module) + "</td>");
                        stream.println("           <td>" + StringEscapeUtils.escapeHtml4((String)((IconModel)icon).name) + "</td>");
                        stream.println("           <td class=\"image-container\"><img src=\"" + ((IconModel)icon).base64 + "\"></td>");
                        stream.println("           <td>" + ((IconModel)icon).custom + "</td>");
                        stream.println("         </tr>");
                    });
                    stream.println("       </tbody>");
                    stream.println("     </table>");
                    stream.println("   </div>");
                    stream.println(" </div>");
                    if (js != null && !js.isEmpty()) {
                        stream.println(js);
                    } else {
                        bootstrap.js(stream);
                        stream.println("   <script src=\"https://cdnjs.cloudflare.com/ajax/libs/mdbootstrap/4.5.13/js/mdb.min.js\" integrity=\"sha256-fgXwKP0uZcyaHIUbCNj9VU/7D8/hJRfeFs/+NuVo51w=\" crossorigin=\"anonymous\"></script>");
                        stream.println("   <script>");
                        stream.println("     (function () {");
                        stream.println("       var ctx = document.getElementsByClassName('pieChartReport')[0].getContext('2d');");
                        stream.println("       new Chart(ctx, {");
                        stream.println("         type: 'pie',");
                        stream.println("         data: {");
                        stream.println("           labels: [ \"Missing Icons\", \"Custom Icons\", \"Valid Icons\" ],");
                        stream.println("           datasets: [{");
                        stream.println("             data: [ " + missingIconsCount + ", " + customIconsCount + ", " + validIcons + " ],");
                        stream.println("               backgroundColor: [ \"#f8d7da\", \"#fff3cd\", \"#b8daff\" ]");
                        stream.println("           }]");
                        stream.println("         }");
                        stream.println("       });");
                        stream.println("     })();");
                        stream.println("   </script>");
                    }
                }
                stream.println(" </body>");
                stream.println("</html>");
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private static class IconModel {
        private final String module;
        private final String name;
        private final String base64;
        private final boolean custom;

        public IconModel(String module, String name, String base64, boolean custom) {
            this.module = module;
            this.name = name;
            this.base64 = base64;
            this.custom = custom;
        }

        public String getModule() {
            return this.module;
        }

        public String getName() {
            return this.name;
        }

        public String getBase64() {
            return this.base64;
        }

        public boolean isCustom() {
            return this.custom;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IconModel)) {
                return false;
            }
            IconModel other = (IconModel)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isCustom() != other.isCustom()) {
                return false;
            }
            String this$module = this.getModule();
            String other$module = other.getModule();
            if (this$module == null ? other$module != null : !this$module.equals(other$module)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$base64 = this.getBase64();
            String other$base64 = other.getBase64();
            return !(this$base64 == null ? other$base64 != null : !this$base64.equals(other$base64));
        }

        protected boolean canEqual(Object other) {
            return other instanceof IconModel;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isCustom() ? 79 : 97);
            String $module = this.getModule();
            result = result * 59 + ($module == null ? 43 : $module.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $base64 = this.getBase64();
            result = result * 59 + ($base64 == null ? 43 : $base64.hashCode());
            return result;
        }

        public String toString() {
            return "IconReporterMojo.IconModel(module=" + this.getModule() + ", name=" + this.getName() + ", base64=" + this.getBase64() + ", custom=" + this.isCustom() + ")";
        }
    }
}

