/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.maven;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.ziplock.IO;
import org.eclipse.aether.artifact.Artifact;
import org.talend.sdk.component.maven.CarConsumer;
import org.talend.sdk.component.maven.api.Audience;

@Audience(value=Audience.Type.TALEND_INTERNAL)
@Mojo(name="prepare-repository", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true, requiresDependencyResolution=ResolutionScope.TEST)
public class BuildComponentM2RepositoryMojo
extends CarConsumer {
    private static final char[] HEX_CHARS = "0123456789abcdef".toCharArray();
    @Parameter(defaultValue="true", property="talend.connectors.write")
    private Boolean writeVersion;
    @Parameter(defaultValue="${project.version}", property="talend.connectors.version")
    private String version;
    @Parameter(defaultValue="CONNECTORS_VERSION", property="talend.connectors.file")
    private String connectorsVersionFile;
    @Parameter(property="talend-m2.registryBase")
    private File componentRegistryBase;
    @Parameter(property="talend-m2.root", defaultValue="${maven.multiModuleProjectDirectory}/target/talend-component-kit/maven")
    protected File m2Root;
    @Parameter(property="talend-m2.clean", defaultValue="true")
    private boolean cleanBeforeGeneration;
    @Parameter(defaultValue="true", property="talend.repository.createDigestRegistry")
    private boolean createDigestRegistry;
    @Parameter(defaultValue="SHA-512", property="talend.repository.digestAlgorithm")
    private String digestAlgorithm;

    @Override
    public void doExecute() throws MojoExecutionException {
        Set<Artifact> componentArtifacts = this.getComponentsCar(this.getComponentArtifacts());
        this.doGenerate(componentArtifacts);
    }

    private void doGenerate(Set<Artifact> componentArtifacts) {
        if (this.cleanBeforeGeneration && this.m2Root.exists()) {
            org.apache.ziplock.Files.remove((File)this.m2Root);
        }
        this.m2Root.mkdirs();
        List<String> coordinates = componentArtifacts.stream().map(car -> this.copyComponentDependencies((Artifact)car, (entry, read) -> this.copyFile((ZipEntry)entry, (InputStream)read, entry.getName().substring("MAVEN-INF/repository/".length())))).filter(Objects::nonNull).distinct().sorted().collect(Collectors.toList());
        if (this.getLog().isDebugEnabled()) {
            coordinates.forEach(it -> this.getLog().debug((CharSequence)("Including component " + it)));
        } else {
            this.getLog().info((CharSequence)("Included components " + String.join((CharSequence)", ", coordinates)));
        }
        this.writeRegistry(this.getNewComponentRegistry(coordinates));
        if (this.createDigestRegistry) {
            this.writeDigest(this.getDigests());
        }
        if (this.writeVersion.booleanValue()) {
            this.writeConnectorsVersion();
            this.getLog().info((CharSequence)(this.connectorsVersionFile + " set to " + this.version));
        }
        this.getLog().info((CharSequence)("Created component repository at " + this.m2Root));
    }

    private void writeProperties(Properties content, File location) {
        try (FileWriter output = new FileWriter(location);){
            content.store(output, "Generated by Talend Component Kit " + ((Object)((Object)this)).getClass().getSimpleName());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void writeDigest(Properties digestRegistry) {
        this.writeProperties(digestRegistry, this.getDigestRegistry());
    }

    protected void writeRegistry(Properties components) {
        this.writeProperties(components, this.getRegistry());
    }

    protected void writeConnectorsVersion() {
        try (FileWriter output = new FileWriter(this.getConnectorsVersionFile());){
            output.write(this.version);
            ((Writer)output).flush();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    protected File copyFile(ZipEntry entry, InputStream read, String depPath) {
        File file = new File(this.m2Root, depPath);
        org.apache.ziplock.Files.mkdir((File)file.getParentFile());
        try {
            IO.copy((InputStream)read, (File)file);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        long lastModified = entry.getTime();
        if (lastModified > 0L) {
            file.setLastModified(lastModified);
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Adding " + depPath));
        }
        return file;
    }

    protected Properties getNewComponentRegistry(List<String> coordinates) {
        Properties components = new Properties();
        if (this.componentRegistryBase != null && this.componentRegistryBase.exists()) {
            try (FileInputStream source = new FileInputStream(this.componentRegistryBase);){
                components.load(source);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        coordinates.stream().filter(it -> it.contains(":")).forEach(it -> components.put(it.split(":")[1], it.trim()));
        return components;
    }

    protected Properties getDigests() {
        final Properties index = new Properties();
        final Path root = this.m2Root.toPath();
        try {
            Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (!file.getFileName().toString().startsWith(".")) {
                        index.setProperty(root.relativize(file).toString(), BuildComponentM2RepositoryMojo.this.hash(file));
                    }
                    return super.visitFile(file, attrs);
                }
            });
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return index;
    }

    protected String hash(Path file) {
        String string;
        DigestOutputStream out = new DigestOutputStream(new OutputStream(){

            @Override
            public void write(byte[] b) {
            }

            @Override
            public void write(byte[] b, int off, int len) {
            }

            @Override
            public void write(int b) {
            }
        }, MessageDigest.getInstance("SHA-512"));
        try {
            Files.copy(file, out);
            out.flush();
            string = BuildComponentM2RepositoryMojo.hex(out.getMessageDigest().digest());
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | NoSuchAlgorithmException e) {
                throw new IllegalStateException(e);
            }
        }
        out.close();
        return string;
    }

    private static String hex(byte[] data) {
        StringBuilder out = new StringBuilder(data.length * 2);
        for (byte b : data) {
            out.append(HEX_CHARS[b >> 4 & 0xF]).append(HEX_CHARS[b & 0xF]);
        }
        return out.toString();
    }

    protected String copyComponentDependencies(Artifact car, BiConsumer<ZipEntry, InputStream> onDependency) {
        String gav = null;
        try (ZipInputStream read = new ZipInputStream(new BufferedInputStream(new FileInputStream(car.getFile())));){
            ZipEntry entry;
            while ((entry = read.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                String path = entry.getName();
                if ("TALEND-INF/metadata.properties".equals(path)) {
                    Properties properties = new Properties();
                    properties.load(read);
                    gav = properties.getProperty("component_coordinates").replace("\\:", "");
                    continue;
                }
                if (!path.startsWith("MAVEN-INF/repository/")) continue;
                onDependency.accept(entry, read);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        return gav;
    }

    protected File getConnectorsVersionFile() {
        return new File(this.m2Root, this.connectorsVersionFile);
    }

    protected File getRegistry() {
        return new File(this.m2Root, "component-registry.properties");
    }

    protected File getDigestRegistry() {
        return new File(this.m2Root, "component-registry-digest.properties");
    }
}

