/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.maven;

import java.io.File;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.talend.sdk.component.maven.DependencyAwareMojo;
import org.talend.sdk.component.maven.api.Audience;
import org.talend.sdk.component.tools.StudioInstaller;

@Audience(value=Audience.Type.PUBLIC)
@Mojo(name="deploy-in-studio", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class DeployStudioMojo
extends DependencyAwareMojo {
    @Parameter(property="talend.component.studioHome")
    private File studioHome;
    @Parameter(property="talend.component.studioM2")
    private File studioM2;
    @Parameter(property="talend.component.enforceDeployment", defaultValue="false")
    private boolean enforceDeployment;

    public void execute() throws MojoFailureException {
        if (this.studioHome == null) {
            this.getLog().warn((CharSequence)"No studioHome defined, skipping");
            return;
        }
        new StudioInstaller(this.mainGav(), this.studioHome, this.artifacts(), (Object)this.getLog(), this.enforceDeployment, this.studioM2).run();
    }
}

