/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.maven;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.talend.sdk.component.maven.ComponentDependenciesBase;
import org.talend.sdk.component.maven.api.Audience;

@Audience(value=Audience.Type.TALEND_INTERNAL)
@Mojo(name="prepare-repository", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE)
public class BuildComponentM2RepositoryMojo
extends ComponentDependenciesBase {
    private static final char[] HEX_CHARS = "0123456789abcdef".toCharArray();
    @Parameter(defaultValue="true", property="talend.connectors.write")
    private Boolean writeVersion;
    @Parameter(defaultValue="${project.version}", property="talend.connectors.version")
    private String version;
    @Parameter(defaultValue="CONNECTORS_VERSION", property="talend.connectors.file")
    private String connectorsVersionFile;
    @Parameter(property="talend-m2.registryBase")
    private File componentRegistryBase;
    private Path componentRegistryBasePath;
    @Parameter(property="talend-m2.root", defaultValue="${maven.multiModuleProjectDirectory}/target/talend-component-kit/maven")
    protected File m2Root;
    protected Path m2RootPath;
    @Parameter(property="talend-m2.clean", defaultValue="true")
    private boolean cleanBeforeGeneration;
    @Parameter(defaultValue="true", property="talend.repository.createDigestRegistry")
    private boolean createDigestRegistry;
    @Parameter(defaultValue="SHA-512", property="talend.repository.digestAlgorithm")
    private String digestAlgorithm;

    @Override
    public void doExecute() throws MojoExecutionException {
        Set<Artifact> cars = this.getCars();
        this.m2RootPath = Paths.get(this.m2Root.getAbsolutePath(), new String[0]);
        this.componentRegistryBasePath = this.componentRegistryBase == null ? null : Paths.get(this.componentRegistryBase.getAbsolutePath(), new String[0]);
        try {
            if (this.cleanBeforeGeneration && Files.exists(this.m2RootPath, new LinkOption[0])) {
                FileUtils.deleteDirectory((File)this.m2RootPath.toFile());
            }
            Files.createDirectories(this.m2RootPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        cars.forEach(this::copyComponentDependencies);
        if (cars.isEmpty()) {
            throw new IllegalStateException("No components found, check the component cars are included in your dependencies with scope compile");
        }
        String coordinates = cars.stream().map(this::computeCoordinates).collect(Collectors.joining(","));
        this.getLog().info((CharSequence)("Included components " + coordinates));
        this.writeRegistry(this.getNewComponentRegistry(cars));
        if (this.createDigestRegistry) {
            this.writeDigest(this.getDigests());
        }
        if (this.writeVersion.booleanValue()) {
            this.writeConnectorsVersion();
            this.getLog().info((CharSequence)(this.connectorsVersionFile + " set to " + this.version));
        }
        this.getLog().info((CharSequence)("Created component repository at " + this.m2Root));
    }

    protected Set<Artifact> getCars() {
        String talendComponentPluginId = "talend-component-maven-plugin";
        Plugin talendComponentPlugin = this.project.getBuild().getPlugins().stream().filter(plugin -> plugin.getArtifactId().equals("talend-component-maven-plugin")).findFirst().orElseThrow(() -> new IllegalStateException("The plugin talend-component-maven-plugin was not found in your pom"));
        return talendComponentPlugin.getDependencies().stream().filter(car -> "car".equals(car.getType())).filter(car -> ResolutionScope.COMPILE.id().equals(car.getScope())).map(car -> new DefaultArtifact(car.getGroupId(), car.getArtifactId(), car.getClassifier(), "car", car.getVersion())).map(this::resolveArtifactOnRemoteRepositories).collect(Collectors.toSet());
    }

    protected Properties getNewComponentRegistry(Set<Artifact> cars) {
        Properties components = new Properties();
        if (this.componentRegistryBasePath != null && Files.exists(this.componentRegistryBasePath, new LinkOption[0])) {
            try (InputStream source = Files.newInputStream(this.componentRegistryBasePath, new OpenOption[0]);){
                components.load(source);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        cars.forEach(car -> components.put(car.getArtifactId(), this.computeCoordinates((Artifact)car)));
        return components;
    }

    private void writeProperties(Properties content, Path location) {
        try (BufferedWriter output = Files.newBufferedWriter(location, new OpenOption[0]);){
            content.store(output, "Generated by Talend Component Kit " + ((Object)((Object)this)).getClass().getSimpleName());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    protected Properties getDigests() {
        final Properties index = new Properties();
        try {
            Files.walkFileTree(this.m2RootPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (!file.getFileName().toString().startsWith(".")) {
                        index.setProperty(BuildComponentM2RepositoryMojo.this.m2RootPath.relativize(file).toString(), BuildComponentM2RepositoryMojo.this.hash(file));
                    }
                    return super.visitFile(file, attrs);
                }
            });
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return index;
    }

    protected void writeDigest(Properties digestRegistry) {
        this.writeProperties(digestRegistry, this.getDigestRegistry());
    }

    protected void writeRegistry(Properties components) {
        this.writeProperties(components, this.getRegistry());
    }

    private void writeConnectorsVersion() {
        try (BufferedWriter output = Files.newBufferedWriter(this.getConnectorsVersionFile(), new OpenOption[0]);){
            output.write(this.version);
            ((Writer)output).flush();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private String hash(Path file) {
        String string;
        DigestOutputStream out = new DigestOutputStream((OutputStream)NullOutputStream.NULL_OUTPUT_STREAM, MessageDigest.getInstance(this.digestAlgorithm));
        try {
            Files.copy(file, out);
            out.flush();
            string = BuildComponentM2RepositoryMojo.hex(out.getMessageDigest().digest());
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | NoSuchAlgorithmException e) {
                throw new IllegalStateException(e);
            }
        }
        out.close();
        return string;
    }

    private static String hex(byte[] data) {
        StringBuilder out = new StringBuilder(data.length * 2);
        for (byte b : data) {
            out.append(HEX_CHARS[b >> 4 & 0xF]).append(HEX_CHARS[b & 0xF]);
        }
        return out.toString();
    }

    private void copyDependency(ZipEntry zipEntry, ZipInputStream zipStream) {
        String relativeDependencyPath = zipEntry.getName().substring("MAVEN-INF/repository/".length());
        Path m2DependencyPath = this.m2RootPath.resolve(relativeDependencyPath);
        try {
            Files.createDirectories(m2DependencyPath.getParent(), new FileAttribute[0]);
            Files.copy(zipStream, m2DependencyPath, StandardCopyOption.REPLACE_EXISTING);
            long lastModified = zipEntry.getTime();
            if (lastModified > 0L) {
                Files.setLastModifiedTime(m2DependencyPath, FileTime.from(Instant.ofEpochMilli(lastModified)));
            }
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Adding " + m2DependencyPath));
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void copyComponentDependencies(Artifact car) {
        try (FileInputStream fileStream = new FileInputStream(car.getFile());
             BufferedInputStream bufferedStream = new BufferedInputStream(fileStream);
             ZipInputStream zipStream = new ZipInputStream(bufferedStream);){
            ZipEntry zipEntry;
            while ((zipEntry = zipStream.getNextEntry()) != null) {
                if (zipEntry.isDirectory() || !zipEntry.getName().startsWith("MAVEN-INF/repository/")) continue;
                this.copyDependency(zipEntry, zipStream);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private Path getConnectorsVersionFile() {
        return this.m2RootPath.resolve(this.connectorsVersionFile);
    }

    protected Path getRegistry() {
        return this.m2RootPath.resolve("component-registry.properties");
    }

    protected Path getDigestRegistry() {
        return this.m2RootPath.resolve("component-registry-digest.properties");
    }
}

