/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.maven;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.talend.sdk.component.maven.ClasspathMojoBase;
import org.talend.sdk.component.maven.api.Audience;
import org.talend.sdk.component.tools.ScanTask;

@Audience(value=Audience.Type.PUBLIC)
@Mojo(name="scan-descriptor", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, threadSafe=true)
public class ScanDescriptorMojo
extends ClasspathMojoBase {
    @Parameter(defaultValue="${project.build.outputDirectory}/TALEND-INF/scanning.properties", property="talend.scan.output")
    private File output;
    @Parameter(property="talend.scan.scannedDirectories")
    private Collection<File> scannedDirectories;
    @Parameter(property="talend.scan.scannedDependencies")
    private Collection<String> scannedDependencies;
    @Parameter(property="talend.scan.excludes")
    private List<String> excludes;
    @Parameter(property="talend.excludes")
    private Collection<String> sharedExcludes;
    @Parameter(property="talend.scan.includes")
    private List<String> includes;
    @Parameter(property="talend.scan.filter.strategy", defaultValue="exclude-include")
    private String filterStrategy;

    @Override
    public void doExecute() {
        new ScanTask((Collection)Stream.concat(this.getDirectoriesToScan(), this.getJarToScan(this.scannedDependencies)).collect(Collectors.toList()), this.getExcludes(this.excludes, this.sharedExcludes), this.includes, this.filterStrategy, this.output).run();
    }

    private Stream<File> getDirectoriesToScan() {
        return this.scannedDirectories == null || this.scannedDirectories.isEmpty() ? Stream.of(this.classes) : this.scannedDirectories.stream();
    }
}

