/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.maven;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.talend.sdk.component.maven.AudienceAwareMojo;

public abstract class ClasspathMojoBase
extends AudienceAwareMojo {
    @Parameter(defaultValue="false", property="talend.skip")
    private boolean skip;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    protected File classes;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${project.packaging}", readonly=true)
    protected String packaging;
    private ClassLoader pluginLoader;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        this.executeInLoader();
    }

    protected List<String> getExcludes(Collection<String> excludes, Collection<String> sharedExcludes) {
        return Stream.of(excludes, sharedExcludes).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
    }

    protected Stream<File> getJarToScan(Collection<String> deps) {
        if (deps == null || deps.isEmpty()) {
            return Stream.empty();
        }
        return deps.stream().filter(Objects::nonNull).map(it -> this.project.getArtifacts().stream().filter(art -> it.equals(art.getGroupId() + ':' + art.getArtifactId())).findFirst().orElse(null)).filter(Objects::nonNull).map(Artifact::getFile).filter(Objects::nonNull);
    }

    protected void executeInLoader() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)(((Object)((Object)this)).getClass().getSimpleName() + " is skipped"));
            return;
        }
        if (((Object)((Object)this)).getClass().isAnnotationPresent(Deprecated.class)) {
            this.logDeprecated();
        }
        if ("pom".equals(this.packaging)) {
            this.getLog().info((CharSequence)"Skipping modules with packaging pom");
            return;
        }
        if (!this.classes.isDirectory()) {
            this.getLog().warn((CharSequence)(this.classes + " is not a directory, skipping"));
            return;
        }
        this.pluginInit();
        final Thread thread = Thread.currentThread();
        this.pluginLoader = thread.getContextClassLoader();
        Collection excludedArtifacts = Stream.of("container-core", "component-api", "component-spi", "component-runtime-impl", "component-runtime-manager", "component-runtime-design-extension", "component-runtime-di").collect(Collectors.toSet());
        List classLoaderFiles = Stream.concat(Stream.of(this.classes), this.project.getArtifacts().stream().filter(a -> !"org.talend.sdk.component".equals(a.getGroupId()) || !excludedArtifacts.contains(a.getArtifactId())).map(Artifact::getFile)).collect(Collectors.toList());
        try (ExecutionClassLoader loader = new ExecutionClassLoader((URL[])classLoaderFiles.stream().map(file -> {
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException(e.getMessage());
            }
        }).toArray(URL[]::new), classLoaderFiles, this.pluginLoader){
            {
                super(urls, files, parent);
                thread.setContextClassLoader(this);
            }

            @Override
            public void close() throws IOException {
                thread.setContextClassLoader(ClasspathMojoBase.this.pluginLoader);
                super.close();
            }
        };){
            this.doExecute();
        }
        catch (Exception e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
        finally {
            this.pluginLoader = null;
        }
    }

    protected void logDeprecated() {
        this.getLog().warn((CharSequence)"");
        this.getLog().warn((CharSequence)"");
        this.getLog().warn((CharSequence)("This mojo (" + ((Object)((Object)this)).getClass().getSimpleName() + ") is deprecated, use it only if you know what you do"));
        this.getLog().warn((CharSequence)"");
        this.getLog().warn((CharSequence)"");
    }

    protected void pluginInit() throws MojoExecutionException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T inPluginContext(Supplier<T> supplier) {
        Thread thread = Thread.currentThread();
        ClassLoader loader = thread.getContextClassLoader();
        thread.setContextClassLoader(this.pluginLoader);
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            thread.setContextClassLoader(loader);
        }
    }

    protected abstract void doExecute() throws MojoExecutionException, MojoFailureException;

    protected static class ExecutionClassLoader
    extends URLClassLoader {
        private final Collection<File> files;

        private ExecutionClassLoader(URL[] urls, Collection<File> files, ClassLoader parent) {
            super(urls, parent);
            this.files = files;
        }

        @Generated
        public Collection<File> getFiles() {
            return this.files;
        }
    }
}

