/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.components.vault.client;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.opentracing.ClientTracingRegistrar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.components.vault.client.VaultHttp;
import org.talend.sdk.components.vault.configuration.Documentation;

@ApplicationScoped
public class VaultClientSetup {
    private static final Logger log = LoggerFactory.getLogger(VaultClientSetup.class);
    @Inject
    @Documentation(value="HTTP connection timeout to vault server.")
    @ConfigProperty(name="talend.vault.cache.client.timeout.connect", defaultValue="30000")
    private Long connectTimeout;
    @Inject
    @Documentation(value="HTTP read timeout to vault server.")
    @ConfigProperty(name="talend.vault.cache.client.timeout.read", defaultValue="30000")
    private Long readTimeout;
    @Inject
    @Documentation(value="JAX-RS fully qualified name of the provides (message body readers/writers) for vault and component-server clients.")
    @ConfigProperty(name="talend.vault.cache.client.providers")
    private Optional<String> providers;
    @Inject
    @Documentation(value="Should any certificate be accepted - only for dev purposes.")
    @ConfigProperty(name="talend.vault.cache.client.certificate.acceptAny", defaultValue="false")
    private Boolean acceptAnyCertificate;
    @Inject
    @Documentation(value="Where the keystore to use to connect to vault is located.")
    @ConfigProperty(name="talend.vault.cache.client.vault.certificate.keystore.location")
    private Optional<String> vaultKeystoreLocation;
    @Inject
    @Documentation(value="The keystore type for `talend.vault.cache.client.vault.certificate.keystore.location`.")
    @ConfigProperty(name="talend.vault.cache.client.vault.certificate.keystore.type")
    private Optional<String> vaultKeystoreType;
    @Inject
    @Documentation(value="The keystore password for `talend.vault.cache.client.vault.certificate.keystore.location`.")
    @ConfigProperty(name="talend.vault.cache.client.vault.certificate.keystore.password", defaultValue="changeit")
    private String vaultKeystorePassword;
    @Inject
    @Documentation(value="Valid hostnames for the Vault certificates (see `java.net.ssl.HostnameVerifier`).")
    @ConfigProperty(name="talend.vault.cache.client.vault.hostname.accepted", defaultValue="localhost,127.0.0.1,0:0:0:0:0:0:0:1")
    private List<String> vaultHostnames;
    @Inject
    @Documentation(value="The truststore type for `talend.vault.cache.client.vault.certificate.keystore.location`.")
    @ConfigProperty(name="talend.vault.cache.client.vault.certificate.truststore.type")
    private Optional<String> vaultTruststoreType;
    @Inject
    @Documentation(value="Thread pool max size for Vault client.")
    @ConfigProperty(name="talend.vault.cache.client.executor.vault.max", defaultValue="256")
    private Integer vaultExecutorMaxSize;
    @Inject
    @Documentation(value="Thread pool core size for Vault client.")
    @ConfigProperty(name="talend.vault.cache.client.executor.vault.core", defaultValue="64")
    private Integer vaultExecutorCoreSize;
    @Inject
    @Documentation(value="Thread keep alive (in ms) for Vault client thread pool.")
    @ConfigProperty(name="talend.vault.cache.client.executor.vault.keepAlive", defaultValue="60000")
    private Integer vaultExecutorKeepAlive;
    @Inject
    @Documentation(value="Base URL to connect to Vault.")
    @ConfigProperty(name="talend.vault.cache.vault.url", defaultValue="no-vault")
    private String vaultUrl;

    @Produces
    @ApplicationScoped
    @VaultHttp
    public WebTarget vaultTarget(@VaultHttp Client client) {
        return client.target(this.vaultUrl);
    }

    @Produces
    @ApplicationScoped
    @VaultHttp
    public ExecutorService vaultExecutorService() {
        return this.createExecutor(this.vaultExecutorCoreSize, this.vaultExecutorMaxSize, this.vaultExecutorKeepAlive.intValue(), "vault");
    }

    @VaultHttp
    public void releaseVaultExecutor(@Disposes @VaultHttp ExecutorService executorService) {
        executorService.shutdownNow();
    }

    @Produces
    @ApplicationScoped
    @VaultHttp
    public Client vaultClient(@VaultHttp ExecutorService executor) {
        return this.createClient(executor, this.vaultKeystoreLocation, this.vaultKeystoreType, this.vaultKeystorePassword, this.vaultTruststoreType, this.vaultHostnames).build();
    }

    @VaultHttp
    public void releaseVaultClient(@Disposes @VaultHttp Client client) {
        client.close();
    }

    private ThreadPoolExecutor createExecutor(int core, int max, long keepAlive, final String nameMarker) {
        return new ThreadPoolExecutor(core, max, keepAlive, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
            private final ThreadGroup group = Optional.ofNullable(System.getSecurityManager()).map(SecurityManager::getThreadGroup).orElseGet(() -> Thread.currentThread().getThreadGroup());
            private final AtomicInteger threadNumber = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(this.group, r, "talend-vault-proxy-" + nameMarker + "-" + this.threadNumber.getAndIncrement(), 0L);
                if (t.isDaemon()) {
                    t.setDaemon(false);
                }
                if (t.getPriority() != 5) {
                    t.setPriority(5);
                }
                return t;
            }
        });
    }

    private ClientBuilder createClient(ExecutorService executor, Optional<String> keystoreLocation, Optional<String> keystoreType, String keystorePassword, Optional<String> truststoreType, List<String> serverHostnames) {
        ClientBuilder builder = ClientBuilder.newBuilder();
        builder.connectTimeout(this.connectTimeout.longValue(), TimeUnit.MILLISECONDS);
        builder.readTimeout(this.readTimeout.longValue(), TimeUnit.MILLISECONDS);
        builder.executorService(executor);
        if (this.acceptAnyCertificate.booleanValue()) {
            builder.hostnameVerifier((host, session) -> true);
            builder.sslContext(this.createUnsafeSSLContext());
        } else if (keystoreLocation.isPresent()) {
            builder.hostnameVerifier((host, session) -> serverHostnames.contains(host));
            builder.sslContext(this.createSSLContext(keystoreLocation, keystoreType, keystorePassword, truststoreType));
        }
        this.providers.map(it -> Stream.of(it.split(",")).map(String::trim).filter(v -> !v.isEmpty()).map(fqn -> {
            try {
                return Thread.currentThread().getContextClassLoader().loadClass((String)fqn).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                log.warn("Can't add provider " + fqn + ": " + e.getMessage(), (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull)).ifPresent(it -> it.forEach(arg_0 -> ((ClientBuilder)builder).register(arg_0)));
        return ClientTracingRegistrar.configure((ClientBuilder)builder);
    }

    private SSLContext createUnsafeSSLContext() {
        TrustManager[] trustManagers = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String s) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String s) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        }};
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, trustManagers, new SecureRandom());
            return sslContext;
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    private SSLContext createSSLContext(Optional<String> keystoreLocation, Optional<String> keystoreType, String keystorePassword, Optional<String> truststoreType) {
        KeyStore keyStore;
        File source = new File(keystoreLocation.orElseThrow(IllegalArgumentException::new));
        if (!source.exists()) {
            throw new IllegalArgumentException(source + " does not exist");
        }
        try (FileInputStream stream = new FileInputStream(source);){
            keyStore = KeyStore.getInstance(keystoreType.orElseGet(KeyStore::getDefaultType));
            keyStore.load(stream, keystorePassword.toCharArray());
        }
        catch (KeyStoreException | NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException | CertificateException e) {
            throw new IllegalArgumentException(e);
        }
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(truststoreType.orElseGet(TrustManagerFactory::getDefaultAlgorithm));
            trustManagerFactory.init(keyStore);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, trustManagerFactory.getTrustManagers(), new SecureRandom());
            return sslContext;
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    public Long getConnectTimeout() {
        return this.connectTimeout;
    }

    public Long getReadTimeout() {
        return this.readTimeout;
    }

    public Optional<String> getProviders() {
        return this.providers;
    }

    public Boolean getAcceptAnyCertificate() {
        return this.acceptAnyCertificate;
    }

    public Optional<String> getVaultKeystoreLocation() {
        return this.vaultKeystoreLocation;
    }

    public Optional<String> getVaultKeystoreType() {
        return this.vaultKeystoreType;
    }

    public String getVaultKeystorePassword() {
        return this.vaultKeystorePassword;
    }

    public List<String> getVaultHostnames() {
        return this.vaultHostnames;
    }

    public Optional<String> getVaultTruststoreType() {
        return this.vaultTruststoreType;
    }

    public Integer getVaultExecutorMaxSize() {
        return this.vaultExecutorMaxSize;
    }

    public Integer getVaultExecutorCoreSize() {
        return this.vaultExecutorCoreSize;
    }

    public Integer getVaultExecutorKeepAlive() {
        return this.vaultExecutorKeepAlive;
    }

    public String getVaultUrl() {
        return this.vaultUrl;
    }

    public void setConnectTimeout(Long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setReadTimeout(Long readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setProviders(Optional<String> providers) {
        this.providers = providers;
    }

    public void setAcceptAnyCertificate(Boolean acceptAnyCertificate) {
        this.acceptAnyCertificate = acceptAnyCertificate;
    }

    public void setVaultKeystoreLocation(Optional<String> vaultKeystoreLocation) {
        this.vaultKeystoreLocation = vaultKeystoreLocation;
    }

    public void setVaultKeystoreType(Optional<String> vaultKeystoreType) {
        this.vaultKeystoreType = vaultKeystoreType;
    }

    public void setVaultKeystorePassword(String vaultKeystorePassword) {
        this.vaultKeystorePassword = vaultKeystorePassword;
    }

    public void setVaultHostnames(List<String> vaultHostnames) {
        this.vaultHostnames = vaultHostnames;
    }

    public void setVaultTruststoreType(Optional<String> vaultTruststoreType) {
        this.vaultTruststoreType = vaultTruststoreType;
    }

    public void setVaultExecutorMaxSize(Integer vaultExecutorMaxSize) {
        this.vaultExecutorMaxSize = vaultExecutorMaxSize;
    }

    public void setVaultExecutorCoreSize(Integer vaultExecutorCoreSize) {
        this.vaultExecutorCoreSize = vaultExecutorCoreSize;
    }

    public void setVaultExecutorKeepAlive(Integer vaultExecutorKeepAlive) {
        this.vaultExecutorKeepAlive = vaultExecutorKeepAlive;
    }

    public void setVaultUrl(String vaultUrl) {
        this.vaultUrl = vaultUrl;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VaultClientSetup)) {
            return false;
        }
        VaultClientSetup other = (VaultClientSetup)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$connectTimeout = this.getConnectTimeout();
        Long other$connectTimeout = other.getConnectTimeout();
        if (this$connectTimeout == null ? other$connectTimeout != null : !((Object)this$connectTimeout).equals(other$connectTimeout)) {
            return false;
        }
        Long this$readTimeout = this.getReadTimeout();
        Long other$readTimeout = other.getReadTimeout();
        if (this$readTimeout == null ? other$readTimeout != null : !((Object)this$readTimeout).equals(other$readTimeout)) {
            return false;
        }
        Boolean this$acceptAnyCertificate = this.getAcceptAnyCertificate();
        Boolean other$acceptAnyCertificate = other.getAcceptAnyCertificate();
        if (this$acceptAnyCertificate == null ? other$acceptAnyCertificate != null : !((Object)this$acceptAnyCertificate).equals(other$acceptAnyCertificate)) {
            return false;
        }
        Integer this$vaultExecutorMaxSize = this.getVaultExecutorMaxSize();
        Integer other$vaultExecutorMaxSize = other.getVaultExecutorMaxSize();
        if (this$vaultExecutorMaxSize == null ? other$vaultExecutorMaxSize != null : !((Object)this$vaultExecutorMaxSize).equals(other$vaultExecutorMaxSize)) {
            return false;
        }
        Integer this$vaultExecutorCoreSize = this.getVaultExecutorCoreSize();
        Integer other$vaultExecutorCoreSize = other.getVaultExecutorCoreSize();
        if (this$vaultExecutorCoreSize == null ? other$vaultExecutorCoreSize != null : !((Object)this$vaultExecutorCoreSize).equals(other$vaultExecutorCoreSize)) {
            return false;
        }
        Integer this$vaultExecutorKeepAlive = this.getVaultExecutorKeepAlive();
        Integer other$vaultExecutorKeepAlive = other.getVaultExecutorKeepAlive();
        if (this$vaultExecutorKeepAlive == null ? other$vaultExecutorKeepAlive != null : !((Object)this$vaultExecutorKeepAlive).equals(other$vaultExecutorKeepAlive)) {
            return false;
        }
        Optional<String> this$providers = this.getProviders();
        Optional<String> other$providers = other.getProviders();
        if (this$providers == null ? other$providers != null : !((Object)this$providers).equals(other$providers)) {
            return false;
        }
        Optional<String> this$vaultKeystoreLocation = this.getVaultKeystoreLocation();
        Optional<String> other$vaultKeystoreLocation = other.getVaultKeystoreLocation();
        if (this$vaultKeystoreLocation == null ? other$vaultKeystoreLocation != null : !((Object)this$vaultKeystoreLocation).equals(other$vaultKeystoreLocation)) {
            return false;
        }
        Optional<String> this$vaultKeystoreType = this.getVaultKeystoreType();
        Optional<String> other$vaultKeystoreType = other.getVaultKeystoreType();
        if (this$vaultKeystoreType == null ? other$vaultKeystoreType != null : !((Object)this$vaultKeystoreType).equals(other$vaultKeystoreType)) {
            return false;
        }
        String this$vaultKeystorePassword = this.getVaultKeystorePassword();
        String other$vaultKeystorePassword = other.getVaultKeystorePassword();
        if (this$vaultKeystorePassword == null ? other$vaultKeystorePassword != null : !this$vaultKeystorePassword.equals(other$vaultKeystorePassword)) {
            return false;
        }
        List<String> this$vaultHostnames = this.getVaultHostnames();
        List<String> other$vaultHostnames = other.getVaultHostnames();
        if (this$vaultHostnames == null ? other$vaultHostnames != null : !((Object)this$vaultHostnames).equals(other$vaultHostnames)) {
            return false;
        }
        Optional<String> this$vaultTruststoreType = this.getVaultTruststoreType();
        Optional<String> other$vaultTruststoreType = other.getVaultTruststoreType();
        if (this$vaultTruststoreType == null ? other$vaultTruststoreType != null : !((Object)this$vaultTruststoreType).equals(other$vaultTruststoreType)) {
            return false;
        }
        String this$vaultUrl = this.getVaultUrl();
        String other$vaultUrl = other.getVaultUrl();
        return !(this$vaultUrl == null ? other$vaultUrl != null : !this$vaultUrl.equals(other$vaultUrl));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VaultClientSetup;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $connectTimeout = this.getConnectTimeout();
        result = result * 59 + ($connectTimeout == null ? 43 : ((Object)$connectTimeout).hashCode());
        Long $readTimeout = this.getReadTimeout();
        result = result * 59 + ($readTimeout == null ? 43 : ((Object)$readTimeout).hashCode());
        Boolean $acceptAnyCertificate = this.getAcceptAnyCertificate();
        result = result * 59 + ($acceptAnyCertificate == null ? 43 : ((Object)$acceptAnyCertificate).hashCode());
        Integer $vaultExecutorMaxSize = this.getVaultExecutorMaxSize();
        result = result * 59 + ($vaultExecutorMaxSize == null ? 43 : ((Object)$vaultExecutorMaxSize).hashCode());
        Integer $vaultExecutorCoreSize = this.getVaultExecutorCoreSize();
        result = result * 59 + ($vaultExecutorCoreSize == null ? 43 : ((Object)$vaultExecutorCoreSize).hashCode());
        Integer $vaultExecutorKeepAlive = this.getVaultExecutorKeepAlive();
        result = result * 59 + ($vaultExecutorKeepAlive == null ? 43 : ((Object)$vaultExecutorKeepAlive).hashCode());
        Optional<String> $providers = this.getProviders();
        result = result * 59 + ($providers == null ? 43 : ((Object)$providers).hashCode());
        Optional<String> $vaultKeystoreLocation = this.getVaultKeystoreLocation();
        result = result * 59 + ($vaultKeystoreLocation == null ? 43 : ((Object)$vaultKeystoreLocation).hashCode());
        Optional<String> $vaultKeystoreType = this.getVaultKeystoreType();
        result = result * 59 + ($vaultKeystoreType == null ? 43 : ((Object)$vaultKeystoreType).hashCode());
        String $vaultKeystorePassword = this.getVaultKeystorePassword();
        result = result * 59 + ($vaultKeystorePassword == null ? 43 : $vaultKeystorePassword.hashCode());
        List<String> $vaultHostnames = this.getVaultHostnames();
        result = result * 59 + ($vaultHostnames == null ? 43 : ((Object)$vaultHostnames).hashCode());
        Optional<String> $vaultTruststoreType = this.getVaultTruststoreType();
        result = result * 59 + ($vaultTruststoreType == null ? 43 : ((Object)$vaultTruststoreType).hashCode());
        String $vaultUrl = this.getVaultUrl();
        result = result * 59 + ($vaultUrl == null ? 43 : $vaultUrl.hashCode());
        return result;
    }

    public String toString() {
        return "VaultClientSetup(connectTimeout=" + this.getConnectTimeout() + ", readTimeout=" + this.getReadTimeout() + ", providers=" + this.getProviders() + ", acceptAnyCertificate=" + this.getAcceptAnyCertificate() + ", vaultKeystoreLocation=" + this.getVaultKeystoreLocation() + ", vaultKeystoreType=" + this.getVaultKeystoreType() + ", vaultKeystorePassword=" + this.getVaultKeystorePassword() + ", vaultHostnames=" + this.getVaultHostnames() + ", vaultTruststoreType=" + this.getVaultTruststoreType() + ", vaultExecutorMaxSize=" + this.getVaultExecutorMaxSize() + ", vaultExecutorCoreSize=" + this.getVaultExecutorCoreSize() + ", vaultExecutorKeepAlive=" + this.getVaultExecutorKeepAlive() + ", vaultUrl=" + this.getVaultUrl() + ")";
    }
}

