/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.components.vault.jcache;

import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.util.Optional;
import java.util.Properties;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.spi.CachingProvider;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.talend.sdk.components.vault.client.DecryptedValue;
import org.talend.sdk.components.vault.configuration.Documentation;
import org.talend.sdk.components.vault.jcache.CacheConfigurationFactory;
import org.talend.sdk.components.vault.jcache.CacheSizeManager;

@ApplicationScoped
public class JCacheSetup {
    @Inject
    @Documentation(value="Configuration for JCache setup, default implementation is Geronimo Simple Cache.")
    @ConfigProperty(name="talend.vault.cache.jcache.manager.uri", defaultValue="geronimo://simple-jcache.properties")
    private String configurationUri;
    @Inject
    @Documentation(value="JCache `CacheManager` properties used to initialized the instance.")
    @ConfigProperty(name="talend.vault.cache.jcache.manager.properties", defaultValue="")
    private String configurationProperties;
    @Inject
    private CacheConfigurationFactory cacheConfiguration;

    @Produces
    @ApplicationScoped
    public CachingProvider cachingProvider() {
        return Caching.getCachingProvider((ClassLoader)Thread.currentThread().getContextClassLoader());
    }

    public void releaseCachingProvider(@Disposes CachingProvider provider) {
        provider.close();
    }

    @Produces
    @ApplicationScoped
    public CacheManager cacheManager(CachingProvider provider) {
        return provider.getCacheManager(URI.create(this.configurationUri), Thread.currentThread().getContextClassLoader(), Optional.of(this.configurationProperties).filter(it -> !it.isEmpty()).map(it -> {
            Properties properties = new Properties();
            try (StringReader reader = new StringReader((String)it);){
                properties.load(reader);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
            return properties;
        }).orElseGet(() -> ((CachingProvider)provider).getDefaultProperties()));
    }

    @Produces
    @ApplicationScoped
    public Cache<String, DecryptedValue> cache(CacheManager manager) {
        CacheSizeManager listener = new CacheSizeManager(this.cacheConfiguration.maxSize());
        Cache cache = manager.createCache("org.talend.sdk.component.runtime.server.vault.DECRYPTED_VALUES", this.cacheConfiguration.createConfiguration(listener));
        listener.accept(cache);
        return cache;
    }

    public void releaseCache(@Disposes Cache<String, DecryptedValue> cache) {
        cache.close();
    }
}

