/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.console.client.teiid;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.inject.Inject;
import com.google.web.bindery.event.shared.EventBus;
import com.gwtplatform.mvp.client.Presenter;
import com.gwtplatform.mvp.client.View;
import com.gwtplatform.mvp.client.annotations.NameToken;
import com.gwtplatform.mvp.client.annotations.ProxyCodeSplit;
import com.gwtplatform.mvp.client.proxy.Place;
import com.gwtplatform.mvp.client.proxy.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jboss.as.console.client.Console;
import org.jboss.as.console.client.domain.model.SimpleCallback;
import org.jboss.as.console.client.shared.runtime.RuntimeBaseAddress;
import org.jboss.as.console.client.shared.subsys.Baseadress;
import org.jboss.as.console.client.shared.subsys.RevealStrategy;
import org.jboss.as.console.client.teiid.Persistable;
import org.jboss.as.console.client.teiid.model.SubsystemConfiguration;
import org.jboss.as.console.client.teiid.model.TeiidLogger;
import org.jboss.as.console.client.teiid.model.Translator;
import org.jboss.as.console.client.teiid.model.Transport;
import org.jboss.as.console.client.widgets.forms.ApplicationMetaData;
import org.jboss.as.console.client.widgets.forms.EntityAdapter;
import org.jboss.as.console.spi.RequiredResources;
import org.jboss.as.console.spi.SearchIndex;
import org.jboss.as.console.spi.SubsystemExtension;
import org.jboss.dmr.client.ModelNode;
import org.jboss.dmr.client.ModelNodeUtil;
import org.jboss.dmr.client.Property;
import org.jboss.dmr.client.dispatch.Action;
import org.jboss.dmr.client.dispatch.DispatchAsync;
import org.jboss.dmr.client.dispatch.impl.DMRAction;
import org.jboss.dmr.client.dispatch.impl.DMRResponse;

public class SubsystemPresenter
extends Presenter<MyView, MyProxy>
implements Persistable<SubsystemConfiguration> {
    private DispatchAsync dispatcher;
    private RevealStrategy revealStrategy;
    private EntityAdapter<SubsystemConfiguration> configurationEntityAdapter;
    private EntityAdapter<TeiidLogger> loggerAdaptor;
    private EntityAdapter<Transport> transportEntityAdapter;
    private EntityAdapter<Translator> translatorAdapter;
    private ApplicationMetaData metadata;

    @Inject
    public SubsystemPresenter(EventBus eventBus, MyView view, MyProxy proxy, DispatchAsync dispatcher, RevealStrategy revealStrategy, ApplicationMetaData metadata) {
        super(eventBus, (View)view, (Proxy)proxy);
        this.dispatcher = dispatcher;
        this.revealStrategy = revealStrategy;
        this.configurationEntityAdapter = new EntityAdapter(SubsystemConfiguration.class, metadata);
        this.loggerAdaptor = new EntityAdapter(TeiidLogger.class, metadata);
        this.transportEntityAdapter = new EntityAdapter(Transport.class, metadata);
        this.translatorAdapter = new EntityAdapter(Translator.class, metadata);
    }

    protected void onBind() {
        super.onBind();
        ((MyView)this.getView()).setPresenter(this);
    }

    protected void revealInParent() {
        this.revealStrategy.revealInParent((Presenter)this);
    }

    protected void onReset() {
        super.onReset();
        this.loadConfigurationModel();
        this.loadLoggingConfiguration();
        this.loadTransports();
        this.loadTranslators();
    }

    public void loadLoggingConfiguration() {
        this.getLogHandlerStatus("org.teiid.AUDIT_LOG");
        this.getLogHandlerStatus("org.teiid.COMMAND_LOG");
        this.getLogHandlerStatus("org.teiid");
    }

    private void loadConfigurationModel() {
        ModelNode operation = new ModelNode();
        operation.get("operation").set("read-resource");
        operation.get("address").set(Baseadress.get());
        operation.get("address").add("subsystem", "teiid");
        operation.get("include-runtime").set(true);
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onSuccess(DMRResponse dmrResponse) {
                ModelNode response = dmrResponse.get();
                SubsystemConfiguration bean = (SubsystemConfiguration)SubsystemPresenter.this.configurationEntityAdapter.fromDMR(response.get("result"));
                ((MyView)SubsystemPresenter.this.getView()).setConfigurationBean(bean);
            }

            public void onFailure(Throwable caught) {
                Console.error((String)"Failed to retrieve configuration for Teiid subsystem", (String)caught.getMessage());
            }
        });
    }

    @Override
    public void save(SubsystemConfiguration t, Map<String, Object> changeset) {
        ModelNode address = new ModelNode();
        address.get("address").set(Baseadress.get());
        address.get("address").add("subsystem", "teiid");
        address.get("operation").set("write-attribute");
        ModelNode operation = this.configurationEntityAdapter.fromChangeset(changeset, address, new ModelNode[0]);
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onSuccess(DMRResponse result) {
                ModelNode response = result.get();
                boolean success = response.get("outcome").asString().equals("success");
                if (success) {
                    Console.info((String)Console.MESSAGES.saved("Teiid configuration modified"));
                } else {
                    Console.error((String)Console.MESSAGES.saveFailed("Teiid configuration modification failed"), (String)response.getFailureDescription());
                }
                SubsystemPresenter.this.loadConfigurationModel();
            }

            public void onFailure(Throwable caught) {
                super.onFailure(caught);
                SubsystemPresenter.this.loadConfigurationModel();
            }
        });
    }

    public void getLogHandlerStatus(final String context) {
        ModelNode address = RuntimeBaseAddress.get();
        address.add("subsystem", "logging");
        address.add("logger", context);
        ModelNode operation = new ModelNode();
        operation.get("operation").set("read-resource");
        operation.get("address").set(address);
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onSuccess(DMRResponse result) {
                ModelNode response = result.get();
                if (SubsystemPresenter.this.isSucess(response)) {
                    if (response.get("result").isDefined()) {
                        TeiidLogger logger = (TeiidLogger)SubsystemPresenter.this.loggerAdaptor.fromDMR(response.get("result"));
                        ((MyView)SubsystemPresenter.this.getView()).loggingStatus(context, logger);
                    }
                } else {
                    ((MyView)SubsystemPresenter.this.getView()).loggingStatus(context, null);
                }
            }

            public void onFailure(Throwable caught) {
                GWT.log((String)"on failure log");
                ((MyView)SubsystemPresenter.this.getView()).loggingStatus(context, null);
            }
        });
    }

    public void checkLogHandlerStatus(final String context, final String name, final boolean dbAppender) {
        ModelNode address = RuntimeBaseAddress.get();
        address.add("subsystem", "logging");
        if (dbAppender) {
            address.add("async-handler", name);
        } else {
            address.add("periodic-rotating-file-handler", name);
        }
        ModelNode operation = new ModelNode();
        operation.get("operation").set("read-resource");
        operation.get("address").set(address);
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onSuccess(DMRResponse result) {
                ModelNode response = result.get();
                if (SubsystemPresenter.this.isSucess(response)) {
                    ((MyView)SubsystemPresenter.this.getView()).setLogHandlerStatus(context, name, dbAppender, true);
                }
            }

            public void onFailure(Throwable caught) {
                ((MyView)SubsystemPresenter.this.getView()).setLogHandlerStatus(context, name, dbAppender, false);
            }
        });
    }

    public void addOrRemoveLogger(final String context, final boolean addOperation) {
        ModelNode address = RuntimeBaseAddress.get();
        address.add("subsystem", "logging");
        address.add("logger", context);
        ModelNode operation = new ModelNode();
        operation.get("operation").set("read-resource");
        operation.get("address").set(address);
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onSuccess(DMRResponse result) {
                ModelNode response = result.get();
                if (SubsystemPresenter.this.isSucess(response)) {
                    if (response.get("result").isDefined() && !addOperation) {
                        ((MyView)SubsystemPresenter.this.getView()).deleteLogger(context);
                    }
                } else if (addOperation) {
                    ((MyView)SubsystemPresenter.this.getView()).addLogger(context);
                }
            }

            public void onFailure(Throwable caught) {
                if (addOperation) {
                    ((MyView)SubsystemPresenter.this.getView()).addLogger(context);
                }
            }
        });
    }

    public void addFileHandler(final String name, String fileName) {
        ModelNode address = RuntimeBaseAddress.get();
        address.add("subsystem", "logging");
        address.add("periodic-rotating-file-handler", name);
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        operation.get("address").set(address);
        operation.get("append").set(new ModelNode().set("true"));
        operation.get("autoflush").set(new ModelNode().set("true"));
        operation.get("level").set(new ModelNode().set("DEBUG"));
        operation.get("suffix").set(new ModelNode().set(".yyyy-MM-dd"));
        operation.get("formatter").set(new ModelNode().set("%d{HH:mm:ss,SSS} %-5p [%c] (%t) %X{teiid-session} %s%E%n"));
        ModelNode file = new ModelNode();
        file.get("path").set(new ModelNode().set(fileName));
        file.get("relative-to").set(new ModelNode().set("jboss.server.log.dir"));
        operation.get("file").set(file);
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onSuccess(DMRResponse result) {
                ModelNode response = result.get();
                ((MyView)SubsystemPresenter.this.getView()).logHandlerAdded(name, SubsystemPresenter.this.isSucess(response));
            }

            public void onFailure(Throwable caught) {
                ((MyView)SubsystemPresenter.this.getView()).logHandlerAdded(name, false);
            }
        });
    }

    private boolean isSucess(ModelNode response) {
        return response.hasDefined("outcome") && response.get("outcome").asString().equals("success");
    }

    public void removeFileHandler(final String name) {
        ModelNode address = RuntimeBaseAddress.get();
        address.add("subsystem", "logging");
        address.add("periodic-rotating-file-handler", name);
        ModelNode operation = new ModelNode();
        operation.get("operation").set("remove");
        operation.get("address").set(address);
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onSuccess(DMRResponse result) {
                ModelNode response = result.get();
                ((MyView)SubsystemPresenter.this.getView()).logHandlerRemoved(name, SubsystemPresenter.this.isSucess(response));
            }

            public void onFailure(Throwable caught) {
                Console.error((String)("Failed to remove log handler " + name), (String)caught.getMessage());
            }
        });
    }

    public void addLogger(final String context, String level, String handler) {
        ModelNode address = RuntimeBaseAddress.get();
        address.add("subsystem", "logging");
        address.add("logger", context);
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        operation.get("address").set(address);
        operation.get("level").set(new ModelNode().set(level));
        if (handler != null) {
            operation.get("handlers").add(new ModelNode().set(handler));
        }
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onSuccess(DMRResponse result) {
                ModelNode response = result.get();
                ((MyView)SubsystemPresenter.this.getView()).loggerAdded(context, SubsystemPresenter.this.isSucess(response));
            }

            public void onFailure(Throwable caught) {
                ((MyView)SubsystemPresenter.this.getView()).logHandlerAdded(context, false);
            }
        });
    }

    public void removeLogger(final String context) {
        ModelNode address = RuntimeBaseAddress.get();
        address.add("subsystem", "logging");
        address.add("logger", context);
        ModelNode operation = new ModelNode();
        operation.get("operation").set("remove");
        operation.get("address").set(address);
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onSuccess(DMRResponse result) {
                ModelNode response = result.get();
                ((MyView)SubsystemPresenter.this.getView()).loggerRemoved(context, SubsystemPresenter.this.isSucess(response));
            }

            public void onFailure(Throwable caught) {
                Console.error((String)("Failed to remove logger " + context), (String)caught.getMessage());
            }
        });
    }

    private void loadTransports() {
        ModelNode operation = new ModelNode();
        operation.get("operation").set("read-children-resources");
        operation.get("address").set(Baseadress.get());
        operation.get("address").add("subsystem", "teiid");
        operation.get("child-type").set("transport");
        operation.get("recursive").set(true);
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onSuccess(DMRResponse dmrResponse) {
                ModelNode response = dmrResponse.get();
                List children = response.get("result").asPropertyList();
                ArrayList<Transport> transports = new ArrayList<Transport>(children.size());
                for (Property child : children) {
                    ModelNode model = child.getValue();
                    Transport transport = (Transport)SubsystemPresenter.this.transportEntityAdapter.fromDMR(model);
                    transport.setName(child.getName());
                    transports.add(transport);
                }
                ((MyView)SubsystemPresenter.this.getView()).setTransports(transports);
            }

            public void onFailure(Throwable caught) {
                Console.error((String)"Failed to retrieve configuration for Teiid transports", (String)caught.getMessage());
            }
        });
    }

    public void createTransport(final Transport transport) {
        ModelNode address = new ModelNode();
        address.get("address").set(Baseadress.get());
        address.get("address").add("subsystem", "teiid");
        address.get("address").add("transport", transport.getName());
        ModelNode operation = this.transportEntityAdapter.fromEntity((Object)transport);
        operation.get("operation").set("add");
        operation.get("address").set(address.get("address").asObject());
        operation.remove("name");
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onSuccess(DMRResponse dmrResponse) {
                ModelNode result = dmrResponse.get();
                if (ModelNodeUtil.indicatesSuccess((ModelNode)result)) {
                    Console.info((String)Console.MESSAGES.added("Teiid Transport " + transport.getName()));
                } else {
                    Console.error((String)Console.MESSAGES.addingFailed("Teiid Transport " + transport.getName()), (String)result.toString());
                }
                SubsystemPresenter.this.loadTransports();
            }

            public void onFailure(Throwable caught) {
                Console.error((String)Console.MESSAGES.addingFailed("Teiid Transport " + transport.getName()), (String)caught.getMessage());
                SubsystemPresenter.this.loadTransports();
            }
        });
    }

    public void saveTransport(final Transport transport, Map<String, Object> changeset) {
        ModelNode address = new ModelNode();
        address.get("operation").set("write-attribute");
        address.get("address").set(Baseadress.get());
        address.get("address").add("subsystem", "teiid");
        address.get("address").add("transport", transport.getName());
        ModelNode operation = this.transportEntityAdapter.fromChangeset(changeset, address, new ModelNode[0]);
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onSuccess(DMRResponse result) {
                ModelNode response = result.get();
                boolean success = response.get("outcome").asString().equals("success");
                if (success) {
                    Console.info((String)Console.MESSAGES.saved("Teiid Transport " + transport.getName()));
                } else {
                    Console.error((String)Console.MESSAGES.saveFailed("Teiid Transport " + transport.getName()), (String)response.getFailureDescription());
                }
                SubsystemPresenter.this.loadTransports();
            }

            public void onFailure(Throwable caught) {
                super.onFailure(caught);
                SubsystemPresenter.this.loadTransports();
            }
        });
    }

    public void deleteTransport(final Transport transport) {
        ModelNode operation = new ModelNode();
        operation.get("address").set(Baseadress.get());
        operation.get("address").add("subsystem", "teiid");
        operation.get("address").add("transport", transport.getName());
        operation.get("operation").set("remove");
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onSuccess(DMRResponse dmrResponse) {
                ModelNode result = dmrResponse.get();
                if (ModelNodeUtil.indicatesSuccess((ModelNode)result)) {
                    Console.info((String)Console.MESSAGES.deleted("Teiid Transport " + transport.getName()));
                } else {
                    Console.error((String)Console.MESSAGES.deletionFailed("Teiid Transport " + transport.getName()), (String)result.toString());
                }
                SubsystemPresenter.this.loadTransports();
            }

            public void onFailure(Throwable caught) {
                super.onFailure(caught);
                SubsystemPresenter.this.loadTransports();
            }
        });
    }

    private void loadTranslators() {
        ModelNode operation = new ModelNode();
        operation.get("operation").set("read-children-resources");
        operation.get("address").set(Baseadress.get());
        operation.get("address").add("subsystem", "teiid");
        operation.get("child-type").set("translator");
        operation.get("recursive").set(true);
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onSuccess(DMRResponse dmrResponse) {
                ModelNode response = dmrResponse.get();
                List children = response.get("result").asPropertyList();
                ArrayList<Translator> translators = new ArrayList<Translator>(children.size());
                for (Property child : children) {
                    ModelNode model = child.getValue();
                    Translator translator = (Translator)SubsystemPresenter.this.translatorAdapter.fromDMR(model);
                    translator.setName(child.getName());
                    translators.add(translator);
                }
                ((MyView)SubsystemPresenter.this.getView()).setTranslators(translators);
            }

            public void onFailure(Throwable caught) {
                Console.error((String)"Failed to retrieve configuration for Teiid translators", (String)caught.getMessage());
            }
        });
    }

    public void saveTranslator(final Translator translator, Map<String, Object> changeset) {
        ModelNode address = new ModelNode();
        address.get("operation").set("write-attribute");
        address.get("address").set(Baseadress.get());
        address.get("address").add("subsystem", "teiid");
        address.get("address").add("translator", translator.getName());
        ModelNode operation = this.translatorAdapter.fromChangeset(changeset, address, new ModelNode[0]);
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onSuccess(DMRResponse result) {
                ModelNode response = result.get();
                boolean success = response.get("outcome").asString().equals("success");
                if (success) {
                    Console.info((String)Console.MESSAGES.saved("Teiid Translator " + translator.getName()));
                } else {
                    Console.error((String)Console.MESSAGES.saveFailed("Teiid Translator " + translator.getName()), (String)response.getFailureDescription());
                }
                SubsystemPresenter.this.loadTranslators();
            }

            public void onFailure(Throwable caught) {
                super.onFailure(caught);
                SubsystemPresenter.this.loadTranslators();
            }
        });
    }

    public void deleteTranslator(final Translator translator) {
        ModelNode operation = new ModelNode();
        operation.get("address").set(Baseadress.get());
        operation.get("address").add("subsystem", "teiid");
        operation.get("address").add("translator", translator.getName());
        operation.get("operation").set("remove");
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onSuccess(DMRResponse dmrResponse) {
                ModelNode result = dmrResponse.get();
                if (ModelNodeUtil.indicatesSuccess((ModelNode)result)) {
                    Console.info((String)Console.MESSAGES.deleted("Teiid Translator " + translator.getName()));
                } else {
                    Console.error((String)Console.MESSAGES.deletionFailed("Teiid Translator " + translator.getName()), (String)result.toString());
                }
                SubsystemPresenter.this.loadTranslators();
            }

            public void onFailure(Throwable caught) {
                super.onFailure(caught);
                SubsystemPresenter.this.loadTranslators();
            }
        });
    }

    public void createTranslator(final Translator translator) {
        ModelNode address = new ModelNode();
        address.get("address").set(Baseadress.get());
        address.get("address").add("subsystem", "teiid");
        address.get("address").add("translator", translator.getName());
        ModelNode operation = this.translatorAdapter.fromEntity((Object)translator);
        operation.get("operation").set("add");
        operation.get("address").set(address.get("address").asObject());
        operation.remove("name");
        this.dispatcher.execute((Action)new DMRAction(operation), (AsyncCallback)new SimpleCallback<DMRResponse>(){

            public void onSuccess(DMRResponse dmrResponse) {
                ModelNode result = dmrResponse.get();
                if (ModelNodeUtil.indicatesSuccess((ModelNode)result)) {
                    Console.info((String)Console.MESSAGES.added("Teiid Translator " + translator.getName()));
                } else {
                    Console.error((String)Console.MESSAGES.addingFailed("Teiid Translator " + translator.getName()), (String)result.toString());
                }
                SubsystemPresenter.this.loadTranslators();
            }

            public void onFailure(Throwable caught) {
                Console.error((String)Console.MESSAGES.addingFailed("Teiid Translator " + translator.getName()), (String)caught.getMessage());
                SubsystemPresenter.this.loadTranslators();
            }
        });
    }

    public static interface MyView
    extends View {
        public void setPresenter(SubsystemPresenter var1);

        public void setConfigurationBean(SubsystemConfiguration var1);

        public void addLogger(String var1);

        public void deleteLogger(String var1);

        public void loggingStatus(String var1, TeiidLogger var2);

        public void logHandlerAdded(String var1, boolean var2);

        public void logHandlerRemoved(String var1, boolean var2);

        public void loggerAdded(String var1, boolean var2);

        public void loggerRemoved(String var1, boolean var2);

        public void setLogHandlerStatus(String var1, String var2, boolean var3, boolean var4);

        public void setTransports(List<Transport> var1);

        public void setTranslators(List<Translator> var1);
    }

    @SubsystemExtension(name="Teiid", group="Teiid", key="teiid")
    @RequiredResources(resources={"{selected.profile}/subsystem=teiid"})
    @SearchIndex(keywords={"teiid", "vdb"})
    @ProxyCodeSplit
    @NameToken(value={"teiid"})
    public static interface MyProxy
    extends Proxy<SubsystemPresenter>,
    Place {
    }
}

