/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.console.client.teiid.runtime;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.AttachEvent;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.ListDataProvider;
import edu.ycp.cs.dh.acegwt.client.ace.AceEditor;
import edu.ycp.cs.dh.acegwt.client.ace.AceEditorMode;
import edu.ycp.cs.dh.acegwt.client.ace.AceEditorTheme;
import java.util.ArrayList;
import java.util.List;
import org.jboss.as.console.client.Console;
import org.jboss.as.console.client.teiid.model.VDB;
import org.jboss.as.console.client.teiid.runtime.VDBPresenter;
import org.jboss.as.console.client.teiid.runtime.VDBView;
import org.jboss.as.console.client.widgets.tabs.DefaultTabLayoutPanel;
import org.jboss.ballroom.client.widgets.forms.ComboBoxItem;
import org.jboss.ballroom.client.widgets.tables.DefaultCellTable;
import org.jboss.ballroom.client.widgets.tables.DefaultPager;
import org.jboss.ballroom.client.widgets.tools.ToolButton;
import org.jboss.ballroom.client.widgets.tools.ToolStrip;
import org.jboss.dmr.client.ModelNode;

public class SQLWorkbenchEditor {
    private AceEditor editor;
    private DefaultTabLayoutPanel resultPanelTabs;
    private VDBPresenter presenter;
    private ComboBoxItem vdbSelector;

    public void setPresenter(VDBPresenter presenter) {
        this.presenter = presenter;
    }

    public void setVDBList(List<VDB> vdblist) {
        this.vdbSelector.setValueMap(this.getVdbNames(vdblist));
    }

    public Widget createWidget(final VDBPresenter presenter) {
        this.presenter = presenter;
        ToolStrip toolStrip = new ToolStrip();
        toolStrip.addToolButtonRight(new ToolButton(Console.CONSTANTS.common_label_refresh(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                presenter.getVDBs();
            }
        }));
        VerticalPanel workBenchPanel = new VerticalPanel();
        workBenchPanel.setBorderWidth(1);
        workBenchPanel.setSpacing(10);
        HorizontalPanel toolbarPanel = new HorizontalPanel();
        toolbarPanel.getElement().getStyle().setPadding(10.0, Style.Unit.PX);
        Label vdbNameLabel = new Label("VDB Name");
        vdbNameLabel.getElement().setAttribute("style", "margin-top:10px;margin-bottom:10px;margin-right:10px;font-weight:bold;");
        toolbarPanel.add((Widget)vdbNameLabel);
        this.vdbSelector = new ComboBoxItem("type", "Type");
        this.vdbSelector.setDefaultToFirstOption(true);
        toolbarPanel.add(this.vdbSelector.asWidget());
        ToolButton applyBtn = new ToolButton("Run", new ClickHandler(){

            public void onClick(ClickEvent arg0) {
                String sqlCommand = SQLWorkbenchEditor.this.editor.getText();
                String name = SQLWorkbenchEditor.this.vdbSelector.getValue();
                if (!sqlCommand.trim().isEmpty()) {
                    SQLWorkbenchEditor.this.setSqlResult(sqlCommand, name);
                }
            }
        });
        toolbarPanel.add((Widget)applyBtn);
        Label descriptionLabel = new Label("   Enter SQL in below window, then select the text and click Run");
        vdbNameLabel.getElement().setAttribute("style", "margin-top:10px;margin-bottom:10px;margin-right:10px;");
        toolbarPanel.add((Widget)descriptionLabel);
        workBenchPanel.add((Widget)toolbarPanel);
        workBenchPanel.setCellHeight((Widget)toolbarPanel, "50px");
        this.editor = new AceEditor(){

            public native String getText();
        };
        this.editor.setHeight("200px");
        this.editor.addAttachHandler(new AttachEvent.Handler(){

            public void onAttachOrDetach(AttachEvent event) {
                if (event.isAttached()) {
                    Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                        public void execute() {
                            SQLWorkbenchEditor.this.editor.startEditor();
                            SQLWorkbenchEditor.this.editor.setAutocompleteEnabled(true);
                            SQLWorkbenchEditor.this.editor.setShowGutter(true);
                            SQLWorkbenchEditor.this.editor.setShowPrintMargin(false);
                            SQLWorkbenchEditor.this.editor.setMode(AceEditorMode.SQL);
                            SQLWorkbenchEditor.this.editor.setTheme(AceEditorTheme.TWILIGHT);
                            SQLWorkbenchEditor.this.editor.setFontSize("11px");
                        }
                    });
                }
            }
        });
        HorizontalPanel editorPanel = new HorizontalPanel();
        editorPanel.setStyleName("fill-layout-width");
        editorPanel.add((Widget)this.editor);
        workBenchPanel.add((Widget)editorPanel);
        workBenchPanel.setCellHeight((Widget)editorPanel, "200px");
        this.resultPanelTabs = new DefaultTabLayoutPanel(40.0, Style.Unit.PX, true, true);
        this.resultPanelTabs.addStyleName("default-tabpanel");
        VerticalPanel resultPanel = new VerticalPanel();
        resultPanel.add((Widget)new HTML("<h3> No Results</h3>"));
        this.resultPanelTabs.add((Widget)resultPanel, "No Results");
        workBenchPanel.add((Widget)this.resultPanelTabs);
        return workBenchPanel.asWidget();
    }

    public void setSqlResult(String sqlCommand, String vdb) {
        int index = vdb.indexOf(" version:");
        this.presenter.executeQuery(vdb.substring(0, index), vdb.substring(index + 9), sqlCommand, "SQLWorkbench");
    }

    public <T> void setQueryResults(List<T> results, String sql, String clazz) {
        if (clazz.equals("SQLWorkbench")) {
            DefaultCellTable<ModelNode> resultTable = VDBView.buildSQLResultTable(results);
            ListDataProvider resultProvider = new ListDataProvider();
            resultProvider.addDataDisplay(resultTable);
            resultProvider.setList(results);
            VerticalPanel resultTab = new VerticalPanel();
            resultTab.setStyleName("fill-layout-width");
            resultTab.setSpacing(2);
            resultTab.add((Widget)new HTML("<h4>" + sql + "</h4>"));
            DefaultPager resultTablePager = new DefaultPager();
            resultTablePager.setDisplay(resultTable);
            resultTab.add(resultTable);
            resultTab.add((Widget)resultTablePager);
            this.resultPanelTabs.add((Widget)resultTab, sql);
            this.resultPanelTabs.selectTab((Widget)resultTab);
        }
    }

    public <T> void setDDL(List<T> results, String sql, String clazz) {
        if (clazz.equals("SQLWorkbench")) {
            // empty if block
        }
    }

    private String[] getVdbNames(List<VDB> vdblist) {
        ArrayList<String> names = new ArrayList<String>();
        for (VDB item : vdblist) {
            names.add(item.getName() + " version:" + item.getVersion());
        }
        String[] vdbNames = names.toArray(new String[names.size()]);
        return vdbNames;
    }
}

