/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.console.client.teiid.runtime;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.user.client.ui.CaptionPanel;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.HasRows;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.ProvidesKey;
import java.util.ArrayList;
import java.util.Collections;
import org.jboss.as.console.client.teiid.model.ImportedVDB;
import org.jboss.as.console.client.teiid.model.KeyValuePair;
import org.jboss.as.console.client.teiid.model.Model;
import org.jboss.as.console.client.teiid.model.VDB;
import org.jboss.as.console.client.teiid.model.ValidityError;
import org.jboss.as.console.client.teiid.runtime.VDBPresenter;
import org.jboss.as.console.client.teiid.runtime.VDBProvider;
import org.jboss.as.console.client.teiid.runtime.VDBView;
import org.jboss.ballroom.client.widgets.common.DefaultButton;
import org.jboss.ballroom.client.widgets.forms.Form;
import org.jboss.ballroom.client.widgets.forms.FormItem;
import org.jboss.ballroom.client.widgets.forms.TextItem;
import org.jboss.ballroom.client.widgets.tables.DefaultCellTable;
import org.jboss.ballroom.client.widgets.tables.DefaultPager;

public class VDBSummaryTab
extends VDBProvider {
    private VDBPresenter presenter;

    public VDBSummaryTab(VDBPresenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public VerticalPanel getPanel(DefaultCellTable vdbTable) {
        Form form = new Form(VDB.class);
        form.setNumColumns(2);
        form.setEnabled(false);
        TextItem description = new TextItem("description", "Description");
        form.setFields(new FormItem[]{description});
        form.bind((CellTable)vdbTable);
        Label errorLabel = new Label("Errors");
        errorLabel.getElement().setAttribute("style", "margin-top:10px;margin-bottom:10px;font-weight:bold;");
        DefaultCellTable<ValidityError> errorTable = VDBView.buildErrorTable();
        final ListDataProvider errorProvider = new ListDataProvider();
        errorProvider.addDataDisplay(errorTable);
        VDBView.onTableSectionChange(vdbTable, new VDBView.TableSelectionCallback<VDB>(){

            @Override
            public void onSelectionChange(VDB vdb) {
                ArrayList<ValidityError> errorList = new ArrayList<ValidityError>();
                if (vdb != null) {
                    for (Model m : vdb.getModels()) {
                        for (ValidityError ve : m.getValidityErrors()) {
                            if (!ve.getSeverity().equals("ERROR")) continue;
                            errorList.add(ve);
                        }
                    }
                }
                errorProvider.setList(errorList);
            }
        });
        DefaultPager errorsTablePager = new DefaultPager();
        errorsTablePager.setDisplay(errorTable);
        CaptionPanel connectionTypePanel = this.createConnectionTypePanel(vdbTable);
        Label importVDBLabel = new Label("Imported VDBs");
        importVDBLabel.getElement().setAttribute("style", "margin-top:10px;margin-bottom:10px;font-weight:bold;");
        DefaultCellTable importedVDBTable = VDBSummaryTab.buildImportVDBTable();
        final ListDataProvider importedVDBProvider = new ListDataProvider();
        importedVDBProvider.addDataDisplay((HasData)importedVDBTable);
        VDBView.onTableSectionChange(vdbTable, new VDBView.TableSelectionCallback<VDB>(){

            @Override
            public void onSelectionChange(VDB vdb) {
                if (!vdb.getVDBImports().isEmpty()) {
                    importedVDBProvider.setList(vdb.getVDBImports());
                } else {
                    importedVDBProvider.getList().clear();
                }
            }
        });
        DefaultPager importedVDBTablePager = new DefaultPager();
        importedVDBTablePager.setDisplay((HasRows)importedVDBTable);
        Label propertiesLabel = new Label("Properties");
        propertiesLabel.getElement().setAttribute("style", "margin-top:10px;margin-bottom:10px;font-weight:bold;");
        DefaultCellTable<KeyValuePair> propertiesTable = VDBView.buildPropertiesTable();
        final ListDataProvider propertyProvider = new ListDataProvider();
        propertyProvider.addDataDisplay(propertiesTable);
        VDBView.onTableSectionChange(vdbTable, new VDBView.TableSelectionCallback<VDB>(){

            @Override
            public void onSelectionChange(VDB vdb) {
                if (!vdb.getProperties().isEmpty()) {
                    propertyProvider.setList(vdb.getProperties());
                } else {
                    propertyProvider.setList(Collections.EMPTY_LIST);
                }
            }
        });
        DefaultPager propertiesTablePager = new DefaultPager();
        propertiesTablePager.setDisplay(propertiesTable);
        VerticalPanel formPanel = new VerticalPanel();
        formPanel.add(form.asWidget());
        formPanel.add(errorLabel.asWidget());
        formPanel.add(errorTable.asWidget());
        formPanel.add((Widget)errorsTablePager);
        formPanel.add((Widget)connectionTypePanel);
        formPanel.add(importVDBLabel.asWidget());
        formPanel.add(importedVDBTable.asWidget());
        formPanel.add((Widget)importedVDBTablePager);
        formPanel.add(propertiesLabel.asWidget());
        formPanel.add(propertiesTable.asWidget());
        formPanel.add((Widget)propertiesTablePager);
        return formPanel;
    }

    static DefaultCellTable buildImportVDBTable() {
        DefaultCellTable table = new DefaultCellTable(4, (ProvidesKey)new ProvidesKey<ImportedVDB>(){

            public Object getKey(ImportedVDB item) {
                return item.getName() + "_" + item.getVersion();
            }
        });
        TextColumn<ImportedVDB> nameColumn = new TextColumn<ImportedVDB>(){

            public String getValue(ImportedVDB record) {
                return record.getName();
            }
        };
        TextColumn<ImportedVDB> versionColumn = new TextColumn<ImportedVDB>(){

            public String getValue(ImportedVDB record) {
                return String.valueOf(record.getVersion());
            }
        };
        TextColumn<ImportedVDB> policiesImported = new TextColumn<ImportedVDB>(){

            public String getValue(ImportedVDB record) {
                return String.valueOf(record.isImportPolicies());
            }
        };
        table.setTitle("Imported VDBS");
        table.addColumn((Column)nameColumn, "VDB Name");
        table.addColumn((Column)versionColumn, "VDB Version");
        table.addColumn((Column)policiesImported, "Inherit Data Role Policies?");
        return table;
    }

    private CaptionPanel createConnectionTypePanel(DefaultCellTable vdbTable) {
        CaptionPanel captionPanel = new CaptionPanel("Connection Type");
        final RadioButton noneBtn = new RadioButton("ConnectionType", "None - disallow new connections");
        final RadioButton byVersionBtn = new RadioButton("ConnectionType", "By Version - Allow with version or earliest versioned vdb when no other vdb marked as ANY");
        final RadioButton byAnyBtn = new RadioButton("ConnectionType", "Any - Allow with or without a version");
        DefaultButton applyBtn = new DefaultButton("Apply", new ClickHandler(){

            public void onClick(ClickEvent arg0) {
                if (noneBtn.getValue().booleanValue()) {
                    VDBSummaryTab.this.changeConnectionType("NONE");
                } else if (byVersionBtn.getValue().booleanValue()) {
                    VDBSummaryTab.this.changeConnectionType("BY_VERSION");
                } else {
                    VDBSummaryTab.this.changeConnectionType("ANY");
                }
            }
        });
        VerticalPanel connTypePanel = new VerticalPanel();
        connTypePanel.add((Widget)noneBtn);
        connTypePanel.add((Widget)byVersionBtn);
        connTypePanel.add((Widget)byAnyBtn);
        connTypePanel.add((Widget)applyBtn);
        connTypePanel.setCellHorizontalAlignment((Widget)noneBtn, HasHorizontalAlignment.ALIGN_LEFT);
        connTypePanel.setCellHorizontalAlignment((Widget)byVersionBtn, HasHorizontalAlignment.ALIGN_LEFT);
        connTypePanel.setCellHorizontalAlignment((Widget)byAnyBtn, HasHorizontalAlignment.ALIGN_LEFT);
        captionPanel.add((Widget)connTypePanel);
        captionPanel.setWidth("40%");
        captionPanel.getElement().setAttribute("style", "font-weight:bold;");
        VDBView.onTableSectionChange(vdbTable, new VDBView.TableSelectionCallback<VDB>(){

            @Override
            public void onSelectionChange(VDB vdb) {
                VDBSummaryTab.this.setVdbName(vdb.getName());
                VDBSummaryTab.this.setVdbVersion(vdb.getVersion());
                if (vdb.getConnectionType().equals("NONE")) {
                    noneBtn.setValue(Boolean.valueOf(true));
                    byVersionBtn.setValue(Boolean.valueOf(false));
                    byAnyBtn.setValue(Boolean.valueOf(false));
                } else if (vdb.getConnectionType().equals("BY_VERSION")) {
                    noneBtn.setValue(Boolean.valueOf(false));
                    byVersionBtn.setValue(Boolean.valueOf(true));
                    byAnyBtn.setValue(Boolean.valueOf(false));
                } else if (vdb.getConnectionType().equals("ANY")) {
                    noneBtn.setValue(Boolean.valueOf(false));
                    byVersionBtn.setValue(Boolean.valueOf(false));
                    byAnyBtn.setValue(Boolean.valueOf(true));
                }
            }
        });
        return captionPanel;
    }

    private void changeConnectionType(String type) {
        this.presenter.changeConnectionType(this.getVdbName(), this.getVdbVersion(), type);
    }
}

