/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.methods.groupadministration;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Objects;
import org.telegram.telegrambots.api.methods.BotApiMethod;
import org.telegram.telegrambots.api.objects.Chat;
import org.telegram.telegrambots.api.objects.replykeyboard.ApiResponse;
import org.telegram.telegrambots.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.exceptions.TelegramApiValidationException;

public class GetChat
extends BotApiMethod<Chat> {
    public static final String PATH = "getChat";
    private static final String CHATID_FIELD = "chat_id";
    @JsonProperty(value="chat_id")
    private String chatId;

    public GetChat() {
    }

    public GetChat(String chatId) {
        this.chatId = (String)Preconditions.checkNotNull((Object)chatId);
    }

    public GetChat(Long chatId) {
        this.chatId = ((Long)Preconditions.checkNotNull((Object)chatId)).toString();
    }

    public String getChatId() {
        return this.chatId;
    }

    public GetChat setChatId(String chatId) {
        this.chatId = chatId;
        return this;
    }

    public GetChat setChatId(Long chatId) {
        Objects.requireNonNull(chatId);
        this.chatId = chatId.toString();
        return this;
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public Chat deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse result = (ApiResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<ApiResponse<Chat>>(){});
            if (result.getOk().booleanValue()) {
                return (Chat)result.getResult();
            }
            throw new TelegramApiRequestException("Error getting chat", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId == null || this.chatId.isEmpty()) {
            throw new TelegramApiValidationException("ChatId can't be empty", this);
        }
    }

    public String toString() {
        return "GetChat{chatId='" + this.chatId + '\'' + '}';
    }
}

