/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.objects.replykeyboard;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.telegram.telegrambots.api.objects.replykeyboard.ReplyKeyboard;
import org.telegram.telegrambots.api.objects.replykeyboard.buttons.KeyboardRow;
import org.telegram.telegrambots.exceptions.TelegramApiValidationException;

public class ReplyKeyboardMarkup
implements ReplyKeyboard {
    private static final String KEYBOARD_FIELD = "keyboard";
    private static final String RESIZEKEYBOARD_FIELD = "resize_keyboard";
    private static final String ONETIMEKEYBOARD_FIELD = "one_time_keyboard";
    private static final String SELECTIVE_FIELD = "selective";
    @JsonProperty(value="keyboard")
    private List<KeyboardRow> keyboard = new ArrayList<KeyboardRow>();
    @JsonProperty(value="resize_keyboard")
    private Boolean resizeKeyboard;
    @JsonProperty(value="one_time_keyboard")
    private Boolean oneTimeKeyboard;
    @JsonProperty(value="selective")
    private Boolean selective;

    public List<KeyboardRow> getKeyboard() {
        return this.keyboard;
    }

    public ReplyKeyboardMarkup setKeyboard(List<KeyboardRow> keyboard) {
        this.keyboard = keyboard;
        return this;
    }

    public Boolean getResizeKeyboard() {
        return this.resizeKeyboard;
    }

    public ReplyKeyboardMarkup setResizeKeyboard(Boolean resizeKeyboard) {
        this.resizeKeyboard = resizeKeyboard;
        return this;
    }

    public Boolean getOneTimeKeyboard() {
        return this.oneTimeKeyboard;
    }

    public ReplyKeyboardMarkup setOneTimeKeyboard(Boolean oneTimeKeyboard) {
        this.oneTimeKeyboard = oneTimeKeyboard;
        return this;
    }

    public Boolean getSelective() {
        return this.selective;
    }

    public ReplyKeyboardMarkup setSelective(Boolean selective) {
        this.selective = selective;
        return this;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.keyboard == null) {
            throw new TelegramApiValidationException("Keyboard parameter can't be null", this);
        }
        for (KeyboardRow keyboardButtons : this.keyboard) {
            keyboardButtons.validate();
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReplyKeyboardMarkup)) {
            return false;
        }
        ReplyKeyboardMarkup replyKeyboardMarkup = (ReplyKeyboardMarkup)o;
        return Objects.equals(this.keyboard, replyKeyboardMarkup.keyboard) && Objects.equals(this.oneTimeKeyboard, replyKeyboardMarkup.oneTimeKeyboard) && Objects.equals(this.resizeKeyboard, replyKeyboardMarkup.resizeKeyboard) && Objects.equals(this.selective, replyKeyboardMarkup.selective);
    }

    public int hashCode() {
        return Objects.hash(this.keyboard, this.oneTimeKeyboard, this.resizeKeyboard, this.selective);
    }

    public String toString() {
        return "ReplyKeyboardMarkup{keyboard=" + this.keyboard + ", resizeKeyboard=" + this.resizeKeyboard + ", oneTimeKeyboard=" + this.oneTimeKeyboard + ", selective=" + this.selective + '}';
    }
}

