/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import org.telegram.telegrambots.meta.api.interfaces.Validable;
import org.telegram.telegrambots.meta.api.objects.ApiResponse;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;

public abstract class PartialBotApiMethod<T extends Serializable>
implements Validable {
    @JsonIgnore
    protected static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public abstract T deserializeResponse(String var1) throws TelegramApiRequestException;

    public T deserializeResponse(String answer, Class<T> returnClass) throws TelegramApiRequestException {
        JavaType type = OBJECT_MAPPER.getTypeFactory().constructType(returnClass);
        return this.deserializeResponseInternal(answer, type);
    }

    public <K extends Serializable> T deserializeResponseArray(String answer, Class<K> returnClass) throws TelegramApiRequestException {
        CollectionType collectionType = OBJECT_MAPPER.getTypeFactory().constructCollectionType(ArrayList.class, returnClass);
        return this.deserializeResponseInternal(answer, (JavaType)collectionType);
    }

    protected <K extends Serializable> T deserializeResponseSerializable(String answer, Class<K> returnClass) throws TelegramApiRequestException {
        JavaType type = OBJECT_MAPPER.getTypeFactory().constructType(returnClass);
        return this.deserializeResponseInternal(answer, type);
    }

    private T deserializeResponseInternal(String answer, JavaType type) throws TelegramApiRequestException {
        try {
            JavaType responseType = OBJECT_MAPPER.getTypeFactory().constructParametricType(ApiResponse.class, new JavaType[]{type});
            ApiResponse result = (ApiResponse)OBJECT_MAPPER.readValue(answer, responseType);
            if (result.getOk().booleanValue()) {
                return (T)((Serializable)result.getResult());
            }
            throw new TelegramApiRequestException(String.format("Error executing %s query", this.getClass().getName()), result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @JsonProperty(value="method")
    public abstract String getMethod();
}

