/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.passport.dataerror;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.objects.passport.dataerror.PassportElementError;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonDeserialize
public class PassportElementErrorUnspecified
implements PassportElementError {
    private static final String SOURCE_FIELD = "source";
    private static final String TYPE_FIELD = "type";
    private static final String ELEMENTHASH_FIELD = "element_hash";
    private static final String MESSAGE_FIELD = "message";
    @JsonProperty(value="source")
    private final String source = "unspecified";
    @JsonProperty(value="type")
    @NonNull
    private String type;
    @JsonProperty(value="element_hash")
    @NonNull
    private String elementHash;
    @JsonProperty(value="message")
    @NonNull
    private String message;

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.elementHash == null || this.elementHash.isEmpty()) {
            throw new TelegramApiValidationException("Element hash parameter can't be empty", this);
        }
        if (this.message == null || this.message.isEmpty()) {
            throw new TelegramApiValidationException("Message parameter can't be empty", this);
        }
        if (this.type == null || this.type.isEmpty()) {
            throw new TelegramApiValidationException("Type parameter can't be empty", this);
        }
    }

    public static PassportElementErrorUnspecifiedBuilder builder() {
        return new PassportElementErrorUnspecifiedBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PassportElementErrorUnspecified)) {
            return false;
        }
        PassportElementErrorUnspecified other = (PassportElementErrorUnspecified)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$elementHash = this.getElementHash();
        String other$elementHash = other.getElementHash();
        if (this$elementHash == null ? other$elementHash != null : !this$elementHash.equals(other$elementHash)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PassportElementErrorUnspecified;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $elementHash = this.getElementHash();
        result = result * 59 + ($elementHash == null ? 43 : $elementHash.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    public String getSource() {
        return this.source;
    }

    @NonNull
    public String getType() {
        return this.type;
    }

    @NonNull
    public String getElementHash() {
        return this.elementHash;
    }

    @NonNull
    public String getMessage() {
        return this.message;
    }

    @JsonProperty(value="type")
    public void setType(@NonNull String type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.type = type;
    }

    @JsonProperty(value="element_hash")
    public void setElementHash(@NonNull String elementHash) {
        if (elementHash == null) {
            throw new NullPointerException("elementHash is marked non-null but is null");
        }
        this.elementHash = elementHash;
    }

    @JsonProperty(value="message")
    public void setMessage(@NonNull String message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        this.message = message;
    }

    public String toString() {
        return "PassportElementErrorUnspecified(source=" + this.getSource() + ", type=" + this.getType() + ", elementHash=" + this.getElementHash() + ", message=" + this.getMessage() + ")";
    }

    public PassportElementErrorUnspecified() {
    }

    public PassportElementErrorUnspecified(@NonNull String type, @NonNull String elementHash, @NonNull String message) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (elementHash == null) {
            throw new NullPointerException("elementHash is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        this.type = type;
        this.elementHash = elementHash;
        this.message = message;
    }

    public static class PassportElementErrorUnspecifiedBuilder {
        private String type;
        private String elementHash;
        private String message;

        PassportElementErrorUnspecifiedBuilder() {
        }

        @JsonProperty(value="type")
        public PassportElementErrorUnspecifiedBuilder type(@NonNull String type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type = type;
            return this;
        }

        @JsonProperty(value="element_hash")
        public PassportElementErrorUnspecifiedBuilder elementHash(@NonNull String elementHash) {
            if (elementHash == null) {
                throw new NullPointerException("elementHash is marked non-null but is null");
            }
            this.elementHash = elementHash;
            return this;
        }

        @JsonProperty(value="message")
        public PassportElementErrorUnspecifiedBuilder message(@NonNull String message) {
            if (message == null) {
                throw new NullPointerException("message is marked non-null but is null");
            }
            this.message = message;
            return this;
        }

        public PassportElementErrorUnspecified build() {
            return new PassportElementErrorUnspecified(this.type, this.elementHash, this.message);
        }

        public String toString() {
            return "PassportElementErrorUnspecified.PassportElementErrorUnspecifiedBuilder(type=" + this.type + ", elementHash=" + this.elementHash + ", message=" + this.message + ")";
        }
    }
}

