/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.clickhouse;

import java.time.Duration;
import java.util.HashSet;
import java.util.Set;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.wait.strategy.HttpWaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class ClickHouseContainer
extends JdbcDatabaseContainer<ClickHouseContainer> {
    private static final String NAME = "clickhouse";
    static final String CLICKHOUSE_CLICKHOUSE_SERVER = "clickhouse/clickhouse-server";
    private static final DockerImageName CLICKHOUSE_IMAGE_NAME = DockerImageName.parse((String)"clickhouse/clickhouse-server");
    static final Integer HTTP_PORT = 8123;
    static final Integer NATIVE_PORT = 9000;
    private static final String DRIVER_CLASS_NAME = "com.clickhouse.jdbc.ClickHouseDriver";
    private static final String JDBC_URL_PREFIX = "jdbc:clickhouse://";
    private static final String TEST_QUERY = "SELECT 1";
    static final String DEFAULT_USER = "default";
    static final String DEFAULT_PASSWORD = "";
    private String databaseName = "default";
    private String username = "default";
    private String password = "";

    public ClickHouseContainer(String dockerImageName) {
        this(DockerImageName.parse((String)dockerImageName));
    }

    public ClickHouseContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{CLICKHOUSE_IMAGE_NAME});
        this.addExposedPorts(new int[]{HTTP_PORT, NATIVE_PORT});
        this.waitStrategy = new HttpWaitStrategy().forStatusCode(200).forResponsePredicate("Ok."::equals).withStartupTimeout(Duration.ofMinutes(1L));
    }

    protected void configure() {
        this.withEnv("CLICKHOUSE_DB", this.databaseName);
        this.withEnv("CLICKHOUSE_USER", this.username);
        this.withEnv("CLICKHOUSE_PASSWORD", this.password);
    }

    public Set<Integer> getLivenessCheckPortNumbers() {
        return new HashSet<Integer>(this.getMappedPort(HTTP_PORT));
    }

    public String getDriverClassName() {
        return DRIVER_CLASS_NAME;
    }

    public String getJdbcUrl() {
        return JDBC_URL_PREFIX + this.getHost() + ":" + this.getMappedPort(HTTP_PORT) + "/" + this.databaseName + this.constructUrlParameters("?", "&");
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getTestQueryString() {
        return TEST_QUERY;
    }

    public ClickHouseContainer withUsername(String username) {
        this.username = username;
        return this;
    }

    public ClickHouseContainer withPassword(String password) {
        this.password = password;
        return this;
    }

    public ClickHouseContainer withDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }
}

