/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.consul;

import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.Capability;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class ConsulContainer
extends GenericContainer<ConsulContainer> {
    private static final DockerImageName DEFAULT_OLD_IMAGE_NAME = DockerImageName.parse((String)"consul");
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"hashicorp/consul");
    private static final int CONSUL_HTTP_PORT = 8500;
    private static final int CONSUL_GRPC_PORT = 8502;
    private List<String> initCommands = new ArrayList<String>();
    private String[] startConsulCmd = new String[]{"agent", "-dev", "-client", "0.0.0.0"};

    public ConsulContainer(String dockerImageName) {
        this(DockerImageName.parse((String)dockerImageName));
    }

    public ConsulContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_OLD_IMAGE_NAME, DEFAULT_IMAGE_NAME});
        this.setWaitStrategy((WaitStrategy)Wait.forHttp((String)"/v1/status/leader").forPort(8500).forStatusCode(200));
        this.withCreateContainerCmdModifier(cmd -> cmd.getHostConfig().withCapAdd(new Capability[]{Capability.IPC_LOCK}));
        this.withEnv("CONSUL_ADDR", "http://0.0.0.0:8500");
        this.withCommand(this.startConsulCmd);
        this.withExposedPorts(new Integer[]{8500, 8502});
    }

    protected void containerIsStarted(InspectContainerResponse containerInfo) {
        this.runConsulCommands();
    }

    private void runConsulCommands() {
        if (!this.initCommands.isEmpty()) {
            String commands = this.initCommands.stream().map(command -> "consul " + command).collect(Collectors.joining(" && "));
            try {
                Container.ExecResult execResult = this.execInContainer(new String[]{"/bin/sh", "-c", commands});
                if (execResult.getExitCode() != 0) {
                    this.logger().error("Failed to execute these init commands {}. Exit code {}. Stdout {}. Stderr {}", new Object[]{this.initCommands, execResult.getExitCode(), execResult.getStdout(), execResult.getStderr()});
                }
            }
            catch (IOException | InterruptedException e) {
                this.logger().error("Failed to execute these init commands {}. Exception message: {}", this.initCommands, (Object)e.getMessage());
            }
        }
    }

    public ConsulContainer withConsulCommand(String ... commands) {
        this.initCommands.addAll(Arrays.asList(commands));
        return (ConsulContainer)this.self();
    }
}

