/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.couchbase;

import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.CouchbaseCluster;
import com.couchbase.client.java.bucket.BucketType;
import com.couchbase.client.java.cluster.BucketSettings;
import com.couchbase.client.java.cluster.DefaultBucketSettings;
import com.couchbase.client.java.query.N1qlParams;
import com.couchbase.client.java.query.N1qlQuery;
import com.couchbase.client.java.query.consistency.ScanConsistency;
import org.junit.After;
import org.testcontainers.couchbase.CouchbaseContainer;

public abstract class AbstractCouchbaseTest {
    public static final String TEST_BUCKET = "test";
    public static final String DEFAULT_PASSWORD = "password";
    private Bucket bucket;

    @After
    public void clear() {
        if (this.getCouchbaseContainer().isIndex() && this.getCouchbaseContainer().isQuery() && this.getCouchbaseContainer().isPrimaryIndex()) {
            this.getBucket().query((N1qlQuery)N1qlQuery.simple((String)String.format("DELETE FROM `%s`", this.getBucket().name()), (N1qlParams)N1qlParams.build().consistency(ScanConsistency.STATEMENT_PLUS)));
        } else {
            this.getBucket().bucketManager().flush();
        }
    }

    protected abstract CouchbaseContainer getCouchbaseContainer();

    protected static CouchbaseContainer initCouchbaseContainer(String imageName) {
        CouchbaseContainer couchbaseContainer = imageName == null ? new CouchbaseContainer() : new CouchbaseContainer(imageName);
        couchbaseContainer.withNewBucket(AbstractCouchbaseTest.getDefaultBucketSettings());
        return couchbaseContainer;
    }

    protected static BucketSettings getDefaultBucketSettings() {
        return DefaultBucketSettings.builder().enableFlush(true).name(TEST_BUCKET).password(DEFAULT_PASSWORD).quota(100).replicas(0).type(BucketType.COUCHBASE).build();
    }

    protected synchronized Bucket getBucket() {
        if (this.bucket == null) {
            this.bucket = this.openBucket(TEST_BUCKET, DEFAULT_PASSWORD);
        }
        return this.bucket;
    }

    private Bucket openBucket(String bucketName, String password) {
        CouchbaseCluster cluster = this.getCouchbaseContainer().getCouchbaseCluster();
        return cluster.openBucket(bucketName, password);
    }
}

