/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.couchbase;

import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.message.cluster.GetClusterConfigRequest;
import com.couchbase.client.core.message.cluster.GetClusterConfigResponse;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.java.Bucket;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.rnorth.ducttape.TimeoutException;
import org.rnorth.ducttape.unreliables.Unreliables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.ContainerLaunchException;
import org.testcontainers.containers.wait.strategy.AbstractWaitStrategy;

public class CouchbaseQueryServiceWaitStrategy
extends AbstractWaitStrategy {
    private static final Logger log = LoggerFactory.getLogger(CouchbaseQueryServiceWaitStrategy.class);
    private final Bucket bucket;

    public CouchbaseQueryServiceWaitStrategy(Bucket bucket) {
        this.bucket = bucket;
        this.startupTimeout = Duration.ofSeconds(120L);
    }

    protected void waitUntilReady() {
        log.info("Waiting for {} seconds for QUERY service", (Object)this.startupTimeout.getSeconds());
        try {
            Unreliables.retryUntilSuccess((int)((int)this.startupTimeout.getSeconds()), (TimeUnit)TimeUnit.SECONDS, () -> {
                this.getRateLimiter().doWhenReady(() -> {
                    GetClusterConfigResponse clusterConfig = (GetClusterConfigResponse)this.bucket.core().send((CouchbaseRequest)new GetClusterConfigRequest()).toBlocking().single();
                    boolean queryServiceEnabled = clusterConfig.config().bucketConfig(this.bucket.name()).serviceEnabled(ServiceType.QUERY);
                    if (!queryServiceEnabled) {
                        throw new ContainerLaunchException("Query service not ready yet");
                    }
                });
                return true;
            });
        }
        catch (TimeoutException e) {
            throw new ContainerLaunchException("Timed out waiting for QUERY service");
        }
    }
}

