/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.couchbase;

public class BucketDefinition {
    private final String name;
    private boolean flushEnabled = false;
    private boolean queryPrimaryIndex = true;
    private int quota = 100;
    private int numReplicas = 0;

    public BucketDefinition(String name) {
        this.name = name;
    }

    public BucketDefinition withReplicas(int numReplicas) {
        if (numReplicas < 0 || numReplicas > 3) {
            throw new IllegalArgumentException("The number of replicas must be between 0 and 3 (inclusive)");
        }
        this.numReplicas = numReplicas;
        return this;
    }

    public BucketDefinition withFlushEnabled(boolean flushEnabled) {
        this.flushEnabled = flushEnabled;
        return this;
    }

    public BucketDefinition withQuota(int quota) {
        if (quota < 100) {
            throw new IllegalArgumentException("Bucket quota cannot be less than 100MB!");
        }
        this.quota = quota;
        return this;
    }

    public BucketDefinition withPrimaryIndex(boolean create) {
        this.queryPrimaryIndex = create;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasFlushEnabled() {
        return this.flushEnabled;
    }

    public boolean hasPrimaryIndex() {
        return this.queryPrimaryIndex;
    }

    public int getQuota() {
        return this.quota;
    }

    public int getNumReplicas() {
        return this.numReplicas;
    }
}

