/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import com.github.dockerjava.api.command.InspectContainerResponse;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.traits.LinkableContainer;
import org.testcontainers.delegate.DatabaseDelegate;
import org.testcontainers.ext.ScriptUtils;
import org.testcontainers.jdbc.JdbcDatabaseDelegate;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.MountableFile;

public abstract class JdbcDatabaseContainer<SELF extends JdbcDatabaseContainer<SELF>>
extends GenericContainer<SELF>
implements LinkableContainer {
    private static final Object DRIVER_LOAD_MUTEX = new Object();
    private Driver driver;
    private List<String> initScriptPaths = new ArrayList<String>();
    protected Map<String, String> parameters = new HashMap<String, String>();
    protected Map<String, String> urlParameters = new HashMap<String, String>();
    private int startupTimeoutSeconds = 120;
    private int connectTimeoutSeconds = 120;
    private static final String QUERY_PARAM_SEPARATOR = "&";

    public JdbcDatabaseContainer(@NonNull String dockerImageName) {
        this(DockerImageName.parse((String)dockerImageName));
        if (dockerImageName == null) {
            throw new NullPointerException("dockerImageName is marked non-null but is null");
        }
    }

    public JdbcDatabaseContainer(@NonNull Future<String> image) {
        super(image);
        if (image == null) {
            throw new NullPointerException("image is marked non-null but is null");
        }
    }

    public JdbcDatabaseContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
    }

    public abstract String getDriverClassName();

    public abstract String getJdbcUrl();

    public String getDatabaseName() {
        throw new UnsupportedOperationException();
    }

    public abstract String getUsername();

    public abstract String getPassword();

    protected abstract String getTestQueryString();

    public SELF withUsername(String username) {
        throw new UnsupportedOperationException();
    }

    public SELF withPassword(String password) {
        throw new UnsupportedOperationException();
    }

    public SELF withDatabaseName(String dbName) {
        throw new UnsupportedOperationException();
    }

    public SELF withUrlParam(String paramName, String paramValue) {
        this.urlParameters.put(paramName, paramValue);
        return (SELF)((Object)((JdbcDatabaseContainer)this.self()));
    }

    public SELF withStartupTimeoutSeconds(int startupTimeoutSeconds) {
        this.startupTimeoutSeconds = startupTimeoutSeconds;
        return (SELF)((Object)((JdbcDatabaseContainer)this.self()));
    }

    public SELF withConnectTimeoutSeconds(int connectTimeoutSeconds) {
        this.connectTimeoutSeconds = connectTimeoutSeconds;
        return (SELF)((Object)((JdbcDatabaseContainer)this.self()));
    }

    public SELF withInitScript(String initScriptPath) {
        this.initScriptPaths = new ArrayList<String>();
        this.initScriptPaths.add(initScriptPath);
        return (SELF)((Object)((JdbcDatabaseContainer)this.self()));
    }

    public SELF withInitScripts(String ... initScriptPaths) {
        return this.withInitScripts(Arrays.asList(initScriptPaths));
    }

    public SELF withInitScripts(Iterable<String> initScriptPaths) {
        this.initScriptPaths = new ArrayList<String>();
        initScriptPaths.forEach(this.initScriptPaths::add);
        return (SELF)((Object)((JdbcDatabaseContainer)this.self()));
    }

    protected void waitUntilContainerStarted() {
        this.logger().info("Waiting for database connection to become available at {} using query '{}'", (Object)this.getJdbcUrl(), (Object)this.getTestQueryString());
        long start = System.nanoTime();
        Exception lastConnectionException = null;
        while (System.nanoTime() - start < TimeUnit.SECONDS.toNanos(this.startupTimeoutSeconds)) {
            if (!this.isRunning()) {
                Thread.sleep(100L);
                continue;
            }
            try {
                Connection connection = this.createConnection("");
                Throwable throwable = null;
                try {
                    Statement statement = connection.createStatement();
                    Throwable throwable2 = null;
                    try {
                        boolean testQuerySucceeded = statement.execute(this.getTestQueryString());
                        if (!testQuerySucceeded) continue;
                        return;
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (statement == null) continue;
                        if (throwable2 != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        statement.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (connection == null) continue;
                    if (throwable != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    connection.close();
                }
            }
            catch (NoDriverFoundException e) {
                throw e;
            }
            catch (Exception e) {
                lastConnectionException = e;
                this.logger().debug("Failure when trying test query", (Throwable)e);
                Thread.sleep(100L);
            }
        }
        throw new IllegalStateException(String.format("Container is started, but cannot be accessed by (JDBC URL: %s), please check container logs", this.getJdbcUrl()), lastConnectionException);
    }

    protected void containerIsStarted(InspectContainerResponse containerInfo) {
        this.logger().info("Container is started (JDBC URL: {})", (Object)this.getJdbcUrl());
        this.runInitScriptIfRequired();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Driver getJdbcDriverInstance() throws NoDriverFoundException {
        Object object = DRIVER_LOAD_MUTEX;
        synchronized (object) {
            if (this.driver == null) {
                try {
                    this.driver = (Driver)Class.forName(this.getDriverClassName()).newInstance();
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    throw new NoDriverFoundException("Could not get Driver", e);
                }
            }
        }
        return this.driver;
    }

    public Connection createConnection(String queryString) throws SQLException, NoDriverFoundException {
        return this.createConnection(queryString, new Properties());
    }

    public Connection createConnection(String queryString, Properties info) throws SQLException, NoDriverFoundException {
        Properties properties = new Properties(info);
        properties.put("user", this.getUsername());
        properties.put("password", this.getPassword());
        String url = this.constructUrlForConnection(queryString);
        Driver jdbcDriverInstance = this.getJdbcDriverInstance();
        SQLException lastException = null;
        try {
            long start = System.nanoTime();
            while (System.nanoTime() - start < TimeUnit.SECONDS.toNanos(this.connectTimeoutSeconds) && this.isRunning()) {
                try {
                    this.logger().debug("Trying to create JDBC connection using {} to {} with properties: {}", new Object[]{jdbcDriverInstance.getClass().getName(), url, properties});
                    return jdbcDriverInstance.connect(url, properties);
                }
                catch (SQLException e) {
                    lastException = e;
                    Thread.sleep(100L);
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        throw new SQLException("Could not create new connection", lastException);
    }

    protected String constructUrlForConnection(String queryString) {
        String baseUrl = this.getJdbcUrl();
        if ("".equals(queryString)) {
            return baseUrl;
        }
        if (!queryString.startsWith("?")) {
            throw new IllegalArgumentException("The '?' character must be included");
        }
        return baseUrl.contains("?") ? baseUrl + QUERY_PARAM_SEPARATOR + queryString.substring(1) : baseUrl + queryString;
    }

    protected String constructUrlParameters(String startCharacter, String delimiter) {
        return this.constructUrlParameters(startCharacter, delimiter, "");
    }

    protected String constructUrlParameters(String startCharacter, String delimiter, String endCharacter) {
        String urlParameters = "";
        if (!this.urlParameters.isEmpty()) {
            String additionalParameters = this.urlParameters.entrySet().stream().map(Object::toString).collect(Collectors.joining(delimiter));
            urlParameters = startCharacter + additionalParameters + endCharacter;
        }
        return urlParameters;
    }

    @Deprecated
    protected void optionallyMapResourceParameterAsVolume(@NotNull String paramName, @NotNull String pathNameInContainer, @NotNull String defaultResource) {
        this.optionallyMapResourceParameterAsVolume(paramName, pathNameInContainer, defaultResource, null);
    }

    protected void optionallyMapResourceParameterAsVolume(@NotNull String paramName, @NotNull String pathNameInContainer, @NotNull String defaultResource, @Nullable Integer fileMode) {
        String resourceName = this.parameters.getOrDefault(paramName, defaultResource);
        if (resourceName != null) {
            MountableFile mountableFile = MountableFile.forClasspathResource((String)resourceName, (Integer)fileMode);
            this.withCopyFileToContainer(mountableFile, pathNameInContainer);
        }
    }

    protected void runInitScriptIfRequired() {
        this.initScriptPaths.forEach(path -> ScriptUtils.runInitScript((DatabaseDelegate)this.getDatabaseDelegate(), (String)path));
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public void addParameter(String paramName, String value) {
        this.parameters.put(paramName, value);
    }

    @Deprecated
    protected int getStartupTimeoutSeconds() {
        return this.startupTimeoutSeconds;
    }

    @Deprecated
    protected int getConnectTimeoutSeconds() {
        return this.connectTimeoutSeconds;
    }

    protected DatabaseDelegate getDatabaseDelegate() {
        return new JdbcDatabaseDelegate(this, "");
    }

    public static class NoDriverFoundException
    extends RuntimeException {
        public NoDriverFoundException(String message, Throwable e) {
            super(message, e);
        }
    }
}

