/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.kafka;

import com.github.dockerjava.api.command.InspectContainerResponse;
import java.util.ArrayList;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.images.builder.Transferable;
import org.testcontainers.utility.DockerImageName;

public class KafkaContainer
extends GenericContainer<KafkaContainer> {
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"apache/kafka");
    private static final DockerImageName APACHE_KAFKA_NATIVE_IMAGE_NAME = DockerImageName.parse((String)"apache/kafka-native");
    private static final int KAFKA_PORT = 9092;
    private static final String DEFAULT_INTERNAL_TOPIC_RF = "1";
    private static final String STARTER_SCRIPT = "/tmp/testcontainers_start.sh";
    private static final String DEFAULT_CLUSTER_ID = "4L6g3nShT-eMCtK--X86sw";

    public KafkaContainer(String imageName) {
        this(DockerImageName.parse((String)imageName));
    }

    public KafkaContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME, APACHE_KAFKA_NATIVE_IMAGE_NAME});
        this.withExposedPorts(new Integer[]{9092});
        this.withEnv("CLUSTER_ID", DEFAULT_CLUSTER_ID);
        this.withEnv("KAFKA_LISTENERS", "PLAINTEXT://0.0.0.0:9092,BROKER://0.0.0.0:9093, CONTROLLER://0.0.0.0:9094");
        this.withEnv("KAFKA_LISTENER_SECURITY_PROTOCOL_MAP", "BROKER:PLAINTEXT,PLAINTEXT:PLAINTEXT,CONTROLLER:PLAINTEXT");
        this.withEnv("KAFKA_INTER_BROKER_LISTENER_NAME", "BROKER");
        this.withEnv("KAFKA_PROCESS_ROLES", "broker,controller");
        this.withEnv("KAFKA_CONTROLLER_LISTENER_NAMES", "CONTROLLER");
        this.withEnv("KAFKA_NODE_ID", DEFAULT_INTERNAL_TOPIC_RF);
        this.withEnv("KAFKA_OFFSETS_TOPIC_REPLICATION_FACTOR", DEFAULT_INTERNAL_TOPIC_RF);
        this.withEnv("KAFKA_OFFSETS_TOPIC_NUM_PARTITIONS", DEFAULT_INTERNAL_TOPIC_RF);
        this.withEnv("KAFKA_TRANSACTION_STATE_LOG_REPLICATION_FACTOR", DEFAULT_INTERNAL_TOPIC_RF);
        this.withEnv("KAFKA_TRANSACTION_STATE_LOG_MIN_ISR", DEFAULT_INTERNAL_TOPIC_RF);
        this.withEnv("KAFKA_LOG_FLUSH_INTERVAL_MESSAGES", "9223372036854775807");
        this.withEnv("KAFKA_GROUP_INITIAL_REBALANCE_DELAY_MS", "0");
        this.withCommand(new String[]{"sh", "-c", "while [ ! -f /tmp/testcontainers_start.sh ]; do sleep 0.1; done; /tmp/testcontainers_start.sh"});
        this.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Transitioning from RECOVERY to RUNNING.*", (int)1));
    }

    protected void configure() {
        String firstNetworkAlias = this.getNetworkAliases().stream().findFirst().orElse(null);
        String networkAlias = this.getNetwork() != null ? firstNetworkAlias : "localhost";
        String controllerQuorumVoters = String.format("%s@%s:9094", this.getEnvMap().get("KAFKA_NODE_ID"), networkAlias);
        this.withEnv("KAFKA_CONTROLLER_QUORUM_VOTERS", controllerQuorumVoters);
    }

    protected void containerIsStarting(InspectContainerResponse containerInfo) {
        String brokerAdvertisedListener = String.format("BROKER://%s:%s", containerInfo.getConfig().getHostName(), "9093");
        ArrayList<String> advertisedListeners = new ArrayList<String>();
        advertisedListeners.add("PLAINTEXT://" + this.getBootstrapServers());
        advertisedListeners.add(brokerAdvertisedListener);
        String kafkaAdvertisedListeners = String.join((CharSequence)",", advertisedListeners);
        String command = "#!/bin/bash\n";
        command = command + String.format("export KAFKA_ADVERTISED_LISTENERS=%s\n", kafkaAdvertisedListeners);
        command = command + "/etc/kafka/docker/run \n";
        this.copyFileToContainer(Transferable.of((String)command, (int)511), STARTER_SCRIPT);
    }

    public String getBootstrapServers() {
        return String.format("%s:%s", this.getHost(), this.getMappedPort(9092));
    }
}

