/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.kafka;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

class KafkaHelper {
    private static final String DEFAULT_INTERNAL_TOPIC_RF = "1";
    private static final String DEFAULT_CLUSTER_ID = "4L6g3nShT-eMCtK--X86sw";
    private static final String PROTOCOL_PREFIX = "TC";
    static final int KAFKA_PORT = 9092;
    static final String STARTER_SCRIPT = "/tmp/testcontainers_start.sh";
    static final String[] COMMAND = new String[]{"sh", "-c", "while [ ! -f /tmp/testcontainers_start.sh ]; do sleep 0.1; done; /tmp/testcontainers_start.sh"};
    static final WaitStrategy WAIT_STRATEGY = Wait.forLogMessage((String)".*Transitioning from RECOVERY to RUNNING.*", (int)1);

    KafkaHelper() {
    }

    static Map<String, String> envVars() {
        HashMap<String, String> envVars = new HashMap<String, String>();
        envVars.put("CLUSTER_ID", DEFAULT_CLUSTER_ID);
        envVars.put("KAFKA_LISTENERS", "PLAINTEXT://0.0.0.0:9092,BROKER://0.0.0.0:9093,CONTROLLER://0.0.0.0:9094");
        envVars.put("KAFKA_LISTENER_SECURITY_PROTOCOL_MAP", "BROKER:PLAINTEXT,PLAINTEXT:PLAINTEXT,CONTROLLER:PLAINTEXT");
        envVars.put("KAFKA_INTER_BROKER_LISTENER_NAME", "BROKER");
        envVars.put("KAFKA_PROCESS_ROLES", "broker,controller");
        envVars.put("KAFKA_CONTROLLER_LISTENER_NAMES", "CONTROLLER");
        envVars.put("KAFKA_NODE_ID", DEFAULT_INTERNAL_TOPIC_RF);
        String controllerQuorumVoters = String.format("%s@localhost:9094", envVars.get("KAFKA_NODE_ID"));
        envVars.put("KAFKA_CONTROLLER_QUORUM_VOTERS", controllerQuorumVoters);
        envVars.put("KAFKA_OFFSETS_TOPIC_REPLICATION_FACTOR", DEFAULT_INTERNAL_TOPIC_RF);
        envVars.put("KAFKA_OFFSETS_TOPIC_NUM_PARTITIONS", DEFAULT_INTERNAL_TOPIC_RF);
        envVars.put("KAFKA_TRANSACTION_STATE_LOG_REPLICATION_FACTOR", DEFAULT_INTERNAL_TOPIC_RF);
        envVars.put("KAFKA_TRANSACTION_STATE_LOG_MIN_ISR", DEFAULT_INTERNAL_TOPIC_RF);
        envVars.put("KAFKA_LOG_FLUSH_INTERVAL_MESSAGES", "9223372036854775807");
        envVars.put("KAFKA_GROUP_INITIAL_REBALANCE_DELAY_MS", "0");
        return envVars;
    }

    static void resolveListeners(GenericContainer<?> kafkaContainer, Set<String> listenersSuppliers) {
        Set listeners = Arrays.stream(((String)kafkaContainer.getEnvMap().get("KAFKA_LISTENERS")).split(",")).collect(Collectors.toSet());
        Set listenerSecurityProtocolMap = Arrays.stream(((String)kafkaContainer.getEnvMap().get("KAFKA_LISTENER_SECURITY_PROTOCOL_MAP")).split(",")).collect(Collectors.toSet());
        ArrayList<String> listenersToTransform = new ArrayList<String>(listenersSuppliers);
        for (int i = 0; i < listenersToTransform.size(); ++i) {
            String protocol = String.format("%s-%d", PROTOCOL_PREFIX, i);
            String listener = (String)listenersToTransform.get(i);
            String listenerHost = listener.split(":")[0];
            String listenerPort = listener.split(":")[1];
            String listenerProtocol = String.format("%s://%s:%s", protocol, listenerHost, listenerPort);
            String protocolMap = String.format("%s:PLAINTEXT", protocol);
            listeners.add(listenerProtocol);
            listenerSecurityProtocolMap.add(protocolMap);
            String host = listener.split(":")[0];
            kafkaContainer.withNetworkAliases(new String[]{host});
        }
        String kafkaListeners = String.join((CharSequence)",", listeners);
        String kafkaListenerSecurityProtocolMap = String.join((CharSequence)",", listenerSecurityProtocolMap);
        kafkaContainer.getEnvMap().put("KAFKA_LISTENERS", kafkaListeners);
        kafkaContainer.getEnvMap().put("KAFKA_LISTENER_SECURITY_PROTOCOL_MAP", kafkaListenerSecurityProtocolMap);
    }

    static List<String> resolveAdvertisedListeners(Set<Supplier<String>> listenerSuppliers) {
        ArrayList<String> advertisedListeners = new ArrayList<String>();
        ArrayList<Supplier<String>> listenersToTransform = new ArrayList<Supplier<String>>(listenerSuppliers);
        for (int i = 0; i < listenersToTransform.size(); ++i) {
            Supplier listenerSupplier = (Supplier)listenersToTransform.get(i);
            String protocol = String.format("%s-%d", PROTOCOL_PREFIX, i);
            String listener = (String)listenerSupplier.get();
            String listenerProtocol = String.format("%s://%s", protocol, listener);
            advertisedListeners.add(listenerProtocol);
        }
        return advertisedListeners;
    }
}

