/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.ollama;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.model.DeviceRequest;
import com.github.dockerjava.api.model.Info;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.utility.DockerImageName;

public class OllamaContainer
extends GenericContainer<OllamaContainer> {
    private static final DockerImageName DOCKER_IMAGE_NAME = DockerImageName.parse((String)"ollama/ollama");

    public OllamaContainer(String image) {
        this(DockerImageName.parse((String)image));
    }

    public OllamaContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DOCKER_IMAGE_NAME});
        Info info = (Info)this.dockerClient.infoCmd().exec();
        Map runtimes = info.getRuntimes();
        if (runtimes != null && runtimes.containsKey("nvidia")) {
            this.withCreateContainerCmdModifier(cmd -> cmd.getHostConfig().withDeviceRequests(Collections.singletonList(new DeviceRequest().withCapabilities(Collections.singletonList(Collections.singletonList("gpu"))).withCount(Integer.valueOf(-1)))));
        }
        this.withExposedPorts(new Integer[]{11434});
    }

    public void commitToImage(String imageName) {
        DockerClient dockerClient;
        List images;
        DockerImageName dockerImageName = DockerImageName.parse((String)this.getDockerImageName());
        if (!dockerImageName.equals((Object)DockerImageName.parse((String)imageName)) && (images = (List)(dockerClient = DockerClientFactory.instance().client()).listImagesCmd().withReferenceFilter(imageName).exec()).isEmpty()) {
            DockerImageName imageModel = DockerImageName.parse((String)imageName);
            dockerClient.commitCmd(this.getContainerId()).withRepository(imageModel.getUnversionedPart()).withLabels(Collections.singletonMap("org.testcontainers.sessionId", "")).withTag(imageModel.getVersionPart()).exec();
        }
    }

    public String getEndpoint() {
        return "http://" + this.getHost() + ":" + this.getMappedPort(11434);
    }
}

