/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.qdrant;

import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class QdrantContainer
extends GenericContainer<QdrantContainer> {
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"qdrant/qdrant");

    public QdrantContainer(String image) {
        this(DockerImageName.parse((String)image));
    }

    public QdrantContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        this.withExposedPorts(new Integer[]{6333, 6334});
        this.waitingFor((WaitStrategy)Wait.forHttp((String)"/readyz").forPort(6333));
    }

    public String getGrpcHostAddress() {
        return this.getHost() + ":" + this.getMappedPort(6334);
    }
}

