/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import com.github.dockerjava.api.command.InspectContainerResponse;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.MountableFile;

public class RabbitMQContainer
extends GenericContainer<RabbitMQContainer> {
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"rabbitmq");
    private static final String DEFAULT_TAG = "3.7.25-management-alpine";
    private static final int DEFAULT_AMQP_PORT = 5672;
    private static final int DEFAULT_AMQPS_PORT = 5671;
    private static final int DEFAULT_HTTPS_PORT = 15671;
    private static final int DEFAULT_HTTP_PORT = 15672;
    private String adminPassword = "guest";
    private String adminUsername = "guest";
    private final List<List<String>> values = new ArrayList<List<String>>();

    @Deprecated
    public RabbitMQContainer() {
        this(DEFAULT_IMAGE_NAME.withTag(DEFAULT_TAG));
    }

    public RabbitMQContainer(String dockerImageName) {
        this(DockerImageName.parse((String)dockerImageName));
    }

    public RabbitMQContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        this.addExposedPorts(new int[]{5672, 5671, 15672, 15671});
        this.waitStrategy = Wait.forLogMessage((String)".*Server startup complete.*", (int)1).withStartupTimeout(Duration.ofSeconds(60L));
    }

    protected void configure() {
        if (this.adminPassword != null) {
            this.addEnv("RABBITMQ_DEFAULT_PASS", this.adminPassword);
        }
    }

    protected void containerIsStarted(InspectContainerResponse containerInfo) {
        this.values.forEach(command -> {
            try {
                Container.ExecResult execResult = this.execInContainer(command.toArray(new String[0]));
                if (execResult.getExitCode() != 0) {
                    this.logger().error("Could not execute command {}: {}", command, (Object)execResult.getStderr());
                }
            }
            catch (IOException | InterruptedException e) {
                this.logger().error("Could not execute command {}: {}", command, (Object)e.getMessage());
            }
        });
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public String getAdminUsername() {
        return this.adminUsername;
    }

    public Integer getAmqpPort() {
        return this.getMappedPort(5672);
    }

    public Integer getAmqpsPort() {
        return this.getMappedPort(5671);
    }

    public Integer getHttpsPort() {
        return this.getMappedPort(15671);
    }

    public Integer getHttpPort() {
        return this.getMappedPort(15672);
    }

    public String getAmqpUrl() {
        return "amqp://" + this.getHost() + ":" + this.getAmqpPort();
    }

    public String getAmqpsUrl() {
        return "amqps://" + this.getHost() + ":" + this.getAmqpsPort();
    }

    public String getHttpUrl() {
        return "http://" + this.getHost() + ":" + this.getHttpPort();
    }

    public String getHttpsUrl() {
        return "https://" + this.getHost() + ":" + this.getHttpsPort();
    }

    public RabbitMQContainer withAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
        return this;
    }

    public RabbitMQContainer withSSL(MountableFile keyFile, MountableFile certFile, MountableFile caFile, SslVerification verify, boolean failIfNoCert, int verificationDepth) {
        return (RabbitMQContainer)this.withSSL(keyFile, certFile, caFile, verify, failIfNoCert).withEnv("RABBITMQ_SSL_DEPTH", String.valueOf(verificationDepth));
    }

    public RabbitMQContainer withSSL(MountableFile keyFile, MountableFile certFile, MountableFile caFile, SslVerification verify, boolean failIfNoCert) {
        return (RabbitMQContainer)this.withSSL(keyFile, certFile, caFile, verify).withEnv("RABBITMQ_SSL_FAIL_IF_NO_PEER_CERT", String.valueOf(failIfNoCert));
    }

    public RabbitMQContainer withSSL(MountableFile keyFile, MountableFile certFile, MountableFile caFile, SslVerification verify) {
        return (RabbitMQContainer)((RabbitMQContainer)((RabbitMQContainer)((RabbitMQContainer)((RabbitMQContainer)((RabbitMQContainer)((RabbitMQContainer)this.withEnv("RABBITMQ_SSL_CACERTFILE", "/etc/rabbitmq/ca_cert.pem")).withEnv("RABBITMQ_SSL_CERTFILE", "/etc/rabbitmq/rabbitmq_cert.pem")).withEnv("RABBITMQ_SSL_KEYFILE", "/etc/rabbitmq/rabbitmq_key.pem")).withEnv("RABBITMQ_SSL_VERIFY", verify.value)).withCopyFileToContainer(certFile, "/etc/rabbitmq/rabbitmq_cert.pem")).withCopyFileToContainer(caFile, "/etc/rabbitmq/ca_cert.pem")).withCopyFileToContainer(keyFile, "/etc/rabbitmq/rabbitmq_key.pem");
    }

    public RabbitMQContainer withPluginsEnabled(String ... pluginNames) {
        ArrayList<String> command = new ArrayList<String>(Arrays.asList("rabbitmq-plugins", "enable"));
        command.addAll(Arrays.asList(pluginNames));
        this.values.add(command);
        return (RabbitMQContainer)this.self();
    }

    public RabbitMQContainer withBinding(String source, String destination) {
        this.values.add(Arrays.asList("rabbitmqadmin", "declare", "binding", "source=" + source, "destination=" + destination));
        return (RabbitMQContainer)this.self();
    }

    public RabbitMQContainer withBinding(String source, String destination, Map<String, Object> arguments, String routingKey, String destinationType) {
        this.values.add(Arrays.asList("rabbitmqadmin", "declare", "binding", "source=" + source, "destination=" + destination, "routing_key=" + routingKey, "destination_type=" + destinationType, "arguments=" + this.toJson(arguments)));
        return (RabbitMQContainer)this.self();
    }

    public RabbitMQContainer withParameter(String component, String name, String value) {
        this.values.add(Arrays.asList("rabbitmqadmin", "declare", "parameter", "component=" + component, "name=" + name, "value=" + value));
        return (RabbitMQContainer)this.self();
    }

    public RabbitMQContainer withPermission(String vhost, String user, String configure, String write, String read) {
        this.values.add(Arrays.asList("rabbitmqadmin", "declare", "permission", "vhost=" + vhost, "user=" + user, "configure=" + configure, "write=" + write, "read=" + read));
        return (RabbitMQContainer)this.self();
    }

    public RabbitMQContainer withUser(String name, String password) {
        this.values.add(Arrays.asList("rabbitmqadmin", "declare", "user", "name=" + name, "password=" + password, "tags="));
        return (RabbitMQContainer)this.self();
    }

    public RabbitMQContainer withUser(String name, String password, Set<String> tags) {
        this.values.add(Arrays.asList("rabbitmqadmin", "declare", "user", "name=" + name, "password=" + password, "tags=" + String.join((CharSequence)",", tags)));
        return (RabbitMQContainer)this.self();
    }

    public RabbitMQContainer withPolicy(String name, String pattern, Map<String, Object> definition) {
        this.values.add(Arrays.asList("rabbitmqadmin", "declare", "policy", "name=" + name, "pattern=" + pattern, "definition=" + this.toJson(definition)));
        return (RabbitMQContainer)this.self();
    }

    public RabbitMQContainer withPolicy(String vhost, String name, String pattern, Map<String, Object> definition) {
        this.values.add(Arrays.asList("rabbitmqadmin", "declare", "policy", "--vhost=" + vhost, "name=" + name, "pattern=" + pattern, "definition=" + this.toJson(definition)));
        return (RabbitMQContainer)this.self();
    }

    public RabbitMQContainer withPolicy(String name, String pattern, Map<String, Object> definition, int priority, String applyTo) {
        this.values.add(Arrays.asList("rabbitmqadmin", "declare", "policy", "name=" + name, "pattern=" + pattern, "priority=" + priority, "apply-to=" + applyTo, "definition=" + this.toJson(definition)));
        return (RabbitMQContainer)this.self();
    }

    public RabbitMQContainer withOperatorPolicy(String name, String pattern, Map<String, Object> definition) {
        this.values.add(new ArrayList<String>(Arrays.asList("rabbitmqadmin", "declare", "operator_policy", "name=" + name, "pattern=" + pattern, "definition=" + this.toJson(definition))));
        return (RabbitMQContainer)this.self();
    }

    public RabbitMQContainer withOperatorPolicy(String name, String pattern, Map<String, Object> definition, int priority, String applyTo) {
        this.values.add(Arrays.asList("rabbitmqadmin", "declare", "operator_policy", "name=" + name, "pattern=" + pattern, "priority=" + priority, "apply-to=" + applyTo, "definition=" + this.toJson(definition)));
        return (RabbitMQContainer)this.self();
    }

    public RabbitMQContainer withVhost(String name) {
        this.values.add(Arrays.asList("rabbitmqadmin", "declare", "vhost", "name=" + name));
        return (RabbitMQContainer)this.self();
    }

    public RabbitMQContainer withVhost(String name, boolean tracing) {
        this.values.add(Arrays.asList("rabbitmqadmin", "declare", "vhost", "name=" + name, "tracing=" + tracing));
        return (RabbitMQContainer)this.self();
    }

    public RabbitMQContainer withVhostLimit(String vhost, String name, int value) {
        this.values.add(Arrays.asList("rabbitmqadmin", "declare", "vhost_limit", "vhost=" + vhost, "name=" + name, "value=" + value));
        return (RabbitMQContainer)this.self();
    }

    public RabbitMQContainer withQueue(String name) {
        this.values.add(Arrays.asList("rabbitmqadmin", "declare", "queue", "name=" + name));
        return (RabbitMQContainer)this.self();
    }

    public RabbitMQContainer withQueue(String name, boolean autoDelete, boolean durable, Map<String, Object> arguments) {
        this.values.add(Arrays.asList("rabbitmqadmin", "declare", "queue", "name=" + name, "auto_delete=" + autoDelete, "durable=" + durable, "arguments=" + this.toJson(arguments)));
        return (RabbitMQContainer)this.self();
    }

    public RabbitMQContainer withExchange(String name, String type) {
        this.values.add(Arrays.asList("rabbitmqadmin", "declare", "exchange", "name=" + name, "type=" + type));
        return (RabbitMQContainer)this.self();
    }

    public RabbitMQContainer withExchange(String name, String type, boolean autoDelete, boolean internal, boolean durable, Map<String, Object> arguments) {
        this.values.add(Arrays.asList("rabbitmqadmin", "declare", "exchange", "name=" + name, "type=" + type, "auto_delete=" + autoDelete, "internal=" + internal, "durable=" + durable, "arguments=" + this.toJson(arguments)));
        return (RabbitMQContainer)this.self();
    }

    public RabbitMQContainer withExchange(String vhost, String name, String type, boolean autoDelete, boolean internal, boolean durable, Map<String, Object> arguments) {
        this.values.add(Arrays.asList("rabbitmqadmin", "--vhost=" + vhost, "declare", "exchange", "name=" + name, "type=" + type, "auto_delete=" + autoDelete, "internal=" + internal, "durable=" + durable, "arguments=" + this.toJson(arguments)));
        return (RabbitMQContainer)this.self();
    }

    public RabbitMQContainer withRabbitMQConfig(MountableFile rabbitMQConf) {
        return this.withRabbitMQConfigSysctl(rabbitMQConf);
    }

    public RabbitMQContainer withRabbitMQConfigSysctl(MountableFile rabbitMQConf) {
        this.withEnv("RABBITMQ_CONFIG_FILE", "/etc/rabbitmq/rabbitmq-custom");
        return (RabbitMQContainer)this.withCopyFileToContainer(rabbitMQConf, "/etc/rabbitmq/rabbitmq-custom.conf");
    }

    public RabbitMQContainer withRabbitMQConfigErlang(MountableFile rabbitMQConf) {
        this.withEnv("RABBITMQ_CONFIG_FILE", "/etc/rabbitmq/rabbitmq-custom.config");
        return (RabbitMQContainer)this.withCopyFileToContainer(rabbitMQConf, "/etc/rabbitmq/rabbitmq-custom.config");
    }

    @NotNull
    private String toJson(Map<String, Object> arguments) {
        try {
            return new ObjectMapper().writeValueAsString(arguments);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to convert arguments into json: " + e.getMessage(), e);
        }
    }

    public static enum SslVerification {
        VERIFY_NONE("verify_none"),
        VERIFY_PEER("verify_peer");

        private final String value;

        private SslVerification(String value) {
            this.value = value;
        }
    }
}

