/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.redpanda;

import com.github.dockerjava.api.command.InspectContainerResponse;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.images.builder.Transferable;
import org.testcontainers.shaded.freemarker.template.Configuration;
import org.testcontainers.shaded.freemarker.template.Template;
import org.testcontainers.utility.ComparableVersion;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.MountableFile;

public class RedpandaContainer
extends GenericContainer<RedpandaContainer> {
    private static final String REDPANDA_FULL_IMAGE_NAME = "docker.redpanda.com/redpandadata/redpanda";
    @Deprecated
    private static final String REDPANDA_OLD_FULL_IMAGE_NAME = "docker.redpanda.com/vectorized/redpanda";
    private static final DockerImageName REDPANDA_IMAGE = DockerImageName.parse((String)"docker.redpanda.com/redpandadata/redpanda");
    @Deprecated
    private static final DockerImageName REDPANDA_OLD_IMAGE = DockerImageName.parse((String)"docker.redpanda.com/vectorized/redpanda");
    private static final int REDPANDA_PORT = 9092;
    private static final int REDPANDA_ADMIN_PORT = 9644;
    private static final int SCHEMA_REGISTRY_PORT = 8081;
    private static final int REST_PROXY_PORT = 8082;
    private boolean enableAuthorization;
    private String authenticationMethod = "none";
    private String schemaRegistryAuthenticationMethod = "none";
    private final List<String> superusers = new ArrayList<String>();
    private final Set<Supplier<Listener>> listenersValueSupplier = new HashSet<Supplier<Listener>>();

    public RedpandaContainer(String image) {
        this(DockerImageName.parse((String)image));
    }

    public RedpandaContainer(DockerImageName imageName) {
        super(imageName);
        imageName.assertCompatibleWith(new DockerImageName[]{REDPANDA_OLD_IMAGE, REDPANDA_IMAGE});
        boolean isLessThanBaseVersion = new ComparableVersion(imageName.getVersionPart()).isLessThan("v22.2.1");
        if (REDPANDA_FULL_IMAGE_NAME.equals(imageName.getUnversionedPart()) && isLessThanBaseVersion) {
            throw new IllegalArgumentException("Redpanda version must be >= v22.2.1");
        }
        this.withExposedPorts(new Integer[]{9092, 9644, 8081, 8082});
        this.withCreateContainerCmdModifier(cmd -> {
            cmd.withEntrypoint(new String[0]);
            cmd.withUser("root:root");
        });
        this.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Successfully started Redpanda!.*", (int)1));
        this.withCopyFileToContainer(MountableFile.forClasspathResource((String)"testcontainers/entrypoint-tc.sh", (Integer)448), "/entrypoint-tc.sh");
        this.withCommand(new String[]{"/entrypoint-tc.sh", "redpanda", "start", "--mode=dev-container", "--smp=1", "--memory=1G"});
    }

    protected void configure() {
        this.listenersValueSupplier.stream().map(Supplier::get).map(Listener::getAddress).forEach(xva$0 -> this.withNetworkAliases(new String[]{xva$0}));
    }

    protected void containerIsStarting(InspectContainerResponse containerInfo) {
        super.containerIsStarting(containerInfo);
        Configuration cfg = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
        cfg.setClassLoaderForTemplateLoading(((Object)((Object)this)).getClass().getClassLoader(), "testcontainers");
        cfg.setDefaultEncoding("UTF-8");
        this.copyFileToContainer(this.getBootstrapFile(cfg), "/etc/redpanda/.bootstrap.yaml");
        this.copyFileToContainer(this.getRedpandaFile(cfg), "/etc/redpanda/redpanda.yaml");
    }

    public String getBootstrapServers() {
        return String.format("PLAINTEXT://%s:%s", this.getHost(), this.getMappedPort(9092));
    }

    public String getSchemaRegistryAddress() {
        return String.format("http://%s:%s", this.getHost(), this.getMappedPort(8081));
    }

    public String getAdminAddress() {
        return String.format("http://%s:%s", this.getHost(), this.getMappedPort(9644));
    }

    public String getRestProxyAddress() {
        return String.format("http://%s:%s", this.getHost(), this.getMappedPort(8082));
    }

    public RedpandaContainer enableAuthorization() {
        this.enableAuthorization = true;
        return this;
    }

    public RedpandaContainer enableSasl() {
        this.authenticationMethod = "sasl";
        return this;
    }

    public RedpandaContainer enableSchemaRegistryHttpBasicAuth() {
        this.schemaRegistryAuthenticationMethod = "http_basic";
        return this;
    }

    public RedpandaContainer withSuperuser(String username) {
        this.superusers.add(username);
        return this;
    }

    public RedpandaContainer withListener(Supplier<String> listenerSupplier) {
        String[] parts = listenerSupplier.get().split(":");
        this.listenersValueSupplier.add(() -> new Listener(parts[0], Integer.parseInt(parts[1])));
        return this;
    }

    private Transferable getBootstrapFile(Configuration cfg) {
        HashMap<String, Object> kafkaApi = new HashMap<String, Object>();
        kafkaApi.put("enableAuthorization", this.enableAuthorization);
        kafkaApi.put("superusers", this.superusers);
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("kafkaApi", kafkaApi);
        String file = this.resolveTemplate(cfg, "bootstrap.yaml.ftl", root);
        return Transferable.of((String)file, (int)448);
    }

    private Transferable getRedpandaFile(Configuration cfg) {
        List listeners = this.listenersValueSupplier.stream().map(Supplier::get).map(listener -> {
            HashMap<String, Object> listenerMap = new HashMap<String, Object>();
            listenerMap.put("address", listener.getAddress());
            listenerMap.put("port", listener.getPort());
            listenerMap.put("authentication_method", this.authenticationMethod);
            return listenerMap;
        }).collect(Collectors.toList());
        HashMap<String, Object> kafkaApi = new HashMap<String, Object>();
        kafkaApi.put("authenticationMethod", this.authenticationMethod);
        kafkaApi.put("enableAuthorization", this.enableAuthorization);
        kafkaApi.put("advertisedHost", this.getHost());
        kafkaApi.put("advertisedPort", this.getMappedPort(9092));
        kafkaApi.put("listeners", listeners);
        HashMap<String, String> schemaRegistry = new HashMap<String, String>();
        schemaRegistry.put("authenticationMethod", this.schemaRegistryAuthenticationMethod);
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("kafkaApi", kafkaApi);
        root.put("schemaRegistry", schemaRegistry);
        String file = this.resolveTemplate(cfg, "redpanda.yaml.ftl", root);
        return Transferable.of((String)file, (int)448);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private String resolveTemplate(Configuration cfg, String template, Map<String, Object> data) {
        Template temp = cfg.getTemplate(template);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            String string;
            block10: {
                OutputStreamWriter out = new OutputStreamWriter((OutputStream)byteArrayOutputStream, StandardCharsets.UTF_8);
                try {
                    temp.process(data, out);
                    string = new String(byteArrayOutputStream.toByteArray(), StandardCharsets.UTF_8);
                    if (Collections.singletonList(out).get(0) == null) break block10;
                }
                catch (Throwable throwable) {
                    if (Collections.singletonList(out).get(0) != null) {
                        ((Writer)out).close();
                    }
                    throw throwable;
                }
                ((Writer)out).close();
            }
            return string;
        }
        finally {
            if (Collections.singletonList(byteArrayOutputStream).get(0) != null) {
                byteArrayOutputStream.close();
            }
        }
    }

    private static class Listener {
        private String address;
        private int port;

        public String getAddress() {
            return this.address;
        }

        public int getPort() {
            return this.port;
        }

        public void setAddress(String address) {
            this.address = address;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Listener)) {
                return false;
            }
            Listener other = (Listener)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getPort() != other.getPort()) {
                return false;
            }
            String this$address = this.getAddress();
            String other$address = other.getAddress();
            return !(this$address == null ? other$address != null : !this$address.equals(other$address));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Listener;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getPort();
            String $address = this.getAddress();
            result = result * 59 + ($address == null ? 43 : $address.hashCode());
            return result;
        }

        public String toString() {
            return "RedpandaContainer.Listener(address=" + this.getAddress() + ", port=" + this.getPort() + ")";
        }

        public Listener(String address, int port) {
            this.address = address;
            this.port = port;
        }
    }
}

