/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.freemarker.ext.jython;

import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyObject;
import org.testcontainers.shaded.freemarker.ext.jython.JythonModel;
import org.testcontainers.shaded.freemarker.ext.jython.JythonWrapper;
import org.testcontainers.shaded.freemarker.ext.util.ModelFactory;
import org.testcontainers.shaded.freemarker.template.ObjectWrapper;
import org.testcontainers.shaded.freemarker.template.TemplateModel;
import org.testcontainers.shaded.freemarker.template.TemplateModelException;
import org.testcontainers.shaded.freemarker.template.TemplateNumberModel;

public class JythonNumberModel
extends JythonModel
implements TemplateNumberModel {
    static final ModelFactory FACTORY = new ModelFactory(){

        @Override
        public TemplateModel create(Object object, ObjectWrapper wrapper) {
            return new JythonNumberModel((PyObject)object, (JythonWrapper)wrapper);
        }
    };

    public JythonNumberModel(PyObject object, JythonWrapper wrapper) {
        super(object, wrapper);
    }

    @Override
    public Number getAsNumber() throws TemplateModelException {
        try {
            Object value = this.object.__tojava__(Number.class);
            if (value == null || value == Py.NoConversion) {
                return this.object.__float__().getValue();
            }
            return (Number)value;
        }
        catch (PyException e) {
            throw new TemplateModelException((Exception)((Object)e));
        }
    }
}

