/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import com.github.dockerjava.api.command.InspectContainerResponse;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.delegate.YugabyteDBYCQLDelegate;
import org.testcontainers.containers.strategy.YugabyteDBYCQLWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategyTarget;
import org.testcontainers.delegate.DatabaseDelegate;
import org.testcontainers.ext.ScriptUtils;
import org.testcontainers.utility.DockerImageName;

public class YugabyteDBYCQLContainer
extends GenericContainer<YugabyteDBYCQLContainer> {
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"yugabytedb/yugabyte");
    private static final Integer YCQL_PORT = 9042;
    private static final Integer MASTER_DASHBOARD_PORT = 7000;
    private static final Integer TSERVER_DASHBOARD_PORT = 9000;
    private static final String ENTRYPOINT = "bin/yugabyted start --background=false";
    private static final String LOCAL_DC = "datacenter1";
    private String keyspace;
    private String username;
    private String password;
    private String initScript;

    public YugabyteDBYCQLContainer(String imageName) {
        this(DockerImageName.parse((String)imageName));
    }

    public YugabyteDBYCQLContainer(DockerImageName imageName) {
        super(imageName);
        imageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        this.withExposedPorts(new Integer[]{YCQL_PORT, MASTER_DASHBOARD_PORT, TSERVER_DASHBOARD_PORT});
        this.waitingFor(new YugabyteDBYCQLWaitStrategy((WaitStrategyTarget)this).withStartupTimeout(Duration.ofSeconds(60L)));
        this.withCommand(ENTRYPOINT);
    }

    public Set<Integer> getLivenessCheckPortNumbers() {
        return Collections.singleton(this.getMappedPort(YCQL_PORT));
    }

    protected void configure() {
        this.addEnv("YCQL_KEYSPACE", this.keyspace);
        this.addEnv("YCQL_USER", this.username);
        this.addEnv("YCQL_PASSWORD", this.password);
    }

    public YugabyteDBYCQLContainer withInitScript(String initScript) {
        this.initScript = initScript;
        return this;
    }

    public YugabyteDBYCQLContainer withKeyspaceName(String keyspace) {
        this.keyspace = keyspace;
        return this;
    }

    public YugabyteDBYCQLContainer withUsername(String username) {
        this.username = username;
        return this;
    }

    public YugabyteDBYCQLContainer withPassword(String password) {
        this.password = password;
        return this;
    }

    protected void containerIsStarted(InspectContainerResponse containerInfo) {
        if (this.initScript != null) {
            ScriptUtils.runInitScript((DatabaseDelegate)new YugabyteDBYCQLDelegate(this), (String)this.initScript);
        }
    }

    public InetSocketAddress getContactPoint() {
        return new InetSocketAddress(this.getHost(), (int)this.getMappedPort(YCQL_PORT));
    }

    public String getLocalDc() {
        return LOCAL_DC;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getKeyspace() {
        return this.keyspace;
    }
}

