/*
 * Decompiled with CFR 0.152.
 */
package ise.antelope.tasks;

import ise.antelope.tasks.BooleanConditionTask;
import ise.antelope.tasks.Break;
import ise.antelope.tasks.Breakable;
import ise.antelope.tasks.ElseTask;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;

public class IfTask
extends Task
implements TaskContainer,
Breakable {
    private boolean exists = true;
    private String value = null;
    private String name = null;
    private Task else_task = null;
    private Task condition_task = null;
    private Vector tasks = new Vector();
    private boolean doBreak = false;

    public void init() {
        this.getProject().addTaskDefinition("else", ElseTask.class);
        this.getProject().addTaskDefinition("bool", BooleanConditionTask.class);
        this.getProject().addTaskDefinition("break", Break.class);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setExists(String exists) {
        this.getProject();
        this.exists = Project.toBoolean((String)exists);
    }

    public void setBreak(boolean b) {
        this.doBreak = b;
    }

    public void addBreak(Break b) {
        this.addTask(b);
    }

    public void addElse(ElseTask elseTask) {
        this.addTask(elseTask);
    }

    public void addBool(BooleanConditionTask boolTask) {
        this.addTask((Task)boolTask);
    }

    public boolean doBreak() {
        return this.doBreak;
    }

    public void maybeConfigure() throws BuildException {
        if (this.isInvalid()) {
            super.maybeConfigure();
        } else {
            this.getRuntimeConfigurableWrapper().maybeConfigure(this.getProject(), false);
        }
    }

    public void addTask(Task task) {
        if (task instanceof ElseTask) {
            if (this.else_task == null) {
                this.else_task = task;
                return;
            }
            throw new BuildException("Only one <else> allowed per If.");
        }
        if (task instanceof BooleanConditionTask) {
            if (this.condition_task == null) {
                this.condition_task = task;
                return;
            }
            throw new BuildException("Only one <bool> allowed per If.");
        }
        this.tasks.addElement(task);
    }

    public void execute() throws BuildException {
        if (this.condition_task == null) {
            if (this.name == null || this.name.equals("")) {
                throw new BuildException("The 'name' attribute is required.");
            }
            String prop_value = this.getProject().getProperty(this.name);
            if (this.exists && prop_value == null) {
                this.doElse();
                return;
            }
            if (!this.exists && prop_value != null) {
                this.doElse();
                return;
            }
            if (this.value != null) {
                if (prop_value == null) {
                    this.doElse();
                    return;
                }
                if (prop_value != null && !prop_value.equals(this.value)) {
                    this.doElse();
                    return;
                }
            }
            this.doIf();
        } else if (((BooleanConditionTask)this.condition_task).eval()) {
            this.doIf();
        } else {
            this.doElse();
        }
    }

    private void doIf() throws BuildException {
        Enumeration e = this.tasks.elements();
        while (e.hasMoreElements()) {
            Task task = (Task)e.nextElement();
            if (task instanceof Breakable) {
                task.perform();
                if (!((Breakable)task).doBreak()) continue;
                this.setBreak(true);
                return;
            }
            task.perform();
        }
    }

    private void doElse() throws BuildException {
        if (this.else_task == null) {
            return;
        }
        this.else_task.perform();
    }
}

